/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.UserPrincipal;
import java.util.Stack;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;

public class TestCommand
extends SimpleJShellBuiltin {
    public TestCommand() {
        super("test", 10, Options.class);
    }

    private static Path evalPath(Eval a, JShellExecutionContext context) {
        return Paths.get(TestCommand.evalStr(a, context), new String[0]);
    }

    private static String evalStr(Eval a, JShellExecutionContext context) {
        if (a instanceof EvalArg) {
            return ((EvalArg)a).arg.getString();
        }
        return String.valueOf(a.eval(context));
    }

    private static int evalInt(Eval a, JShellExecutionContext context) {
        if (a instanceof EvalArg) {
            return ((EvalArg)a).arg.toElement().getInt();
        }
        return a.eval(context);
    }

    private int getArgsCount(String s) {
        switch (s) {
            case "-n": 
            case "-z": 
            case "-b": 
            case "-c": 
            case "-d": 
            case "-e": 
            case "-f": 
            case "-g": 
            case "-G": 
            case "-h": 
            case "-k": 
            case "-L": 
            case "-N": 
            case "-O": 
            case "-p": 
            case "-r": 
            case "-s": 
            case "-S": 
            case "-t": 
            case "-u": 
            case "-w": 
            case "-x": {
                return 1;
            }
            case "=": 
            case "!=": 
            case "-a": 
            case "-o": 
            case "-eq": 
            case "-ge": 
            case "-gt": 
            case "-le": 
            case "-lt": 
            case "-ne": 
            case "-ef": 
            case "-nt": 
            case "-ot": {
                return 2;
            }
        }
        return -1;
    }

    private int getArgsPrio(String s) {
        switch (s) {
            case "(": {
                return 0;
            }
            case "-n": 
            case "-z": 
            case "-b": 
            case "-c": 
            case "-d": 
            case "-e": 
            case "-f": 
            case "-g": 
            case "-G": 
            case "-h": 
            case "-k": 
            case "-L": 
            case "-N": 
            case "-O": 
            case "-p": 
            case "-r": 
            case "-s": 
            case "-S": 
            case "-t": 
            case "-u": 
            case "-w": 
            case "-x": {
                return 10;
            }
            case "=": 
            case "!=": 
            case "-a": 
            case "-o": 
            case "-eq": 
            case "-ge": 
            case "-gt": 
            case "-le": 
            case "-lt": 
            case "-ne": 
            case "-ef": 
            case "-nt": 
            case "-ot": {
                return 5;
            }
        }
        return -1;
    }

    private void reduce(Stack<String> operators, Stack<Eval> operands, int prio) {
        block4: while (!(operators.isEmpty() || operators.peek().equals("(") || operators.peek().equals("[") || this.getArgsPrio(operators.peek()) < prio)) {
            String op = operators.pop();
            int c = this.getArgsCount(op);
            switch (c) {
                case 1: {
                    operands.push(new EvalUnary(op, operands.pop()));
                    continue block4;
                }
                case 2: {
                    Eval ab = operands.pop();
                    Eval aa = operands.pop();
                    operands.push(new EvalBinary(op, aa, ab));
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unsupported");
        }
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        commandLine.setExpandSimpleOptions(false);
        Options options = (Options)context.getOptions();
        NutsArgument a = commandLine.next();
        switch (a.getString()) {
            case "(": {
                options.operators.add(a.getString());
                return true;
            }
            case ")": {
                this.reduce(options.operators, options.operands, 0);
                if (options.operators.size() < 1 || !options.operators.peek().equals("(")) {
                    throw new IllegalArgumentException("')' has no equivalent '('");
                }
                options.operators.pop();
                return true;
            }
            case "]": {
                this.reduce(options.operators, options.operands, 0);
                if (options.operators.size() > 0 && !options.operators.peek().equals("[")) {
                    throw new IllegalArgumentException("']' has no equivalent '['");
                }
                if (options.operators.size() == 1 && options.operators.peek().equals("[")) {
                    options.operators.pop();
                }
                return true;
            }
        }
        if (this.getArgsCount(a.getString()) > 0) {
            this.reduce(options.operators, options.operands, this.getArgsPrio(a.getString()));
            options.operators.add(a.getString());
        } else {
            options.operands.add(new EvalArg(a));
        }
        return true;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        NutsSession session = context.getSession();
        Options options = (Options)context.getOptions();
        if (options.operands.isEmpty()) {
            this.throwExecutionException("result", 1, session);
        }
        this.reduce(options.operators, options.operands, 0);
        if (options.operands.size() != 1) {
            throw new IllegalArgumentException("missing operand");
        }
        if (!options.operators.isEmpty()) {
            throw new IllegalArgumentException("too many operators");
        }
        int result = options.operands.pop().eval(context);
        if (result != 0) {
            this.throwExecutionException("result", result, session);
        }
    }

    private static class EvalBinary
    extends EvalBase {
        protected Eval arg1;
        protected Eval arg2;

        public EvalBinary(String type, Eval arg1, Eval arg2) {
            super(type);
            this.arg1 = arg1;
            this.arg2 = arg2;
        }

        @Override
        public int eval(JShellExecutionContext context) {
            switch (this.type) {
                case "=": {
                    String s1 = TestCommand.evalStr(this.arg1, context);
                    String s2 = TestCommand.evalStr(this.arg2, context);
                    return s1.equals(s2) ? 0 : 1;
                }
                case "!=": {
                    String s1 = TestCommand.evalStr(this.arg1, context);
                    String s2 = TestCommand.evalStr(this.arg2, context);
                    return !s1.equals(s2) ? 0 : 1;
                }
                case "-a": {
                    int i1 = TestCommand.evalInt(this.arg1, context);
                    if (i1 == 1) {
                        return 1;
                    }
                    int i2 = TestCommand.evalInt(this.arg2, context);
                    return i1 == 0 && i2 == 0 ? 0 : 1;
                }
                case "-o": {
                    int i1 = TestCommand.evalInt(this.arg1, context);
                    if (i1 == 0) {
                        return 0;
                    }
                    int i2 = TestCommand.evalInt(this.arg2, context);
                    return i1 == 0 && i2 == 0 ? 0 : 1;
                }
                case "-eq": {
                    int s1 = TestCommand.evalInt(this.arg1, context);
                    int s2 = TestCommand.evalInt(this.arg2, context);
                    return Integer.compare(s1, s2) == 0 ? 0 : 1;
                }
                case "-gt": {
                    int s1 = TestCommand.evalInt(this.arg1, context);
                    int s2 = TestCommand.evalInt(this.arg2, context);
                    return Integer.compare(s1, s2) > 0 ? 0 : 1;
                }
                case "-ge": {
                    int s1 = TestCommand.evalInt(this.arg1, context);
                    int s2 = TestCommand.evalInt(this.arg2, context);
                    return Integer.compare(s1, s2) >= 0 ? 0 : 1;
                }
                case "-lt": {
                    int s1 = TestCommand.evalInt(this.arg1, context);
                    int s2 = TestCommand.evalInt(this.arg2, context);
                    return Integer.compare(s1, s2) < 0 ? 0 : 1;
                }
                case "-le": {
                    int s1 = TestCommand.evalInt(this.arg1, context);
                    int s2 = TestCommand.evalInt(this.arg2, context);
                    return Integer.compare(s1, s2) <= 0 ? 0 : 1;
                }
                case "-ne": {
                    int s1 = TestCommand.evalInt(this.arg1, context);
                    int s2 = TestCommand.evalInt(this.arg2, context);
                    return Integer.compare(s1, s2) <= 0 ? 0 : 1;
                }
                case "-ef": {
                    Path s1 = TestCommand.evalPath(this.arg1, context);
                    Path s2 = TestCommand.evalPath(this.arg2, context);
                    try {
                        Object at1 = Files.getFileAttributeView(s1, BasicFileAttributeView.class, new LinkOption[0]).readAttributes().fileKey();
                        Object at2 = Files.getFileAttributeView(s2, BasicFileAttributeView.class, new LinkOption[0]).readAttributes().fileKey();
                        return at1 != null && at1.equals(at2) ? 0 : 1;
                    }
                    catch (Exception ex) {
                        return 1;
                    }
                }
                case "-nt": {
                    Path s1 = TestCommand.evalPath(this.arg1, context);
                    Path s2 = TestCommand.evalPath(this.arg2, context);
                    try {
                        FileTime at1 = Files.getFileAttributeView(s1, BasicFileAttributeView.class, new LinkOption[0]).readAttributes().lastModifiedTime();
                        FileTime at2 = Files.getFileAttributeView(s2, BasicFileAttributeView.class, new LinkOption[0]).readAttributes().lastModifiedTime();
                        return at1.compareTo(at2) > 0 ? 0 : 1;
                    }
                    catch (Exception ex) {
                        return 1;
                    }
                }
                case "-ot": {
                    Path s1 = TestCommand.evalPath(this.arg1, context);
                    Path s2 = TestCommand.evalPath(this.arg2, context);
                    try {
                        FileTime at1 = Files.getFileAttributeView(s1, BasicFileAttributeView.class, new LinkOption[0]).readAttributes().lastModifiedTime();
                        FileTime at2 = Files.getFileAttributeView(s2, BasicFileAttributeView.class, new LinkOption[0]).readAttributes().lastModifiedTime();
                        return at1.compareTo(at2) < 0 ? 0 : 1;
                    }
                    catch (Exception ex) {
                        return 1;
                    }
                }
            }
            return 1;
        }
    }

    private static class EvalUnary
    extends EvalBase {
        protected Eval arg;

        public EvalUnary(String type, Eval arg) {
            super(type);
            this.arg = arg;
        }

        @Override
        public int eval(JShellExecutionContext context) {
            switch (this.type) {
                case "!": {
                    return 1 - this.arg.eval(context);
                }
                case "-n": {
                    String pp = TestCommand.evalStr(this.arg, context);
                    return pp.length() > 0 ? 0 : 1;
                }
                case "-z": {
                    String pp = TestCommand.evalStr(this.arg, context);
                    return pp.length() > 0 ? 1 : 0;
                }
                case "-b": {
                    Path pp = TestCommand.evalPath(this.arg, context);
                    return 1;
                }
                case "-c": {
                    Path pp = TestCommand.evalPath(this.arg, context);
                    return 1;
                }
                case "-d": {
                    Path pp = TestCommand.evalPath(this.arg, context);
                    return Files.isDirectory(pp, new LinkOption[0]) ? 0 : 1;
                }
                case "-f": {
                    Path pp = TestCommand.evalPath(this.arg, context);
                    return Files.isRegularFile(pp, new LinkOption[0]) ? 0 : 1;
                }
                case "-e": {
                    Path pp = TestCommand.evalPath(this.arg, context);
                    return Files.exists(pp, new LinkOption[0]) ? 0 : 1;
                }
                case "-g": 
                case "-G": 
                case "-h": 
                case "-L": 
                case "-k": 
                case "-S": 
                case "-t": 
                case "-u": {
                    if (this.arg instanceof EvalArg) {
                        EvalArg a = (EvalArg)this.arg;
                        Path pp = TestCommand.evalPath(this.arg, context);
                        return 1;
                    }
                    return 1;
                }
                case "-N": {
                    try {
                        Path pp = TestCommand.evalPath(this.arg, context);
                        BasicFileAttributeView view = Files.getFileAttributeView(pp, BasicFileAttributeView.class, new LinkOption[0]);
                        BasicFileAttributes attributes = view.readAttributes();
                        FileTime lastAccessTime = attributes.lastAccessTime();
                        FileTime lastModifedTime = attributes.lastModifiedTime();
                        return lastModifedTime.compareTo(lastAccessTime) >= 0 ? 0 : 1;
                    }
                    catch (Exception ex) {
                        return 1;
                    }
                }
                case "-O": {
                    try {
                        Path pp = TestCommand.evalPath(this.arg, context);
                        UserPrincipal up = Files.getOwner(pp, new LinkOption[0]);
                        return up.getName().equals(System.getProperty("user.name")) ? 0 : 1;
                    }
                    catch (Exception ex) {
                        return 1;
                    }
                }
                case "-r": {
                    EvalArg a = (EvalArg)this.arg;
                    String path = a.arg.getString();
                    try {
                        Path pp = TestCommand.evalPath(this.arg, context);
                        return Files.exists(pp, new LinkOption[0]) && Files.isReadable(pp) ? 0 : 1;
                    }
                    catch (Exception ex) {
                        return 1;
                    }
                }
                case "-w": {
                    try {
                        Path pp = TestCommand.evalPath(this.arg, context);
                        return Files.exists(pp, new LinkOption[0]) && Files.isWritable(pp) ? 0 : 1;
                    }
                    catch (Exception ex) {
                        return 1;
                    }
                }
                case "-x": {
                    try {
                        Path pp = TestCommand.evalPath(this.arg, context);
                        return Files.exists(pp, new LinkOption[0]) && Files.isExecutable(pp) ? 0 : 1;
                    }
                    catch (Exception ex) {
                        return 1;
                    }
                }
                case "-s": {
                    try {
                        Path pp = TestCommand.evalPath(this.arg, context);
                        return Files.isRegularFile(pp, new LinkOption[0]) && Files.size(pp) > 0L ? 0 : 1;
                    }
                    catch (Exception ex) {
                        return 1;
                    }
                }
            }
            return 1;
        }
    }

    private static class EvalArg
    extends EvalBase {
        private NutsArgument arg;

        public EvalArg(NutsArgument arg) {
            super("arg");
            this.arg = arg;
        }

        @Override
        public int eval(JShellExecutionContext context) {
            return this.arg.getString().length() > 0 ? 0 : 1;
        }
    }

    public static abstract class EvalBase
    implements Eval {
        protected String type;

        public EvalBase(String type) {
            this.type = type;
        }

        @Override
        public String getType() {
            return this.type;
        }

        public String toString() {
            return this.getType();
        }
    }

    private static class Options {
        Stack<String> operators = new Stack();
        Stack<Eval> operands = new Stack();

        private Options() {
        }
    }

    public static interface Eval {
        public String getType();

        public int eval(JShellExecutionContext var1);
    }
}

