/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;
import net.thevpc.nuts.toolbox.nsh.util.ShellHelper;

public class TailCommand
extends SimpleJShellBuiltin {
    public TailCommand() {
        super("tail", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        NutsSession session = context.getSession();
        NutsArgument a = commandLine.peek();
        if (a.isOption()) {
            if (ShellHelper.isInt(a.getString().substring(1))) {
                options.max = Integer.parseInt(commandLine.next().getString().substring(1));
                return true;
            }
            return false;
        }
        String path = a.getString();
        NutsPath file = NutsPath.of((String)path, (NutsSession)session).toAbsolute(context.getShellContext().getCwd());
        options.files.add(file);
        return true;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        NutsSession session = context.getSession();
        if (options.files.isEmpty()) {
            throw new NutsExecutionException(session, NutsMessage.cstyle((String)"not yet supported", (Object[])new Object[0]), 2);
        }
        for (NutsPath file : options.files) {
            this.tail(file, options.max, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tail(NutsPath file, int max, JShellExecutionContext context) {
        BufferedReader r = null;
        NutsSession session = context.getSession();
        try {
            try {
                r = new BufferedReader(new InputStreamReader(file.getInputStream()));
                String line = null;
                int count = 0;
                LinkedList<String> lines = new LinkedList<String>();
                while ((line = r.readLine()) != null) {
                    lines.add(line);
                    if (++count <= max) continue;
                    lines.remove();
                }
                for (String s : lines) {
                    context.out().println(s);
                }
            }
            finally {
                if (r != null) {
                    r.close();
                }
            }
        }
        catch (IOException ex) {
            throw new NutsExecutionException(session, NutsMessage.cstyle((String)"%s", (Object[])new Object[]{ex}), (Throwable)ex, 100);
        }
    }

    private static class Options {
        int max = 0;
        List<NutsPath> files = new ArrayList<NutsPath>();

        private Options() {
        }
    }
}

