/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.lib.ssh.SShConnection;
import net.thevpc.nuts.lib.ssh.SshListener;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;
import net.thevpc.nuts.toolbox.nsh.util.ShellHelper;

public class SshCommand
extends SimpleJShellBuiltin {
    public SshCommand() {
        super("ssh", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options o = (Options)context.getOptions();
        if (!o.cmd.isEmpty()) {
            o.cmd.add(commandLine.next().getString());
            return true;
        }
        if (commandLine.peek().isNonOption()) {
            if (o.address == null) {
                o.address = commandLine.next().getString();
            } else {
                o.cmd.add(commandLine.next().getString());
            }
            return true;
        }
        NutsArgument a = commandLine.next(new String[]{"--nuts"});
        if (a != null) {
            if (o.acceptDashNuts) {
                o.invokeNuts = true;
            } else {
                o.cmd.add(a.getString());
            }
            return true;
        }
        a = commandLine.next(new String[]{"--nuts-jre"});
        if (a != null) {
            if (o.acceptDashNuts) {
                o.nutsJre = a.getValue().getString();
            } else {
                o.cmd.add(a.getString());
            }
            return true;
        }
        if (o.address == null || commandLine.peek().isNonOption()) {
            o.acceptDashNuts = false;
            o.cmd.add(commandLine.next().getString());
            return true;
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options o = (Options)context.getOptions();
        if (o.address == null) {
            throw new NutsExecutionException(context.getSession(), NutsMessage.cstyle((String)"missing ssh address", (Object[])new Object[0]), 2);
        }
        if (o.cmd.isEmpty()) {
            throw new NutsExecutionException(context.getSession(), NutsMessage.cstyle((String)"missing ssh command. Interactive ssh is not yet supported!", (Object[])new Object[0]), 2);
        }
        NutsSession session = context.getSession();
        ShellHelper.WsSshListener listener = new ShellHelper.WsSshListener(context.getSession());
        try (SShConnection sshSession = new SShConnection(o.address, context.getSession()).addListener((SshListener)listener);){
            ArrayList<String> cmd = new ArrayList<String>();
            if (o.invokeNuts) {
                String workspace = null;
                NutsCommandLine c = NutsCommandLine.of(o.cmd.subList(1, o.cmd.size()), (NutsSession)session);
                NutsArgument arg = null;
                while (c.hasNext()) {
                    arg = c.next(new String[]{"--workspace"});
                    if (arg != null) {
                        workspace = c.requireNonOption().next().getString();
                        continue;
                    }
                    if (c.peek().isNonOption()) break;
                    c.skip();
                }
                if (!NutsBlankable.isBlank((String)o.nutsCommand)) {
                    cmd.add(o.nutsCommand);
                } else {
                    String userHome = null;
                    sshSession.setFailFast(true).setRedirectErrorStream(true).grabOutputString().exec(new String[]{"echo", "$HOME"});
                    userHome = sshSession.getOutputString().trim();
                    if (NutsBlankable.isBlank((String)workspace)) {
                        workspace = userHome + "/.config/nuts/" + "default-workspace";
                    }
                    boolean nutsCommandFound = false;
                    int r = sshSession.setFailFast(false).grabOutputString().setRedirectErrorStream(true).exec(new String[]{"ls", workspace + "/nuts"});
                    if (0 == r) {
                        nutsCommandFound = true;
                    }
                    if (!nutsCommandFound) {
                        Path from = ((NutsDefinition)session.search().addId(session.getWorkspace().getApiId()).getResultDefinitions().required()).getFile();
                        if (from == null) {
                            throw new NutsExecutionException(context.getSession(), NutsMessage.cstyle((String)"unable to resolve Nuts Jar File", (Object[])new Object[0]), 2);
                        }
                        context.out().printf("Detected nuts.jar location : %s\n", new Object[]{from});
                        String bootApiFileName = "nuts-" + session.getWorkspace().getApiId() + ".jar";
                        sshSession.setFailFast(true).copyLocalToRemote(from.toString(), workspace + "/" + bootApiFileName, true);
                        String javaCmd = null;
                        javaCmd = o.nutsJre != null ? o.nutsJre + "/bin/java" : "java";
                    }
                    cmd.add(workspace + "/nuts");
                }
            }
            cmd.addAll(o.cmd);
            sshSession.grabOutputString(false).setFailFast(true).exec(cmd);
        }
    }

    private static class Options {
        boolean acceptDashNuts = true;
        boolean invokeNuts;
        String nutsCommand;
        String nutsJre;
        String address;
        List<String> cmd = new ArrayList<String>();

        private Options() {
        }
    }
}

