/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellFunction;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class SetCommand
extends SimpleJShellBuiltin {
    public SetCommand() {
        super("set", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        NutsArgument a = commandLine.peek();
        if (a.isNonOption() && a.isKeyValue()) {
            options.vars.put(a.getKey().getString(), a.getValue().getString());
            return true;
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        if (options.vars.isEmpty()) {
            ArrayList<String> results = new ArrayList<String>();
            for (Map.Entry<Object, Object> entry : context.getShellContext().vars().getAll().entrySet()) {
                results.add(entry.getKey() + "=" + entry.getValue());
            }
            for (JShellFunction function : context.getShellContext().functions().getAll()) {
                results.add(function.getDefinition());
            }
            context.getSession().out().printlnf(results);
        } else {
            for (Map.Entry<String, String> entry : options.vars.entrySet()) {
                context.getShellContext().vars().set(entry.getKey(), entry.getValue());
            }
        }
    }

    private static class Options {
        LinkedHashMap<String, String> vars = new LinkedHashMap();

        private Options() {
        }
    }
}

