/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsArgumentName;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class LoginCommand
extends SimpleJShellBuiltin {
    public LoginCommand() {
        super("login", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        NutsArgument a = commandLine.peek();
        if (!a.isOption()) {
            NutsSession session = context.getSession();
            if (options.login == null) {
                options.login = commandLine.next(NutsArgumentName.of((String)"username", (NutsSession)session)).getString();
                return true;
            }
            if (options.password == null) {
                options.password = commandLine.next(NutsArgumentName.of((String)"password", (NutsSession)session)).getString().toCharArray();
                return true;
            }
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        if (!"anonymous".equals(options.login) && (options.password == null || NutsBlankable.isBlank((String)new String(options.password)))) {
            NutsSession session = context.getSession();
            options.password = (char[])session.getTerminal().ask().resetLine().forPassword("Password:", new Object[0]).getValue();
        }
        context.getSession().security().login(options.login, options.password);
    }

    private static class Options {
        String login;
        char[] password;

        private Options() {
        }
    }
}

