/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellContext;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class JsonCommand
extends SimpleJShellBuiltin {
    public JsonCommand() {
        super("json", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        NutsArgument a = commandLine.nextString(new String[]{"-f", "--file"});
        if (a != null) {
            options.input = a.getValue().getString();
            return true;
        }
        a = commandLine.nextString(new String[]{"-q"});
        if (a != null) {
            options.queryType = "jpath";
            options.queries.add(a.getValue().getString());
            return true;
        }
        a = commandLine.nextString(new String[]{"--xpath"});
        if (a != null) {
            options.queryType = "xpath";
            options.queries.add(a.getValue().getString());
            return true;
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        NutsSession session = context.getSession();
        if (options.queries.isEmpty()) {
            NutsElement inputDocument = this.readJsonConvertElement(options.input, context.getShellContext());
            if (session.getOutputFormat() == NutsContentType.PLAIN) {
                session.out().printlnf((Object)NutsElements.of((NutsSession)session).json().setValue((Object)inputDocument).format());
            } else {
                session.out().printlnf((Object)inputDocument);
            }
        } else {
            switch (options.queryType) {
                case "xpath": {
                    Document resultDocument;
                    Document inputDocument = this.readJsonConvertXml(options.input, context.getShellContext());
                    XPath xPath = XPathFactory.newInstance().newXPath();
                    DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
                    try {
                        resultDocument = documentFactory.newDocumentBuilder().newDocument();
                    }
                    catch (ParserConfigurationException ex) {
                        throw new NutsExecutionException(session, NutsMessage.plain((String)"failed to create xml document"), (Throwable)ex, 1);
                    }
                    Element resultElement = resultDocument.createElement("result");
                    resultDocument.appendChild(resultElement);
                    for (String query : options.queries) {
                        try {
                            NodeList evaluated = (NodeList)xPath.compile(query).evaluate(inputDocument, XPathConstants.NODESET);
                            for (int i = 0; i < evaluated.getLength(); ++i) {
                                Node item = evaluated.item(i);
                                Node o = resultDocument.importNode(item, true);
                                resultElement.appendChild(o);
                            }
                        }
                        catch (XPathExpressionException ex) {
                            throw new NutsExecutionException(session, NutsMessage.cstyle((String)"%s", (Object[])new Object[]{ex}), (Throwable)ex, 103);
                        }
                    }
                    if (session.getOutputFormat(null) == null) {
                        session.out().printlnf((Object)NutsElements.of((NutsSession)session).json().setValue((Object)resultDocument).format());
                        break;
                    }
                    session.out().printlnf((Object)resultDocument);
                    break;
                }
                case "jpath": {
                    ArrayList result;
                    NutsElement inputDocument = this.readJsonConvertElement(options.input, context.getShellContext());
                    ArrayList all = new ArrayList();
                    for (String query : options.queries) {
                        all.addAll(NutsElements.of((NutsSession)session).compilePath(query).filter(inputDocument));
                    }
                    ArrayList arrayList = result = all.size() == 1 ? all.get(0) : all;
                    if (session.getOutputFormat(null) == null) {
                        session.out().printlnf((Object)NutsElements.of((NutsSession)session).json().setValue(result).format());
                        break;
                    }
                    session.out().printlnf(result);
                    break;
                }
            }
        }
    }

    private Document readJsonConvertXml(String path, JShellContext context) {
        return this.readJsonConvertAny(path, Document.class, context);
    }

    private NutsElement readJsonConvertElement(String path, JShellContext context) {
        return this.readJsonConvertAny(path, NutsElement.class, context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T readJsonConvertAny(String path, Class<T> cls, JShellContext context) {
        NutsSession session = context.getSession();
        NutsElements njson = NutsElements.of((NutsSession)session).json();
        Object inputDocument = null;
        if (path != null) {
            NutsPath file = NutsPath.of((String)path, (NutsSession)session).toAbsolute(context.getCwd());
            if (!file.exists()) throw new NutsExecutionException(session, NutsMessage.cstyle((String)"invalid path %s", (Object[])new Object[]{path}), 1);
            inputDocument = njson.parse(file, cls);
            return (T)inputDocument;
        }
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            String line = null;
            try {
                line = reader.readLine();
            }
            catch (IOException ex) {
                throw new NutsExecutionException(session, NutsMessage.cstyle((String)"broken Input", (Object[])new Object[0]), 2);
            }
            if (line == null) {
                inputDocument = njson.parse((Reader)new StringReader(sb.toString()), cls);
                return (T)inputDocument;
            }
            sb.append(line);
            try {
                inputDocument = njson.parse((Reader)new StringReader(sb.toString()), cls);
                return (T)inputDocument;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private static class Options {
        String input;
        String queryType = "jpath";
        List<String> queries = new ArrayList<String>();

        private Options() {
        }
    }
}

