/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCp;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTextPlain;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyles;
import net.thevpc.nuts.NutsTextType;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;
import net.thevpc.nuts.toolbox.nsh.util.ColumnRuler;
import net.thevpc.nuts.toolbox.nsh.util.FileInfo;

public class GrepCommand
extends SimpleJShellBuiltin {
    public GrepCommand() {
        super("grep", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        if (commandLine.next(new String[]{"-"}) != null) {
            options.files.add(null);
            return true;
        }
        if (commandLine.next(new String[]{"-e", "--regexp"}) != null) {
            return true;
        }
        if (commandLine.next(new String[]{"-v", "--invert-match"}) != null) {
            options.invertMatch = true;
            return true;
        }
        if (commandLine.next(new String[]{"-w", "--word-regexp"}) != null) {
            options.word = true;
            return true;
        }
        if (commandLine.next(new String[]{"-x", "--line-regexp"}) != null) {
            options.lineRegexp = true;
            return true;
        }
        if (commandLine.next(new String[]{"-i", "--ignore-case"}) != null) {
            options.ignoreCase = true;
            return true;
        }
        NutsArgument a = commandLine.next(new String[]{"-H", "--highlight", "--highlighter"});
        if (a != null) {
            options.highlighter = NutsUtilStrings.trim((String)a.getValue().getString());
            return true;
        }
        a = commandLine.next(new String[]{"-S", "--selection-style"});
        if (a != null) {
            options.selectionStyle = NutsUtilStrings.trimToNull((String)a.getValue().getString());
            return true;
        }
        if (commandLine.next(new String[]{"-n"}) != null) {
            options.n = true;
            return true;
        }
        if (commandLine.peek().isNonOption()) {
            if (options.expression == null) {
                options.expression = commandLine.next().getString();
            } else {
                String path = commandLine.next().getString();
                options.files.add(new FileInfo(NutsPath.of((String)path, (NutsSession)context.getSession()), options.highlighter));
            }
            return true;
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        NutsPrintStream out = context.out();
        if (options.files.isEmpty()) {
            options.files.add(null);
        }
        if (options.expression == null) {
            throw new NutsExecutionException(context.getSession(), NutsMessage.cstyle((String)"missing Expression", (Object[])new Object[0]), 2);
        }
        String baseExpr = GrepCommand.simpexpToRegexp(options.expression, true);
        if (options.word) {
            baseExpr = "\\b" + baseExpr + "\\b";
        }
        if (options.lineRegexp) {
            baseExpr = "^" + baseExpr + "$";
        }
        if (options.ignoreCase) {
            baseExpr = "(?i)" + baseExpr;
        }
        Pattern p = Pattern.compile(baseExpr);
        boolean prefixFileName = options.files.size() > 1;
        int x = 0;
        ArrayList<GrepResultItem> results = new ArrayList<GrepResultItem>();
        for (FileInfo f : options.files) {
            x = this.grepFile(f, p, options, context, prefixFileName, results);
        }
        switch (context.getSession().getOutputFormat()) {
            case PLAIN: {
                ColumnRuler ruler = new ColumnRuler();
                for (GrepResultItem result : results) {
                    if (options.n) {
                        if (result.path != null && prefixFileName) {
                            out.printf((Object)result.path);
                            out.print(":");
                        }
                        out.print(ruler.nextNum(result.number, context.getSession()));
                    }
                    out.println((NutsString)result.line);
                }
                break;
            }
            default: {
                if (options.n) {
                    out.printlnf(results);
                    break;
                }
                out.printlnf(results.stream().map(r -> r.line).collect(Collectors.toList()));
            }
        }
        if (x != 0) {
            this.throwExecutionException("error", x, context.getSession());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int grepFile(FileInfo f, Pattern p, Options options, JShellExecutionContext context, boolean prefixFileName, List<GrepResultItem> results) {
        Reader reader = null;
        boolean closeReader = false;
        NutsSession session = context.getSession();
        try {
            try {
                if (f == null) {
                    closeReader = false;
                    reader = new InputStreamReader(context.in());
                    this.processByLine(reader, options, p, f, results, session);
                    return 0;
                }
                if (f.getFile().isDirectory()) {
                    NutsIterator nutsIterator = f.getFile().list().iterator();
                    while (true) {
                        if (!nutsIterator.hasNext()) {
                            int n = 0;
                            return n;
                        }
                        NutsPath ff = (NutsPath)nutsIterator.next();
                        this.grepFile(new FileInfo(ff, f.getHighlighter()), p, options, context, true, results);
                    }
                }
                closeReader = true;
                reader = new InputStreamReader(f.getFile().getInputStream());
                if (f.getHighlighter() == null) {
                    this.processByLine(reader, options, p, f, results, session);
                    return 0;
                }
                String text = new String(NutsCp.of((NutsSession)session).from(f.getFile()).getByteArrayResult());
                if (NutsBlankable.isBlank((String)f.getHighlighter())) {
                    f.setHighlighter(f.getFile().getContentType());
                }
                this.processByText(text, options, p, f, results, session);
                return 0;
            }
            finally {
                if (reader != null && closeReader) {
                    reader.close();
                }
            }
        }
        catch (IOException ex) {
            throw new NutsExecutionException(session, NutsMessage.cstyle((String)"%s", (Object[])new Object[]{ex}), (Throwable)ex, 100);
        }
    }

    private boolean isNewLine(NutsText t) {
        if (t.getType() == NutsTextType.PLAIN) {
            String txt = ((NutsTextPlain)t).getText();
            return txt.equals("\n") || txt.equals("\r\n");
        }
        return false;
    }

    private NutsTextBuilder readLine(NutsTextBuilder flattened, NutsSession session) {
        if (flattened.size() == 0) {
            return null;
        }
        ArrayList<NutsText> r = new ArrayList<NutsText>();
        while (flattened.size() > 0) {
            NutsText t = flattened.get(0);
            flattened.removeAt(0);
            if (this.isNewLine(t)) break;
            r.add(t);
        }
        return NutsTexts.of((NutsSession)session).builder().appendAll(r);
    }

    private void processByLine(Reader reader, Options options, Pattern p, FileInfo f, List<GrepResultItem> results, NutsSession session) throws IOException {
        try (BufferedReader r = new BufferedReader(reader);){
            String line = null;
            long nn = 1L;
            while ((line = r.readLine()) != null) {
                GrepResultItem rr = this.createResult(nn, line, null, options, p, f, session);
                if (rr != null) {
                    results.add(rr);
                }
                ++nn;
            }
        }
    }

    private GrepResultItem createResult(long nn, String line, NutsTextBuilder coloredLine, Options options, Pattern p, FileInfo f, NutsSession session) {
        if (coloredLine == null) {
            coloredLine = NutsTexts.of((NutsSession)session).ofCode(f.getHighlighter(), line).highlight(session).builder();
        }
        Matcher matcher = p.matcher(line);
        boolean anyMatch = false;
        while (matcher.find()) {
            anyMatch = true;
            int pos = matcher.start();
            int end = matcher.end();
            coloredLine.replace(pos, end, new NutsText[]{NutsTexts.of((NutsSession)session).applyStyles(coloredLine.substring(pos, end), this.selectionStyle(options))});
        }
        if (anyMatch != options.invertMatch) {
            return new GrepResultItem(f.getFile(), nn, coloredLine.build(), true);
        }
        if (options.all) {
            return new GrepResultItem(f.getFile(), nn, coloredLine.build(), false);
        }
        if (options.all) {
            // empty if block
        }
        return null;
    }

    private void processByText(String text, Options options, Pattern p, FileInfo f, List<GrepResultItem> results, NutsSession session) throws IOException {
        NutsTextBuilder flattened = NutsTexts.of((NutsSession)session).ofCode(f.getHighlighter(), text).highlight(session).builder().flatten();
        try (BufferedReader r = new BufferedReader(new InputStreamReader(f.getFile().getInputStream()));){
            String line = null;
            long nn = 1L;
            while ((line = r.readLine()) != null) {
                NutsTextBuilder coloredLine = this.readLine(flattened, session);
                GrepResultItem rr = this.createResult(nn, line, coloredLine, options, p, f, session);
                if (rr != null) {
                    results.add(rr);
                }
                ++nn;
            }
        }
    }

    public NutsTextStyles selectionStyle(Options options) {
        String s = options.selectionStyle;
        NutsTextStyles def = NutsTextStyles.of((NutsTextStyle)NutsTextStyle.secondary((int)2));
        if (NutsBlankable.isBlank((String)s)) {
            return def;
        }
        return NutsTextStyles.parseLenient((String)s, (NutsTextStyles)def, (NutsTextStyles)def);
    }

    public static String simpexpToRegexp(String pattern, boolean contains) {
        if (pattern == null) {
            pattern = "*";
        }
        char[] cc = pattern.toCharArray();
        StringBuilder sb = new StringBuilder();
        block4: for (int i = 0; i < cc.length; ++i) {
            char c = cc[i];
            switch (c) {
                case '!': 
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '|': {
                    sb.append('\\').append(c);
                    continue block4;
                }
                case '*': {
                    sb.append(".*");
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (!contains) {
            sb.insert(0, '^');
            sb.append('$');
        }
        return sb.toString();
    }

    private static class GrepResultItem {
        NutsPath path;
        long number;
        NutsText line;
        Boolean match;

        public GrepResultItem(NutsPath path, long number, NutsText line, Boolean match) {
            this.path = path;
            this.number = number;
            this.line = line;
            this.match = match;
        }
    }

    private static class Options {
        boolean invertMatch = false;
        boolean word = false;
        boolean lineRegexp = false;
        boolean ignoreCase = false;
        String highlighter;
        String selectionStyle;
        boolean n = false;
        boolean all = false;
        int windowBefore = 0;
        int windowAfter = 0;
        List<FileInfo> files = new ArrayList<FileInfo>();
        String expression = null;

        private Options() {
        }
    }
}

