/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class DirNameCommand
extends SimpleJShellBuiltin {
    public DirNameCommand() {
        super("dirname", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine cmdLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        NutsArgument a = cmdLine.peek();
        switch (a.getKey().getString()) {
            case "-z": 
            case "--zero": {
                cmdLine.skip();
                options.sep = "\u0000";
                return true;
            }
        }
        if (!a.isOption()) {
            options.names.add(cmdLine.next().toString());
            return true;
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine cmdLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        if (options.names.isEmpty()) {
            cmdLine.required();
        }
        ArrayList<String> results = new ArrayList<String>();
        for (String name : options.names) {
            StringBuilder sb = new StringBuilder(name);
            int lastNameLen = 0;
            while (sb.length() > 0 && sb.charAt(sb.length() - 1) != '/') {
                sb.deleteCharAt(sb.length() - 1);
                ++lastNameLen;
            }
            while (sb.length() > 1 && sb.charAt(sb.length() - 1) == '/') {
                sb.deleteCharAt(sb.length() - 1);
            }
            if (lastNameLen == 0) {
                while (sb.length() > 0 && sb.charAt(sb.length() - 1) != '/') {
                    sb.deleteCharAt(sb.length() - 1);
                    ++lastNameLen;
                }
                while (sb.length() > 1 && sb.charAt(sb.length() - 1) == '/') {
                    sb.deleteCharAt(sb.length() - 1);
                }
            }
            if (sb.length() == 0) {
                results.add(".");
                continue;
            }
            results.add(sb.toString());
        }
        switch (context.getSession().getOutputFormat()) {
            case PLAIN: {
                for (int i = 0; i < results.size(); ++i) {
                    String name;
                    name = (String)results.get(i);
                    if (i > 0) {
                        context.getSession().out().print(options.sep);
                    }
                    context.getSession().out().print(name);
                }
                break;
            }
            default: {
                context.getSession().out().printlnf(results);
            }
        }
    }

    private static class Options {
        String sep = "\n";
        List<String> names = new ArrayList<String>();
        boolean multi = false;
        String suffix = null;

        private Options() {
        }
    }
}

