/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class DateCommand
extends SimpleJShellBuiltin {
    public DateCommand() {
        super("date", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine cmdLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        NutsArgument a = cmdLine.peek();
        switch (a.getKey().getString()) {
            case "-d": 
            case "--date": {
                if (context.getShell().getOptions().isNsh()) {
                    a = cmdLine.nextString(new String[0]);
                    if (a.isActive()) {
                        options.date = a.getValue().getString();
                    }
                } else {
                    a = cmdLine.next();
                    options.date = a.getValue().getString();
                }
                return true;
            }
            case "-f": 
            case "--file": {
                if (context.getShell().getOptions().isNsh()) {
                    a = cmdLine.nextString(new String[0]);
                    if (a.isActive()) {
                        options.file = a.getValue().getString();
                    }
                } else {
                    a = cmdLine.next();
                    options.file = a.getValue().getString();
                }
                return true;
            }
            case "--rfc-3339": {
                if (context.getShell().getOptions().isNsh()) {
                    a = cmdLine.next();
                    if (a.isActive()) {
                        String s = a.getValue().getString();
                        if (s == null) {
                            s = "";
                        }
                        options.rfc3339 = s;
                    }
                } else {
                    a = cmdLine.next();
                    String s = a.getValue().getString();
                    if (s == null) {
                        s = "";
                    }
                    options.rfc3339 = s;
                }
                return true;
            }
            case "--iso-8601": {
                if (context.getShell().getOptions().isNsh()) {
                    a = cmdLine.next();
                    if (a.isActive()) {
                        String s = a.getValue().getString();
                        if (s == null) {
                            s = "";
                        }
                        options.rfc8601 = s;
                    }
                } else {
                    a = cmdLine.next();
                    String s = a.getValue().getString();
                    if (s == null) {
                        s = "";
                    }
                    options.rfc8601 = s;
                }
                return true;
            }
            case "-s": 
            case "--set": {
                if (context.getShell().getOptions().isNsh()) {
                    a = cmdLine.next();
                    if (a.isActive()) {
                        String s = a.getValue().getString();
                        if (s == null) {
                            s = "";
                        }
                        options.setdate = s;
                    }
                } else {
                    a = cmdLine.next();
                    String s = a.getValue().getString();
                    if (s == null) {
                        s = "";
                    }
                    options.setdate = s;
                }
                return true;
            }
            case "-Id": 
            case "-Idate": 
            case "-Ih": 
            case "-Ihours": 
            case "-Im": 
            case "-Iminutes": 
            case "-Is": 
            case "-Iseconds": 
            case "-Ins": {
                if (context.getShell().getOptions().isNsh()) {
                    a = cmdLine.next();
                    if (a.isActive()) {
                        options.rfc8601 = a.getString().substring(2);
                    }
                } else {
                    a = cmdLine.next();
                    options.rfc8601 = a.getString().substring(2);
                }
                return true;
            }
            case "--debug": {
                if (context.getShell().getOptions().isNsh()) {
                    a = cmdLine.nextBoolean(new String[0]);
                    if (a.isActive()) {
                        options.debug = a.getBooleanValue();
                    }
                } else {
                    a = cmdLine.next();
                    options.debug = true;
                }
                return true;
            }
            case "-u": 
            case "--utc": 
            case "--universal": {
                if (context.getShell().getOptions().isNsh()) {
                    a = cmdLine.nextBoolean(new String[0]);
                    if (a.isActive()) {
                        options.utc = a.getBooleanValue();
                    }
                } else {
                    a = cmdLine.next();
                    options.utc = true;
                }
                return true;
            }
            case "-R": 
            case "--rfc-email": {
                if (context.getShell().getOptions().isNsh()) {
                    a = cmdLine.nextBoolean(new String[0]);
                    if (a.isActive()) {
                        options.rfcMail = a.getBooleanValue();
                    }
                } else {
                    a = cmdLine.next();
                    options.rfcMail = true;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine cmdLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        ZonedDateTime dateTimeInMyZone = ZonedDateTime.of(LocalDateTime.now(), ZoneId.systemDefault());
        if (options.utc) {
            dateTimeInMyZone = dateTimeInMyZone.withZoneSameInstant(ZoneOffset.UTC);
        }
        if (options.iso != null) {
            switch (options.iso) {
                case "": 
                case "d": 
                case "date": {
                    context.getSession().out().printlnf((Object)dateTimeInMyZone.toLocalDate().toString());
                    break;
                }
                case "m": 
                case "minutes": {
                    context.getSession().out().printlnf((Object)DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm").format(dateTimeInMyZone.toLocalDateTime()));
                    break;
                }
                case "s": 
                case "seconds": {
                    context.getSession().out().printlnf((Object)DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss").format(dateTimeInMyZone.toLocalDateTime()));
                    break;
                }
                case "ns": {
                    context.getSession().out().printlnf((Object)DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss.SSSSSSSSS").format(dateTimeInMyZone.toLocalDateTime()));
                    break;
                }
                default: {
                    context.getSession().out().printlnf((Object)dateTimeInMyZone.toLocalDate().toString());
                    break;
                }
            }
        } else if (options.rfc3339 != null) {
            switch (options.rfc3339) {
                case "": 
                case "d": 
                case "date": {
                    context.getSession().out().printlnf((Object)dateTimeInMyZone.toLocalDate().toString());
                    break;
                }
                case "m": 
                case "minutes": {
                    context.getSession().out().printlnf((Object)DateTimeFormatter.ofPattern("uuuu-MM-dd' 'HH:mmXXX").format(dateTimeInMyZone.toLocalDate()));
                    break;
                }
                case "s": 
                case "seconds": {
                    context.getSession().out().printlnf((Object)DateTimeFormatter.ofPattern("uuuu-MM-dd' 'HH:mm:ssXXX").format(dateTimeInMyZone.toLocalDateTime()));
                    break;
                }
                case "ns": {
                    context.getSession().out().printlnf((Object)DateTimeFormatter.ofPattern("uuuu-MM-dd' 'HH:mm:ss.SSSSSSSSSXXX").format(dateTimeInMyZone.toLocalDateTime()));
                    break;
                }
                default: {
                    context.getSession().out().printlnf((Object)dateTimeInMyZone.toLocalDate().toString());
                    break;
                }
            }
        } else if (options.rfcMail) {
            context.getSession().out().printlnf((Object)DateTimeFormatter.ofPattern("EEE, d MMM yyyy HH:mm:ss Z").format(dateTimeInMyZone));
        } else {
            context.getSession().out().printlnf((Object)DateTimeFormatter.ofPattern("EEE MMM d hh:mm:ss a Z yyyy").format(dateTimeInMyZone));
        }
    }

    @Override
    protected void initCommandLine(NutsCommandLine commandLine) {
        for (String s : new String[]{"-Id", "-Idate", "-Ih", "-Ihours", "-Im", "-Iminutes", "-Is", "-Iseconds", "-Ins"}) {
            commandLine.registerSpecialSimpleOption(s);
        }
    }

    private static class Options {
        String date;
        boolean debug;
        String file;
        String iso;
        boolean rfcMail;
        String rfc8601;
        String rfc3339;
        String reference;
        String setdate;
        boolean utc;

        private Options() {
        }
    }
}

