/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCp;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;
import net.thevpc.nuts.toolbox.nsh.util.ShellHelper;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class CpCommand
extends SimpleJShellBuiltin {
    public CpCommand() {
        super("cp", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        switch (commandLine.peek().getKey().getString()) {
            case "--mkdir": {
                options.mkdir = commandLine.nextBoolean(new String[0]).getBooleanValue();
                return true;
            }
            case "-r": 
            case "-R": 
            case "--recursive": {
                options.recursive = commandLine.nextBoolean(new String[0]).getBooleanValue();
                return true;
            }
        }
        if (commandLine.peek().isNonOption()) {
            options.files.add(commandLine.next().getString());
            return true;
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        NutsSession session = context.getSession();
        for (String value : options.files) {
            if (NutsBlankable.isBlank((String)value)) {
                throw new NutsExecutionException(session, NutsMessage.cstyle((String)"empty file path", (Object[])new Object[0]), 2);
            }
            options.xfiles.add(NutsPath.of((String)(value.contains("://") ? value : NutsPath.of((String)value, (NutsSession)session).toAbsolute(session.locations().getWorkspaceLocation()).toString()), (NutsSession)session));
        }
        if (options.xfiles.size() < 2) {
            throw new NutsExecutionException(session, NutsMessage.cstyle((String)"missing parameters", (Object[])new Object[0]), 2);
        }
        options.sshlistener = new ShellHelper.WsSshListener(session);
        for (int i = 0; i < options.xfiles.size() - 1; ++i) {
            this.copy(options.xfiles.get(i), options.xfiles.get(options.xfiles.size() - 1), options, context);
        }
    }

    public void copy(NutsPath from, NutsPath to, Options o, JShellExecutionContext context) {
        NutsSession session = context.getSession();
        NutsCp ccp = NutsCp.of((NutsSession)session).from(from).to(to).setRecursive(o.recursive).setMkdirs(o.mkdir);
        ccp.run();
    }

    public static class Options {
        boolean mkdir;
        boolean recursive;
        ShellHelper.WsSshListener sshlistener;
        List<String> files = new ArrayList<String>();
        List<NutsPath> xfiles = new ArrayList<NutsPath>();
    }
}

