/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellAutoCompleteCandidate;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class AutocompleteCommand
extends SimpleJShellBuiltin {
    public AutocompleteCommand() {
        super("autocomplete", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine cmdLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        if (!cmdLine.peek().isOption()) {
            while (cmdLine.hasNext()) {
                String s = cmdLine.next().getString();
                if (options.cmd == null) {
                    options.cmd = s;
                    continue;
                }
                if (s.startsWith("[]") && options.index < 0) {
                    options.index = options.items.size();
                    options.items.add(s.substring(2));
                    continue;
                }
                options.items.add(s);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        NutsSession session = context.getSession();
        if (options.cmd == null) {
            throw new NutsExecutionException(session, NutsMessage.cstyle((String)"missing JShellCommandNode", (Object[])new Object[0]), 1);
        }
        if (options.index < 0) {
            options.index = options.items.size();
            options.items.add("");
        }
        List<JShellAutoCompleteCandidate> aa = context.getShellContext().resolveAutoCompleteCandidates(options.cmd, options.items, options.index, NutsCommandLine.of(options.items, (NutsSession)session).toString());
        Properties p = new Properties();
        for (JShellAutoCompleteCandidate autoCompleteCandidate : aa) {
            String string = autoCompleteCandidate.getValue();
            String dvalue = autoCompleteCandidate.getDisplay();
            if (dvalue != null && dvalue.equals(string)) {
                dvalue = null;
            }
            p.setProperty(string == null ? "" : string, dvalue == null ? "" : dvalue);
        }
        switch (session.getOutputFormat()) {
            case PLAIN: {
                NutsTexts text = NutsTexts.of((NutsSession)session);
                for (String string : new TreeSet<Object>(p.keySet())) {
                    if (string.startsWith("-")) {
                        session.out().printf("%s\n", new Object[]{text.ofStyled(string, NutsTextStyle.primary4())});
                        continue;
                    }
                    if (string.startsWith("<")) {
                        session.out().printf("%s\n", new Object[]{text.ofStyled(string, NutsTextStyle.primary1())});
                        continue;
                    }
                    session.out().printf("%s\n", new Object[]{text.ofStyled(string, NutsTextStyle.pale())});
                }
                break;
            }
            default: {
                session.out().printlnf((Object)p);
            }
        }
    }

    private static class Options {
        String cmd = null;
        List<String> items = new ArrayList<String>();
        int index = -1;

        private Options() {
        }
    }
}

