/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShell;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class AliasCommand
extends SimpleJShellBuiltin {
    public AliasCommand() {
        super("alias", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        NutsArgument a = commandLine.peek();
        if (a.isOption()) {
            if (a.getKey().getString().equals("--sort")) {
                commandLine.skip();
                options.displayOptions.add(a.toString());
                return true;
            }
        } else {
            if (a.isKeyValue()) {
                commandLine.skip();
                options.add.put(a.getKey().getString(), a.getValue().getString());
                return true;
            }
            commandLine.skip();
            options.show.add(a.getString());
            return true;
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        JShell shell = context.getShell();
        if (options.add.isEmpty() && options.show.isEmpty()) {
            options.show.addAll(context.getShellContext().aliases().getAll());
        }
        for (Map.Entry<String, String> entry : options.add.entrySet()) {
            context.getShellContext().aliases().set(entry.getKey(), entry.getValue());
        }
        ArrayList<ResultItem> outRes = new ArrayList<ResultItem>();
        ArrayList<ResultItem> errRes = new ArrayList<ResultItem>();
        for (String a : options.show) {
            String v = context.getShellContext().aliases().get(a);
            if (v == null) {
                errRes.add(new ResultItem(a, v));
                continue;
            }
            outRes.add(new ResultItem(a, v));
        }
        switch (context.getSession().getOutputFormat()) {
            case PLAIN: {
                for (ResultItem resultItem : outRes) {
                    if (resultItem.value == null) {
                        context.getSession().err().printf("alias : %s ```error not found```%n", new Object[]{resultItem.name});
                        continue;
                    }
                    context.getSession().out().printf("alias : %s ='%s'%n", new Object[]{resultItem.name, resultItem.value});
                }
                break;
            }
            default: {
                context.getSession().out().printlnf(outRes);
            }
        }
        if (!errRes.isEmpty()) {
            this.throwExecutionException(errRes, 1, context.getSession());
        }
    }

    private static class ResultItem {
        String name;
        String value;

        public ResultItem(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    private static class Options {
        LinkedHashMap<String, String> add = new LinkedHashMap();
        Set<String> show = new LinkedHashSet<String>();
        List<String> displayOptions = new ArrayList<String>();

        private Options() {
        }
    }
}

