/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.bundles;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class _IOUtils {
    public static final int DEFAULT_BUFFER_SIZE = 1024;

    public static String loadString(URL url) throws IOException {
        return new String(_IOUtils.loadByteArray(url));
    }

    public static String loadString(InputStream r) throws IOException {
        return new String(_IOUtils.loadByteArray(r));
    }

    public static byte[] loadByteArray(URL url) throws IOException {
        try (InputStream r = null;){
            r = url.openStream();
            byte[] byArray = _IOUtils.loadByteArray(r);
            return byArray;
        }
    }

    public static byte[] loadByteArray(InputStream r) throws IOException {
        try (ByteArrayOutputStream out = null;){
            out = new ByteArrayOutputStream();
            _IOUtils.copy(r, (OutputStream)out);
            out.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        _IOUtils.copy(in, out, 1024);
    }

    public static void copy(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int len;
        byte[] buffer = new byte[bufferSize];
        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
    }

    public static void copy(File in, OutputStream out) throws IOException {
        _IOUtils.copy(in, out, 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File in, OutputStream out, int bufferSize) throws IOException {
        try (FileInputStream fis = null;){
            fis = new FileInputStream(in);
            _IOUtils.copy(fis, out, bufferSize);
        }
    }

    public static String getAbsoluteFile2(String path, String cwd) {
        if (new File(path).isAbsolute()) {
            return path;
        }
        if (cwd == null) {
            cwd = System.getProperty("user.dir");
        }
        switch (path) {
            case "~": {
                return System.getProperty("user.home");
            }
            case ".": {
                File file = new File(cwd);
                try {
                    return file.getCanonicalPath();
                }
                catch (IOException ex) {
                    return file.getAbsolutePath();
                }
            }
            case "..": {
                File file = new File(cwd, "..");
                try {
                    return file.getCanonicalPath();
                }
                catch (IOException ex) {
                    return file.getAbsolutePath();
                }
            }
        }
        int j = -1;
        char[] chars = path.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '/' && chars[i] != '\\') continue;
            j = i;
            break;
        }
        if (j > 0) {
            switch (path.substring(0, j)) {
                case "~": {
                    String e = path.substring(j + 1);
                    if (e.isEmpty()) {
                        return System.getProperty("user.home");
                    }
                    File file = new File(System.getProperty("user.home"), e);
                    try {
                        return file.getCanonicalPath();
                    }
                    catch (IOException ex) {
                        return file.getAbsolutePath();
                    }
                }
            }
        }
        File file = new File(cwd, path);
        try {
            return file.getCanonicalPath();
        }
        catch (IOException ex) {
            return file.getAbsolutePath();
        }
    }
}

