/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh;

import java.util.Arrays;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.logging.Level;
import net.thevpc.nuts.NutsAppCmdProcessor;
import net.thevpc.nuts.NutsApplication;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsCommandConfig;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsConfirmationMode;
import net.thevpc.nuts.NutsLauncherOptions;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSupportCondition;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsWorkspaceConfigManager;
import net.thevpc.nuts.NutsWorkspaceCustomCommand;
import net.thevpc.nuts.toolbox.nsh.jshell.DefaultJShellOptionsParser;
import net.thevpc.nuts.toolbox.nsh.jshell.JShell;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellOptions;

public class Nsh
implements NutsApplication {
    private static final HashSet<String> CONTEXTUAL_BUILTINS = new HashSet<String>(Arrays.asList("showerr", "cd", "set", "unset", "enable", "login", "logout", "help", "version", "alias", "unalias", "exit"));

    public static void main(String[] args) {
        new Nsh().runAndExit(args);
    }

    public void onInstallApplication(final NutsApplicationContext applicationContext) {
        final NutsLoggerOp log = NutsLoggerOp.of(Nsh.class, (NutsSession)applicationContext.getSession());
        log.level(Level.CONFIG).verb(NutsLogVerb.START).log(NutsMessage.plain((String)"[nsh] Installation..."));
        final NutsSession session = applicationContext.getSession();
        applicationContext.processCommandLine(new NutsAppCmdProcessor(){

            public void onCmdInitParsing(NutsCommandLine commandline, NutsApplicationContext context) {
                commandline.setCommandName("nsh --nuts-exec-mode=install");
            }

            public void onCmdExec(NutsCommandLine commandline, NutsApplicationContext context) {
                if (session.isTrace() || session.isYes()) {
                    log.level(Level.CONFIG).verb(NutsLogVerb.INFO).log(NutsMessage.jstyle((String)"[nsh] activating options trace={0} yes={1}", (Object[])new Object[]{session.isTrace(), session.isYes()}));
                }
                String nshIdStr = applicationContext.getAppId().getShortName();
                NutsWorkspaceConfigManager cfg = session.config();
                JShell c = new JShell(applicationContext, null);
                JShellBuiltin[] commands = c.getRootContext().builtins().getAll();
                TreeSet<String> reinstalled = new TreeSet<String>();
                TreeSet<String> firstInstalled = new TreeSet<String>();
                NutsSession sessionCopy = session.copy();
                for (JShellBuiltin command : commands) {
                    if (CONTEXTUAL_BUILTINS.contains(command.getName())) continue;
                    if (session.commands().setSession(sessionCopy.setConfirm(NutsConfirmationMode.YES)).addCommand(new NutsCommandConfig().setFactoryId("nsh").setName(command.getName()).setCommand(new String[]{nshIdStr, "-c", command.getName()}).setOwner(applicationContext.getAppId()).setHelpCommand(new String[]{nshIdStr, "-c", "help", "--ntf", command.getName()}))) {
                        reinstalled.add(command.getName());
                        continue;
                    }
                    firstInstalled.add(command.getName());
                }
                if (firstInstalled.size() > 0) {
                    log.level(Level.CONFIG).verb(NutsLogVerb.INFO).log(NutsMessage.jstyle((String)"[nsh] registered {0} nsh commands : {1}", (Object[])new Object[]{firstInstalled.size(), String.join((CharSequence)", ", firstInstalled)}));
                }
                if (reinstalled.size() > 0) {
                    log.level(Level.CONFIG).verb(NutsLogVerb.INFO).log(NutsMessage.jstyle((String)"[nsh] re-registered {0} nsh commands : {1}", (Object[])new Object[]{reinstalled.size(), String.join((CharSequence)", ", reinstalled)}));
                }
                if (session.isPlainTrace()) {
                    NutsTexts factory = NutsTexts.of((NutsSession)session);
                    if (firstInstalled.size() > 0) {
                        session.out().printf("registered %s nsh commands : %s \n", new Object[]{factory.ofStyled("" + firstInstalled.size(), NutsTextStyle.primary3()), factory.ofStyled(String.join((CharSequence)", ", firstInstalled), NutsTextStyle.primary3())});
                    }
                    if (reinstalled.size() > 0) {
                        session.out().printf("re-registered %s nsh commands : %s \n", new Object[]{factory.ofStyled("" + reinstalled.size(), NutsTextStyle.primary3()), factory.ofStyled(String.join((CharSequence)", ", reinstalled), NutsTextStyle.primary3())});
                    }
                }
                cfg.save(false);
                if (session.boot().getBootCustomBoolArgument(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), new String[]{"---init-scripts"}).booleanValue()) {
                    boolean initLaunchers = session.boot().getBootCustomBoolArgument(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), new String[]{"---init-launchers"});
                    session.env().addLauncher(new NutsLauncherOptions().setId(session.getAppId()).setCreateScript(true).setCreateDesktopShortcut(initLaunchers ? NutsSupportCondition.PREFERRED : NutsSupportCondition.NEVER).setCreateMenuShortcut(initLaunchers ? NutsSupportCondition.SUPPORTED : NutsSupportCondition.NEVER).setOpenTerminal(true));
                }
            }
        });
    }

    public void onUpdateApplication(NutsApplicationContext applicationContext) {
        NutsLoggerOp log = NutsLoggerOp.of(Nsh.class, (NutsSession)applicationContext.getSession());
        log.level(Level.CONFIG).verb(NutsLogVerb.INFO).log(NutsMessage.jstyle((String)"[nsh] update...", (Object[])new Object[0]));
        NutsVersion currentVersion = applicationContext.getAppVersion();
        NutsVersion previousVersion = applicationContext.getAppPreviousVersion();
        this.onInstallApplication(applicationContext);
    }

    public void onUninstallApplication(NutsApplicationContext applicationContext) {
        NutsLoggerOp log = NutsLoggerOp.of(Nsh.class, (NutsSession)applicationContext.getSession());
        log.level(Level.CONFIG).verb(NutsLogVerb.INFO).log(NutsMessage.jstyle((String)"[nsh] uninstallation...", (Object[])new Object[0]));
        try {
            NutsSession session = applicationContext.getSession();
            try {
                session.commands().removeCommandFactory("nsh");
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (NutsWorkspaceCustomCommand command : session.commands().findCommandsByOwner(applicationContext.getAppId())) {
                try {
                    session.commands().removeCommand(command.getName());
                }
                catch (Exception ex) {
                    if (!applicationContext.getSession().isPlainTrace()) continue;
                    NutsTexts factory = NutsTexts.of((NutsSession)session);
                    applicationContext.getSession().err().printf("unable to uninstall %s.\n", new Object[]{factory.ofStyled(command.getName(), NutsTextStyle.primary3())});
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run(NutsApplicationContext applicationContext) {
        DefaultJShellOptionsParser options = new DefaultJShellOptionsParser(applicationContext);
        JShellOptions o = options.parse(applicationContext.getCommandLine().toStringArray());
        new JShell(applicationContext).run();
    }
}

