/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nutsserver.http.commands;

import java.io.IOException;
import java.util.Iterator;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.toolbox.nutsserver.AbstractFacadeCommand;
import net.thevpc.nuts.toolbox.nutsserver.FacadeCommandContext;
import net.thevpc.nuts.toolbox.nutsserver.bundled._IOUtils;
import net.thevpc.nuts.toolbox.nutsserver.http.NutsHttpServletFacade;
import net.thevpc.nuts.toolbox.nutsserver.util.ItemStreamInfo;
import net.thevpc.nuts.toolbox.nutsserver.util.MultipartStreamHelper;
import net.thevpc.nuts.toolbox.nutsserver.util.NutsServerUtils;

public class SearchFacadeCommand
extends AbstractFacadeCommand {
    private final NutsHttpServletFacade nutsHttpServletFacade;

    public SearchFacadeCommand(NutsHttpServletFacade nutsHttpServletFacade) {
        super("search");
        this.nutsHttpServletFacade = nutsHttpServletFacade;
    }

    @Override
    public void executeImpl(FacadeCommandContext context) throws IOException {
        String boundary = context.getRequestHeaderFirstValue("Content-type");
        if (NutsBlankable.isBlank((String)boundary)) {
            context.sendError(400, "Invalid JShellCommandNode Arguments : " + this.getName() + " . Invalid format.");
            return;
        }
        MultipartStreamHelper stream = new MultipartStreamHelper(context.getRequestBody(), boundary, context.getSession());
        boolean transitive = true;
        String root = null;
        String pattern = null;
        String js = null;
        for (ItemStreamInfo info : stream) {
            String name;
            switch (name = info.resolveVarInHeader("Content-Disposition", "name")) {
                case "root": {
                    root = _IOUtils.loadString(info.getContent(), true).trim();
                    break;
                }
                case "transitive": {
                    transitive = Boolean.parseBoolean(_IOUtils.loadString(info.getContent(), true).trim());
                    break;
                }
                case "pattern": {
                    pattern = _IOUtils.loadString(info.getContent(), true).trim();
                    break;
                }
                case "js": {
                    js = _IOUtils.loadString(info.getContent(), true).trim();
                }
            }
        }
        NutsIterator it = context.getSession().search().setSession(context.getSession().setTransitive(Boolean.valueOf(transitive))).addScripts(new String[]{js}).addId(pattern).getResultIds().iterator();
        context.sendResponseText(200, NutsServerUtils.iteratorNutsIdToString((Iterator<NutsId>)it));
    }
}

