/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nutsserver.http.commands;

import java.io.IOException;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCp;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorParser;
import net.thevpc.nuts.NutsDigest;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTmp;
import net.thevpc.nuts.toolbox.nutsserver.AbstractFacadeCommand;
import net.thevpc.nuts.toolbox.nutsserver.FacadeCommandContext;
import net.thevpc.nuts.toolbox.nutsserver.util.ItemStreamInfo;
import net.thevpc.nuts.toolbox.nutsserver.util.MultipartStreamHelper;

public class DeployFacadeCommand
extends AbstractFacadeCommand {
    public DeployFacadeCommand() {
        super("deploy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeImpl(FacadeCommandContext context) throws IOException {
        String boundary = context.getRequestHeaderFirstValue("Content-type");
        if (NutsBlankable.isBlank((String)boundary)) {
            context.sendError(400, "invalid JShellCommandNode arguments : " + this.getName() + " . invalid format.");
            return;
        }
        NutsSession session = context.getSession();
        MultipartStreamHelper stream = new MultipartStreamHelper(context.getRequestBody(), boundary, session);
        NutsDescriptor descriptor = null;
        String receivedContentHash = null;
        Object content = null;
        String contentFile = null;
        block16: for (ItemStreamInfo info : stream) {
            String name;
            switch (name = info.resolveVarInHeader("Content-Disposition", "name")) {
                case "descriptor": {
                    try {
                        descriptor = NutsDescriptorParser.of((NutsSession)session).setSession(session).parse(info.getContent());
                        continue block16;
                    }
                    finally {
                        info.getContent().close();
                        continue block16;
                    }
                }
                case "content-hash": {
                    try {
                        receivedContentHash = NutsDigest.of((NutsSession)session).setSource(info.getContent()).computeString();
                        continue block16;
                    }
                    finally {
                        info.getContent().close();
                        continue block16;
                    }
                }
                case "content": {
                    contentFile = NutsTmp.of((NutsSession)session).setSession(session).createTempFile(session.locations().getDefaultIdFilename(descriptor.getId().builder().setFaceDescriptor().build())).toString();
                    NutsCp.of((NutsSession)session).setSession(session).setSource(info.getContent()).setTarget(contentFile).run();
                }
            }
        }
        if (contentFile == null) {
            context.sendError(400, "invalid JShellCommandNode arguments : " + this.getName() + " : missing file");
        }
        NutsId id = session.deploy().setContent(contentFile).setSha1(receivedContentHash).setDescriptor(descriptor).setSession(session.copy()).getResult()[0];
        context.sendResponseText(200, id.toString());
    }
}

