/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nutsserver.http;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLDecoder;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.spi.NutsSupportLevelContext;
import net.thevpc.nuts.toolbox.nutsserver.NutsServer;
import net.thevpc.nuts.toolbox.nutsserver.NutsServerComponent;
import net.thevpc.nuts.toolbox.nutsserver.ServerConfig;
import net.thevpc.nuts.toolbox.nutsserver.http.AbstractNutsHttpServletFacadeContext;
import net.thevpc.nuts.toolbox.nutsserver.http.NutsHttpServerConfig;
import net.thevpc.nuts.toolbox.nutsserver.http.NutsHttpServletFacade;

public class NutsHttpServerComponent
implements NutsServerComponent {
    private static final Logger LOG = Logger.getLogger(NutsHttpServerComponent.class.getName());
    private NutsHttpServletFacade facade;

    public static Map<String, List<String>> queryToMap(String query) {
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        if (query != null) {
            for (String param : query.split("&")) {
                String[] pair = param.split("=");
                List li = result.computeIfAbsent(NutsHttpServerComponent.urlDecodeString(pair[0]), d -> new ArrayList());
                if (pair.length > 1) {
                    li.add(NutsHttpServerComponent.urlDecodeString(pair[1]));
                    continue;
                }
                li.add("");
            }
        }
        return result;
    }

    public static String urlDecodeString(String s) {
        if (s == null || s.trim().length() == 0) {
            return s;
        }
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(e);
        }
    }

    public int getSupportLevel(NutsSupportLevelContext config) {
        ServerConfig c = (ServerConfig)config.getConstraints();
        return c == null || c instanceof NutsHttpServerConfig ? 10 : -1;
    }

    @Override
    public NutsServer start(NutsSession invokerSession, ServerConfig config) {
        String k;
        HttpServer server;
        NutsHttpServerConfig httpConfig = (NutsHttpServerConfig)config;
        Map<String, NutsSession> workspaces = httpConfig.getWorkspaces();
        if (invokerSession == null) {
            throw new NutsIllegalArgumentException(invokerSession, NutsMessage.cstyle((String)"missing workspace", (Object[])new Object[0]));
        }
        if (workspaces.isEmpty()) {
            workspaces.put("", invokerSession);
        }
        String serverId = httpConfig.getServerId();
        InetAddress address = httpConfig.getAddress();
        int port = httpConfig.getPort();
        int backlog = httpConfig.getBacklog();
        Executor executor = httpConfig.getExecutor();
        if (NutsBlankable.isBlank((String)serverId)) {
            String serverName = "nuts-http-server";
            try {
                serverName = InetAddress.getLocalHost().getHostName();
                if (serverName != null && serverName.length() > 0) {
                    serverName = "nuts-" + serverName;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (serverName == null) {
                serverName = "nuts-http-server";
            }
            serverId = serverName;
        }
        final NutsSession session = invokerSession;
        this.facade = new NutsHttpServletFacade(serverId, workspaces);
        if (port <= 0) {
            port = 8899;
        }
        if (backlog <= 0) {
            backlog = 10;
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress(address, port);
        try {
            server = httpConfig.isTls() ? HttpsServer.create(inetSocketAddress, backlog) : HttpServer.create(inetSocketAddress, backlog);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (executor == null) {
            int queueSize;
            int idleSeconds;
            int maxPoolSize;
            int corePoolSize = httpConfig.getExecutorCorePoolSize();
            if (corePoolSize <= 0) {
                corePoolSize = 4;
            }
            if ((maxPoolSize = httpConfig.getExecutorMaximumPoolSize()) <= 0) {
                maxPoolSize = 100;
            }
            if (maxPoolSize <= corePoolSize) {
                maxPoolSize = corePoolSize;
            }
            if ((idleSeconds = httpConfig.getExecutorIdleTimeSeconds()) <= 0) {
                idleSeconds = 30;
            }
            if ((queueSize = httpConfig.getExecutorQueueSize()) <= 0) {
                queueSize = maxPoolSize;
            }
            if (queueSize > 1000) {
                queueSize = 1000;
            }
            executor = new ThreadPoolExecutor(corePoolSize, maxPoolSize, idleSeconds, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(queueSize));
        }
        server.setExecutor(executor);
        if (httpConfig.isTls()) {
            if (httpConfig.getSslKeystorePassphrase() == null) {
                throw new NutsIllegalArgumentException(invokerSession, NutsMessage.cstyle((String)"missing SslKeystorePassphrase", (Object[])new Object[0]));
            }
            if (httpConfig.getSslKeystoreCertificate() == null) {
                throw new NutsIllegalArgumentException(invokerSession, NutsMessage.cstyle((String)"missing SslKeystoreCertificate", (Object[])new Object[0]));
            }
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                char[] password = httpConfig.getSslKeystorePassphrase();
                KeyStore ks = KeyStore.getInstance("JKS");
                try {
                    ks.load(new ByteArrayInputStream(httpConfig.getSslKeystoreCertificate()), password);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                kmf.init(ks, password);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                tmf.init(ks);
                sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
                ((HttpsServer)server).setHttpsConfigurator(new HttpsConfigurator(sslContext){

                    @Override
                    public void configure(HttpsParameters params) {
                        try {
                            SSLContext c = SSLContext.getDefault();
                            SSLEngine engine = c.createSSLEngine();
                            params.setNeedClientAuth(false);
                            params.setCipherSuites(engine.getEnabledCipherSuites());
                            params.setProtocols(engine.getEnabledProtocols());
                            SSLParameters defaultSSLParameters = c.getDefaultSSLParameters();
                            params.setSSLParameters(defaultSSLParameters);
                        }
                        catch (Exception ex) {
                            if (LOG.isLoggable(Level.CONFIG)) {
                                LOG.log(Level.CONFIG, "failed to create HTTPS port");
                            }
                            session.err().println("```error failed to create HTTPS port```");
                        }
                    }
                });
            }
            catch (GeneralSecurityException e) {
                throw new NutsIllegalArgumentException(invokerSession, NutsMessage.plain((String)"start server failed"), (Throwable)e);
            }
        }
        server.createContext("/", new HttpHandler(){

            @Override
            public void handle(HttpExchange httpExchange) throws IOException {
                NutsHttpServerComponent.this.facade.execute(new EmbeddedNutsHttpServletFacadeContext(httpExchange));
            }
        });
        server.start();
        NutsPrintStream out = session.out();
        NutsTexts factory = NutsTexts.of((NutsSession)session);
        out.printf("Nuts Http Service '%s' running %s at %s\n", new Object[]{serverId, factory.ofStyled(httpConfig.isTls() ? "https" : "http", NutsTextStyle.primary1()), inetSocketAddress});
        if (workspaces.size() == 1) {
            out.print("Serving workspace : ");
            for (Map.Entry<String, NutsSession> entry : workspaces.entrySet()) {
                k = entry.getKey();
                if (k.equals("")) {
                    out.printf("%s\n", new Object[]{entry.getValue().locations().getWorkspaceLocation()});
                    continue;
                }
                out.printf("%s : %s\n", new Object[]{k, entry.getValue().locations().getWorkspaceLocation()});
            }
        } else {
            out.println("Serving workspaces:");
            for (Map.Entry<String, NutsSession> entry : workspaces.entrySet()) {
                k = entry.getKey();
                if (k.equals("")) {
                    k = "<default>";
                }
                out.printf("\t%s : %s\n", new Object[]{k, entry.getValue().locations().getWorkspaceLocation()});
            }
        }
        final String finalServerId = serverId;
        return new NutsServer(){
            boolean running = true;

            @Override
            public String getServerId() {
                return finalServerId;
            }

            @Override
            public boolean isRunning() {
                return this.running;
            }

            @Override
            public boolean stop() {
                if (this.running) {
                    this.running = false;
                    server.stop(0);
                    return true;
                }
                return false;
            }

            public String toString() {
                return "Nuts Http Server{running=" + this.running + '}';
            }
        };
    }

    private static class EmbeddedNutsHttpServletFacadeContext
    extends AbstractNutsHttpServletFacadeContext {
        private final HttpExchange httpExchange;

        public EmbeddedNutsHttpServletFacadeContext(HttpExchange httpExchange) {
            this.httpExchange = httpExchange;
        }

        @Override
        public void sendResponseBytes(int code, byte[] bytes) throws IOException {
            super.sendResponseBytes(code, bytes);
        }

        @Override
        public String getRequestMethod() throws IOException {
            return this.httpExchange.getRequestMethod();
        }

        @Override
        public URI getRequestURI() throws IOException {
            return this.httpExchange.getRequestURI();
        }

        @Override
        public OutputStream getResponseBody() {
            return this.httpExchange.getResponseBody();
        }

        @Override
        public void sendError(int code, String msg) throws IOException {
            if (msg == null) {
                msg = "error";
            }
            byte[] bytes = msg.getBytes();
            this.httpExchange.sendResponseHeaders(code, bytes.length);
            this.httpExchange.getResponseBody().write(bytes);
        }

        @Override
        public void sendResponseHeaders(int code, long length) throws IOException {
            this.httpExchange.sendResponseHeaders(code, length);
        }

        @Override
        public Set<String> getRequestHeaderKeys(String header) throws IOException {
            return this.httpExchange.getRequestHeaders().keySet();
        }

        @Override
        public String getRequestHeaderFirstValue(String header) throws IOException {
            return this.httpExchange.getRequestHeaders().getFirst(header);
        }

        @Override
        public List<String> getRequestHeaderAllValues(String header) throws IOException {
            return this.httpExchange.getRequestHeaders().get(header);
        }

        @Override
        public InputStream getRequestBody() throws IOException {
            return this.httpExchange.getRequestBody();
        }

        @Override
        public Map<String, List<String>> getParameters() {
            return NutsHttpServerComponent.queryToMap(this.httpExchange.getRequestURI().getQuery());
        }

        @Override
        public void addResponseHeader(String name, String value) throws IOException {
            this.httpExchange.getResponseHeaders().add(name, value);
        }
    }
}

