/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nutsserver.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.thevpc.nuts.toolbox.nutsserver.bundled._IOUtils;
import net.thevpc.nuts.toolbox.nutsserver.http.NutsHttpServletFacadeContext;

public abstract class AbstractNutsHttpServletFacadeContext
implements NutsHttpServletFacadeContext {
    @Override
    public void sendResponseText(int code, String text) throws IOException {
        byte[] bytes = text.getBytes();
        this.sendResponseHeaders(code, bytes.length);
        this.getResponseBody().write(bytes);
    }

    @Override
    public void sendResponseFile(int code, File file) throws IOException {
        if (file != null && file.exists() && file.isFile()) {
            this.sendResponseHeaders(code, file.length());
            _IOUtils.copy(new FileInputStream(file), this.getResponseBody(), true, false);
        } else {
            this.sendError(404, "File not found");
        }
    }

    @Override
    public void sendResponseBytes(int code, byte[] bytes) throws IOException {
        this.sendResponseHeaders(code, bytes.length);
        this.getResponseBody().write(bytes);
    }

    @Override
    public void sendResponseFile(int code, Path file) throws IOException {
        if (file != null && Files.isRegularFile(file, new LinkOption[0])) {
            this.sendResponseHeaders(code, Files.size(file));
            Files.copy(file, this.getResponseBody());
        } else {
            this.sendError(404, "File not found");
        }
    }

    @Override
    public boolean isGetMethod() throws IOException {
        return "GET".equalsIgnoreCase(this.getRequestMethod());
    }

    @Override
    public boolean isPostMethod() throws IOException {
        return "POST".equalsIgnoreCase(this.getRequestMethod());
    }

    @Override
    public boolean isHeadMethod() throws IOException {
        return "HEAD".equalsIgnoreCase(this.getRequestMethod());
    }
}

