/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nutsserver.bundled;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class _IOUtils {
    public static final int DEFAULT_BUFFER_SIZE = 1024;

    public static String loadString(URL url) throws IOException {
        return new String(_IOUtils.loadByteArray(url));
    }

    public static String loadString(InputStream r, boolean close) throws IOException {
        try {
            String string = _IOUtils.loadString(r);
            return string;
        }
        finally {
            if (close) {
                r.close();
            }
        }
    }

    public static String loadString(InputStream r) throws IOException {
        return new String(_IOUtils.loadByteArray(r));
    }

    public static byte[] loadByteArray(File stream) throws IOException {
        try (FileInputStream r = new FileInputStream(stream);){
            byte[] byArray = _IOUtils.loadByteArray(r);
            return byArray;
        }
    }

    public static byte[] loadByteArray(URL url) throws IOException {
        try (InputStream r = null;){
            r = url.openStream();
            byte[] byArray = _IOUtils.loadByteArray(r);
            return byArray;
        }
    }

    public static byte[] loadByteArray(InputStream r) throws IOException {
        try (ByteArrayOutputStream out = null;){
            out = new ByteArrayOutputStream();
            _IOUtils.copy(r, (OutputStream)out);
            out.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        _IOUtils.copy(in, out, 1024);
    }

    public static void copy(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int len;
        byte[] buffer = new byte[bufferSize];
        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
    }

    public static void copy(File in, OutputStream out) throws IOException {
        _IOUtils.copy(in, out, 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File in, OutputStream out, int bufferSize) throws IOException {
        try (FileInputStream fis = null;){
            fis = new FileInputStream(in);
            _IOUtils.copy(fis, out, bufferSize);
        }
    }

    public static String getAbsoluteFile2(String path, String cwd) {
        if (new File(path).isAbsolute()) {
            return path;
        }
        if (cwd == null) {
            cwd = System.getProperty("user.dir");
        }
        switch (path) {
            case "~": {
                return System.getProperty("user.home");
            }
            case ".": {
                File file = new File(cwd);
                try {
                    return file.getCanonicalPath();
                }
                catch (IOException ex) {
                    return file.getAbsolutePath();
                }
            }
            case "..": {
                File file = new File(cwd, "..");
                try {
                    return file.getCanonicalPath();
                }
                catch (IOException ex) {
                    return file.getAbsolutePath();
                }
            }
        }
        int j = -1;
        char[] chars = path.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '/' && chars[i] != '\\') continue;
            j = i;
            break;
        }
        if (j > 0) {
            switch (path.substring(0, j)) {
                case "~": {
                    String e = path.substring(j + 1);
                    if (e.isEmpty()) {
                        return System.getProperty("user.home");
                    }
                    File file = new File(System.getProperty("user.home"), e);
                    try {
                        return file.getCanonicalPath();
                    }
                    catch (IOException ex) {
                        return file.getAbsolutePath();
                    }
                }
            }
        }
        File file = new File(cwd, path);
        try {
            return file.getCanonicalPath();
        }
        catch (IOException ex) {
            return file.getAbsolutePath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream from, OutputStream to, boolean closeInput, boolean closeOutput) throws IOException {
        byte[] bytes = new byte[1024];
        long all = 0L;
        try {
            long l;
            block9: {
                try {
                    int count;
                    while ((count = from.read(bytes)) > 0) {
                        to.write(bytes, 0, count);
                        all += (long)count;
                    }
                    l = all;
                    if (!closeInput) break block9;
                }
                catch (Throwable throwable) {
                    if (closeInput) {
                        from.close();
                    }
                    throw throwable;
                }
                from.close();
            }
            return l;
        }
        finally {
            if (closeOutput) {
                to.close();
            }
        }
    }
}

