/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nutsserver.admin;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.Executor;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsIdResolver;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSessionTerminal;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShell;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;
import net.thevpc.nuts.toolbox.nutsserver.NutsServer;

public class AdminServerRunnable
implements NutsServer,
Runnable {
    private final String serverId;
    int finalPort;
    int finalBacklog;
    InetAddress address;
    Executor finalExecutor;
    NutsSession invokerSession;
    boolean running;
    ServerSocket serverSocket = null;
    NutsSession session = null;

    public AdminServerRunnable(String serverId, int finalPort, int finalBacklog, InetAddress address, Executor finalExecutor, NutsSession invokerSession, NutsSession session) {
        this.serverId = serverId;
        this.finalPort = finalPort;
        this.finalBacklog = finalBacklog;
        this.address = address;
        this.finalExecutor = finalExecutor;
        this.invokerSession = invokerSession;
        this.session = session;
    }

    @Override
    public String getServerId() {
        return this.serverId;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public boolean stop() {
        if (this.running) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        try {
            try {
                this.serverSocket = new ServerSocket(this.finalPort, this.finalBacklog, this.address);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.running = false;
                return;
            }
            while (this.running) {
                try {
                    Socket accept = null;
                    try {
                        accept = this.serverSocket.accept();
                    }
                    catch (Exception ex) {
                        this.running = false;
                        break;
                    }
                    final ServerSocket finalServerSocket = this.serverSocket;
                    final Socket finalAccept = accept;
                    this.finalExecutor.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            String[] args = new String[]{"net.thevpc.nuts.toolbox:nsh"};
                            JShell cli = null;
                            try {
                                try {
                                    PrintStream out = new PrintStream(finalAccept.getOutputStream());
                                    NutsPrintStream eout = NutsPrintStream.of((OutputStream)out, (NutsTerminalMode)NutsTerminalMode.FORMATTED, null, (NutsSession)AdminServerRunnable.this.invokerSession);
                                    NutsSession session = AdminServerRunnable.this.invokerSession;
                                    session.setTerminal(NutsSessionTerminal.of((InputStream)finalAccept.getInputStream(), (NutsPrintStream)eout, (NutsPrintStream)eout, (NutsSession)AdminServerRunnable.this.invokerSession));
                                    cli = new JShell(session, NutsIdResolver.of((NutsSession)AdminServerRunnable.this.invokerSession).resolveId(AdminServerRunnable.class), AdminServerRunnable.this.serverId, new String[0]);
                                    cli.getRootContext().builtins().unset("connect");
                                    cli.getRootContext().builtins().set((JShellBuiltin)new StopServerBuiltin2(finalServerSocket));
                                    cli.run();
                                }
                                finally {
                                    finalAccept.close();
                                }
                            }
                            catch (IOException e) {
                                AdminServerRunnable.this.session.err().printf("%s\n", new Object[]{e});
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    this.session.err().printf("%s\n", new Object[]{ex});
                }
            }
        }
        finally {
            this.running = false;
        }
    }

    public String toString() {
        return "Nuts Admin Server{running=" + this.running + '}';
    }

    @NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
    private static class StopServerBuiltin2
    extends SimpleJShellBuiltin {
        private final ServerSocket socket;

        public StopServerBuiltin2(ServerSocket finalServerSocket) {
            super("stop-server", 10, Options.class);
            this.socket = finalServerSocket;
        }

        protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
            return false;
        }

        protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
            if (context.getSession().isPlainTrace()) {
                context.getSession().out().println("Stopping Server ...");
            }
            try {
                this.socket.close();
            }
            catch (IOException ex) {
                throw new NutsExecutionException(context.getSession(), NutsMessage.cstyle((String)"%s", (Object[])new Object[]{ex}), (Throwable)ex, 100);
            }
        }

        private static class Options {
            private Options() {
            }
        }
    }
}

