/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nutsserver;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.LoginException;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsWorkspaceSecurityManager;
import net.thevpc.nuts.toolbox.nutsserver.FacadeCommand;
import net.thevpc.nuts.toolbox.nutsserver.FacadeCommandContext;

public abstract class AbstractFacadeCommand
implements FacadeCommand {
    private String name;

    public AbstractFacadeCommand(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(FacadeCommandContext context) throws IOException, LoginException {
        Map<String, List<String>> parameters = context.getParameters();
        List<String> ulList = parameters.get("ul");
        String userLogin = ulList == null || ulList.isEmpty() ? null : ulList.get(0);
        List<String> upList = parameters.get("ul");
        String userPasswordS = upList == null || upList.isEmpty() ? null : upList.get(0);
        char[] userPassword = userPasswordS == null ? null : userPasswordS.toCharArray();
        NutsWorkspaceSecurityManager secu = context.getSession().security();
        userLogin = userLogin == null ? null : new String(secu.getCredentials(userLogin.toCharArray()));
        char[] cArray = userPassword = userPassword == null ? null : secu.getCredentials(userPassword);
        if (!NutsBlankable.isBlank((String)userLogin)) {
            boolean loggedId = false;
            try {
                context.getSession().security().login(userLogin, userPassword);
                loggedId = true;
                this.executeImpl(context);
            }
            finally {
                if (loggedId) {
                    context.getSession().security().logout();
                }
            }
        } else {
            this.executeImpl(context);
        }
    }

    public abstract void executeImpl(FacadeCommandContext var1) throws IOException, LoginException;
}

