/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nutsserver.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Iterator;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.toolbox.nutsserver.util.ItemStreamInfo;
import net.thevpc.nuts.toolbox.nutsserver.util.MultipartStream2;

public class MultipartStreamHelper
implements Iterable<ItemStreamInfo> {
    private MultipartStream2 stream;
    private NutsSession session;

    public MultipartStreamHelper(InputStream input, String contentType, NutsSession session) {
        this.session = session;
        this.stream = new MultipartStream2(input, MultipartStreamHelper.resolveBoundaryFromContentType(contentType, session), 4096, null, session);
    }

    private static byte[] resolveBoundaryFromContentType(String contentType, NutsSession session) {
        for (String s : contentType.split(";")) {
            if (!(s = s.trim()).startsWith("boundary=")) continue;
            return s.substring("boundary=".length()).getBytes();
        }
        throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid boundary", (Object[])new Object[0]));
    }

    @Override
    public Iterator<ItemStreamInfo> iterator() {
        return new MultipartStream2Iterator();
    }

    private ItemStreamInfo newInputStreamSplitted() throws IOException {
        final MultipartStream2.ItemInputStream itemInputStream = this.stream.newInputStream();
        ByteArrayOutputStream headers = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while (true) {
            int count = ((InputStream)itemInputStream).read(buffer, 0, buffer.length - 4);
            for (int i = 0; i < count; ++i) {
                if (buffer[i] != 13) continue;
                if (i + 3 >= buffer.length - 4) {
                    int x = ((InputStream)itemInputStream).read(buffer, count, buffer.length - 4);
                    count += x;
                }
                if (i + 3 >= buffer.length - 4) continue;
                if (buffer[i + 1] != 10) continue;
                if (buffer[i + 2] != 13) continue;
                if (buffer[i + 3] != 10) continue;
                headers.write(buffer, 0, i);
                final byte[] start = new byte[count - (i + 4)];
                System.arraycopy(buffer, i + 4, start, 0, start.length);
                return new ItemStreamInfo(new ByteArrayInputStream(headers.toByteArray()), new InputStream(){
                    int index = 0;

                    @Override
                    public int read() throws IOException {
                        if (this.index < start.length) {
                            ++this.index;
                            return start[this.index - 1] & 0xFF;
                        }
                        return itemInputStream.read();
                    }
                }, this.session);
            }
            headers.write(buffer, 0, count);
        }
    }

    private class MultipartStream2Iterator
    implements Iterator<ItemStreamInfo> {
        boolean first = true;
        boolean nextPart = false;

        private MultipartStream2Iterator() {
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.first) {
                    this.first = false;
                    this.nextPart = MultipartStreamHelper.this.stream.skipPreamble();
                } else {
                    this.nextPart = MultipartStreamHelper.this.stream.readBoundary();
                }
                return this.nextPart;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new NutsException(MultipartStreamHelper.this.session, NutsMessage.plain((String)"parse multipart failed"), (Throwable)e);
            }
        }

        @Override
        public ItemStreamInfo next() {
            try {
                return MultipartStreamHelper.this.newInputStreamSplitted();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported");
        }
    }
}

