/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nutsserver.http.commands;

import java.io.IOException;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.toolbox.nutsserver.AbstractFacadeCommand;
import net.thevpc.nuts.toolbox.nutsserver.FacadeCommandContext;
import net.thevpc.nuts.toolbox.nutsserver.bundled._StringUtils;
import net.thevpc.nuts.toolbox.nutsserver.util.ItemStreamInfo;
import net.thevpc.nuts.toolbox.nutsserver.util.MultipartStreamHelper;

public class DeployFacadeCommand
extends AbstractFacadeCommand {
    public DeployFacadeCommand() {
        super("deploy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeImpl(FacadeCommandContext context) throws IOException {
        String boundary = context.getRequestHeaderFirstValue("Content-type");
        if (_StringUtils.isBlank(boundary)) {
            context.sendError(400, "invalid JShellCommandNode arguments : " + this.getName() + " . invalid format.");
            return;
        }
        MultipartStreamHelper stream = new MultipartStreamHelper(context.getRequestBody(), boundary, context.getSession());
        NutsDescriptor descriptor = null;
        String receivedContentHash = null;
        Object content = null;
        String contentFile = null;
        block16: for (ItemStreamInfo info : stream) {
            String name;
            switch (name = info.resolveVarInHeader("Content-Disposition", "name")) {
                case "descriptor": {
                    try {
                        descriptor = context.getWorkspace().descriptor().parser().setSession(context.getSession()).parse(info.getContent());
                        continue block16;
                    }
                    finally {
                        info.getContent().close();
                        continue block16;
                    }
                }
                case "content-hash": {
                    try {
                        receivedContentHash = context.getWorkspace().io().hash().setSource(info.getContent()).computeString();
                        continue block16;
                    }
                    finally {
                        info.getContent().close();
                        continue block16;
                    }
                }
                case "content": {
                    contentFile = context.getWorkspace().io().tmp().setSession(context.getSession()).createTempFile(context.getWorkspace().locations().getDefaultIdFilename(descriptor.getId().builder().setFaceDescriptor().build()));
                    context.getWorkspace().io().copy().setSession(context.getSession()).setSource(info.getContent()).setTarget(contentFile).run();
                }
            }
        }
        if (contentFile == null) {
            context.sendError(400, "invalid JShellCommandNode arguments : " + this.getName() + " : missing file");
        }
        NutsId id = context.getWorkspace().deploy().setContent(contentFile).setSha1(receivedContentHash).setDescriptor(descriptor).setSession(context.getSession().copy()).getResult()[0];
        context.sendResponseText(200, id.toString());
    }
}

