/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nutsserver.http;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.toolbox.nutsserver.AbstractFacadeCommand;
import net.thevpc.nuts.toolbox.nutsserver.FacadeCommand;
import net.thevpc.nuts.toolbox.nutsserver.FacadeCommandContext;
import net.thevpc.nuts.toolbox.nutsserver.http.NutsHttpServletFacadeContext;
import net.thevpc.nuts.toolbox.nutsserver.http.commands.DeployFacadeCommand;
import net.thevpc.nuts.toolbox.nutsserver.http.commands.ExecFacadeCommand;
import net.thevpc.nuts.toolbox.nutsserver.http.commands.FetchDescriptorFacadeCommand;
import net.thevpc.nuts.toolbox.nutsserver.http.commands.FetchDescriptorHashFacadeCommand;
import net.thevpc.nuts.toolbox.nutsserver.http.commands.FetchFacadeCommand;
import net.thevpc.nuts.toolbox.nutsserver.http.commands.FetchHashFacadeCommand;
import net.thevpc.nuts.toolbox.nutsserver.http.commands.GetBootFacadeCommand;
import net.thevpc.nuts.toolbox.nutsserver.http.commands.GetMavenFacadeCommand;
import net.thevpc.nuts.toolbox.nutsserver.http.commands.ResolveIdFacadeCommand;
import net.thevpc.nuts.toolbox.nutsserver.http.commands.SearchFacadeCommand;
import net.thevpc.nuts.toolbox.nutsserver.http.commands.VersionFacadeCommand;
import net.thevpc.nuts.toolbox.nutsserver.util.NutsServerUtils;

public class NutsHttpServletFacade {
    private static final Logger LOG = Logger.getLogger(NutsHttpServletFacade.class.getName());
    private Map<String, NutsWorkspace> workspaces;
    private String serverId;
    private Map<String, FacadeCommand> commands = new HashMap<String, FacadeCommand>();

    public NutsHttpServletFacade(String serverId, Map<String, NutsWorkspace> workspaces) {
        this.workspaces = workspaces;
        this.serverId = serverId;
        this.register(new VersionFacadeCommand());
        this.register(new GetMavenFacadeCommand());
        this.register(new FetchFacadeCommand());
        this.register(new FetchDescriptorFacadeCommand());
        this.register(new FetchHashFacadeCommand());
        this.register(new FetchDescriptorHashFacadeCommand());
        this.register(new SearchVersionsFacadeCommand());
        this.register(new ResolveIdFacadeCommand());
        this.register(new SearchFacadeCommand(this));
        this.register(new DeployFacadeCommand());
        this.register(new ExecFacadeCommand());
        this.register(new GetBootFacadeCommand());
    }

    public Map<String, NutsWorkspace> getWorkspaces() {
        return this.workspaces;
    }

    public NutsHttpServletFacade setWorkspaces(Map<String, NutsWorkspace> workspaces) {
        this.workspaces = workspaces;
        return this;
    }

    public String getServerId() {
        return this.serverId;
    }

    public NutsHttpServletFacade setServerId(String serverId) {
        this.serverId = serverId;
        return this;
    }

    public Map<String, FacadeCommand> getCommands() {
        return this.commands;
    }

    public NutsHttpServletFacade setCommands(Map<String, FacadeCommand> commands) {
        this.commands = commands;
        return this;
    }

    protected void register(FacadeCommand cmd) {
        this.commands.put(cmd.getName(), cmd);
    }

    private URLInfo parse(String requestURI, boolean root) {
        URLInfo ii = new URLInfo();
        String[] tokens = NutsServerUtils.extractFirstToken(requestURI);
        if (root) {
            ii.context = "";
        } else {
            ii.context = tokens[0];
            tokens = NutsServerUtils.extractFirstToken(tokens[1]);
        }
        if (!this.commands.containsKey(tokens[0])) {
            if (GetMavenFacadeCommand.acceptUri(tokens[1])) {
                ii.command = "get-mvn";
                ii.path = requestURI;
            } else {
                ii.command = tokens[0];
                ii.path = tokens[1];
            }
        } else {
            ii.command = tokens[0];
            ii.path = tokens[1];
        }
        return ii;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(NutsHttpServletFacadeContext context) throws IOException {
        String requestPath = context.getRequestURI().getPath();
        URLInfo ii = this.parse(requestPath, false);
        NutsWorkspace ws = this.workspaces.get(ii.context);
        if (ws == null && (ws = this.workspaces.get("")) != null) {
            ii = this.parse(requestPath, true);
        }
        if (ws == null) {
            context.sendError(404, "Workspace not found");
            return;
        }
        FacadeCommand facadeCommand = this.commands.get(ii.command);
        if (facadeCommand == null) {
            if (ii.command.isEmpty()) {
                context.sendError(404, "missing command");
            } else {
                context.sendError(404, "JShellCommandNode Not found : " + ii.command);
            }
        } else {
            try {
                try {
                    facadeCommand.execute(new FacadeCommandContext(context, ws, this.serverId, ii.command, ii.path, ws.createSession()));
                }
                catch (SecurityException ex) {
                    LOG.log(Level.SEVERE, "SERVER ERROR : " + ex, ex);
                    context.sendError(403, ex.toString());
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, "SERVER ERROR : " + ex, ex);
                    context.sendError(500, ex.toString());
                }
            }
            finally {
                if (!context.isHeadMethod()) {
                    try {
                        context.getResponseBody().flush();
                        context.getResponseBody().close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public class SearchVersionsFacadeCommand
    extends AbstractFacadeCommand {
        public SearchVersionsFacadeCommand() {
            super("find-versions");
        }

        @Override
        public void executeImpl(FacadeCommandContext context) throws IOException {
            Map<String, List<String>> parameters = context.getParameters();
            List<String> idList = parameters.get("id");
            String id = idList == null || idList.isEmpty() ? null : idList.get(0);
            boolean transitive = parameters.containsKey("transitive");
            List fetch = null;
            try {
                NutsWorkspace ws = context.getWorkspace();
                fetch = ws.search().setSession(context.getSession().copy().setTransitive(Boolean.valueOf(transitive))).addId(id).getResultIds().list();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (fetch != null) {
                context.sendResponseText(200, NutsServerUtils.iteratorNutsIdToString(fetch.iterator()));
            } else {
                context.sendError(404, "Nuts not Found");
            }
        }
    }

    private static class URLInfo {
        String context;
        String command;
        String path;

        private URLInfo() {
        }
    }
}

