/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nutsserver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.toolbox.nutsserver.NutsServer;
import net.thevpc.nuts.toolbox.nutsserver.NutsServerComponent;
import net.thevpc.nuts.toolbox.nutsserver.NutsWorkspaceServerManager;
import net.thevpc.nuts.toolbox.nutsserver.ServerConfig;
import net.thevpc.nuts.toolbox.nutsserver.http.NutsHttpServerConfig;

public class DefaultNutsWorkspaceServerManager
implements NutsWorkspaceServerManager {
    private final NutsWorkspace ws;
    private final NutsSession session;
    private Map<String, NutsServer> servers = new HashMap<String, NutsServer>();

    public DefaultNutsWorkspaceServerManager(NutsSession session) {
        this.session = session;
        this.ws = session.getWorkspace();
    }

    @Override
    public NutsServer startServer(ServerConfig serverConfig) {
        NutsServerComponent server;
        if (serverConfig == null) {
            serverConfig = new NutsHttpServerConfig();
        }
        if ((server = (NutsServerComponent)this.ws.extensions().createServiceLoader(NutsServerComponent.class, ServerConfig.class, NutsServerComponent.class.getClassLoader()).loadBest((Object)serverConfig)) == null) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"not server extensions are registered.", (Object[])new Object[0]));
        }
        NutsServer s = server.start(this.ws.createSession(), serverConfig);
        if (this.servers.get(s.getServerId()) != null) {
            this.servers.get(s.getServerId()).stop();
        }
        this.servers.put(s.getServerId(), s);
        return s;
    }

    @Override
    public NutsServer getServer(String serverId) {
        NutsServer nutsServer = this.servers.get(serverId);
        if (nutsServer == null) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"server not found %s", (Object[])new Object[]{serverId}));
        }
        return nutsServer;
    }

    @Override
    public void stopServer(String serverId) {
        this.getServer(serverId).stop();
    }

    @Override
    public boolean isServerRunning(String serverId) {
        NutsServer nutsServer = this.servers.get(serverId);
        if (nutsServer == null) {
            return false;
        }
        return nutsServer.isRunning();
    }

    @Override
    public List<NutsServer> getServers() {
        return new ArrayList<NutsServer>(this.servers.values());
    }
}

