/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nutsserver.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;

public class ItemStreamInfo {
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private InputStream content;
    private NutsSession session;

    public ItemStreamInfo(InputStream header, InputStream content, NutsSession ws) throws IOException {
        this.content = content;
        this.session = ws;
        BufferedReader r = new BufferedReader(new InputStreamReader(header));
        String line = null;
        while ((line = r.readLine()) != null) {
            int i;
            if (line.trim().length() <= 0 || (i = line.indexOf(58)) <= 0) continue;
            String k = line.substring(0, i).trim();
            String v = line.substring(i + 1).trim();
            List<String> strings = this.headers.get(k);
            if (strings == null) {
                strings = new ArrayList<String>();
                this.headers.put(k, strings);
            }
            strings.add(v);
        }
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public InputStream getContent() {
        return this.content;
    }

    public String resolveVarInHeader(String contentType, String var) {
        List<String> strings = this.getHeaders().get(contentType);
        return this.resolveVarInContentType(strings.get(0), var);
    }

    public String resolveVarInContentType(String contentType, String var) {
        for (String s : contentType.split(";")) {
            if (!(s = s.trim()).startsWith(var + "=")) continue;
            String substring = s.substring((var + "=").length());
            if ((substring = substring.trim()).startsWith("\"")) {
                substring = substring.substring(1, substring.length() - 1);
            }
            return substring;
        }
        throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"invalid boundary", (Object[])new Object[0]));
    }
}

