/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nutsserver.admin;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSupportLevelContext;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.toolbox.nutsserver.AdminServerConfig;
import net.thevpc.nuts.toolbox.nutsserver.NutsServer;
import net.thevpc.nuts.toolbox.nutsserver.NutsServerComponent;
import net.thevpc.nuts.toolbox.nutsserver.ServerConfig;
import net.thevpc.nuts.toolbox.nutsserver.admin.AdminServerRunnable;
import net.thevpc.nuts.toolbox.nutsserver.bundled._StringUtils;

public class NutsAdminServerComponent
implements NutsServerComponent {
    private static final Logger LOG = Logger.getLogger(NutsAdminServerComponent.class.getName());

    public int getSupportLevel(NutsSupportLevelContext<ServerConfig> config) {
        ServerConfig c = (ServerConfig)config.getConstraints();
        return c == null || c instanceof AdminServerConfig ? 10 : -1;
    }

    @Override
    public NutsServer start(NutsSession invokerWorkspace, ServerConfig config) {
        AdminServerConfig httpConfig = (AdminServerConfig)config;
        if (invokerWorkspace == null) {
            throw new NutsIllegalArgumentException(invokerWorkspace, NutsMessage.cstyle((String)"missing workspace", (Object[])new Object[0]));
        }
        NutsSession session = invokerWorkspace;
        String serverId = httpConfig.getServerId();
        InetAddress address = httpConfig.getAddress();
        int port = httpConfig.getPort();
        int backlog = httpConfig.getBacklog();
        Executor executor = httpConfig.getExecutor();
        if (executor == null) {
            executor = new ThreadPoolExecutor(2, 10, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));
        }
        if (_StringUtils.isBlank(serverId)) {
            String serverName = "nuts-admin-server";
            try {
                serverName = InetAddress.getLocalHost().getHostName();
                if (serverName != null && serverName.length() > 0) {
                    serverName = "nuts-" + serverName;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (serverName == null) {
                serverName = "nuts-admin-server";
            }
            serverId = serverName;
        }
        if (port <= 0) {
            port = 8898;
        }
        if (backlog <= 0) {
            backlog = 10;
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress(address, port);
        NutsPrintStream out = session.out();
        NutsTextManager factory = session.getWorkspace().text();
        out.printf("Nuts Admin Service '%s' running %s at %s\n", new Object[]{serverId, factory.forStyled("telnet nsh", NutsTextStyle.primary1()), inetSocketAddress});
        out.printf("Serving workspace : %s\n", new Object[]{invokerWorkspace.getWorkspace().locations().getWorkspaceLocation()});
        AdminServerRunnable myNutsServer = new AdminServerRunnable(serverId, port, backlog, address, executor, invokerWorkspace.getWorkspace(), session);
        executor.execute(myNutsServer);
        return myNutsServer;
    }
}

