/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nutsserver.admin;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.Executor;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSingleton;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.toolbox.nsh.SimpleNshBuiltin;
import net.thevpc.nuts.toolbox.nsh.bundles.jshell.JShell;
import net.thevpc.nuts.toolbox.nsh.bundles.jshell.JShellBuiltin;
import net.thevpc.nuts.toolbox.nutsserver.NutsServer;

public class AdminServerRunnable
implements NutsServer,
Runnable {
    private final String serverId;
    int finalPort;
    int finalBacklog;
    InetAddress address;
    Executor finalExecutor;
    NutsWorkspace invokerWorkspace;
    boolean running;
    ServerSocket serverSocket = null;
    NutsSession session = null;

    public AdminServerRunnable(String serverId, int finalPort, int finalBacklog, InetAddress address, Executor finalExecutor, NutsWorkspace invokerWorkspace, NutsSession session) {
        this.serverId = serverId;
        this.finalPort = finalPort;
        this.finalBacklog = finalBacklog;
        this.address = address;
        this.finalExecutor = finalExecutor;
        this.invokerWorkspace = invokerWorkspace;
        this.session = session;
    }

    @Override
    public String getServerId() {
        return this.serverId;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public boolean stop() {
        if (this.running) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        try {
            try {
                this.serverSocket = new ServerSocket(this.finalPort, this.finalBacklog, this.address);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.running = false;
                return;
            }
            while (this.running) {
                try {
                    Socket accept = null;
                    try {
                        accept = this.serverSocket.accept();
                    }
                    catch (Exception ex) {
                        this.running = false;
                        break;
                    }
                    final ServerSocket finalServerSocket = this.serverSocket;
                    final Socket finalAccept = accept;
                    this.finalExecutor.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            String[] args = new String[]{"net.thevpc.nuts.toolbox:nsh"};
                            JShell cli = null;
                            try {
                                try {
                                    PrintStream out = new PrintStream(finalAccept.getOutputStream());
                                    NutsPrintStream eout = AdminServerRunnable.this.invokerWorkspace.io().createPrintStream((OutputStream)out, NutsTerminalMode.FORMATTED);
                                    NutsSession session = AdminServerRunnable.this.invokerWorkspace.createSession();
                                    session.setTerminal(AdminServerRunnable.this.invokerWorkspace.term().createTerminal(finalAccept.getInputStream(), eout, eout));
                                    cli = new JShell(session, AdminServerRunnable.this.invokerWorkspace.id().setSession(session).resolveId(AdminServerRunnable.class), AdminServerRunnable.this.serverId, new String[0]);
                                    cli.getRootContext().builtins().unset("connect");
                                    cli.getRootContext().builtins().set((JShellBuiltin)new StopServerBuiltin2(finalServerSocket));
                                    cli.run();
                                }
                                finally {
                                    finalAccept.close();
                                }
                            }
                            catch (IOException e) {
                                AdminServerRunnable.this.session.err().printf("%s\n", new Object[]{e});
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    this.session.err().printf("%s\n", new Object[]{ex});
                }
            }
        }
        finally {
            this.running = false;
        }
    }

    public String toString() {
        return "Nuts Admin Server{running=" + this.running + '}';
    }

    @NutsSingleton
    private static class StopServerBuiltin2
    extends SimpleNshBuiltin {
        private final ServerSocket socket;

        public StopServerBuiltin2(ServerSocket finalServerSocket) {
            super("stop-server", 10);
            this.socket = finalServerSocket;
        }

        protected Object createOptions() {
            return new Options();
        }

        protected boolean configureFirst(NutsCommandLine commandLine, SimpleNshBuiltin.SimpleNshCommandContext context) {
            return false;
        }

        protected void createResult(NutsCommandLine commandLine, SimpleNshBuiltin.SimpleNshCommandContext context) {
            if (context.getSession().isPlainTrace()) {
                context.getSession().out().println("Stopping Server ...");
            }
            try {
                this.socket.close();
            }
            catch (IOException ex) {
                throw new NutsExecutionException(context.getSession(), NutsMessage.cstyle((String)"%s", (Object[])new Object[]{ex}), (Throwable)ex, 100);
            }
        }

        private static class Options {
            private Options() {
            }
        }
    }
}

