/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nutsserver;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.NutsApplication;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCommandLineManager;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOpenMode;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.toolbox.nutsserver.AdminServerConfig;
import net.thevpc.nuts.toolbox.nutsserver.DefaultNutsWorkspaceServerManager;
import net.thevpc.nuts.toolbox.nutsserver.NutsServer;
import net.thevpc.nuts.toolbox.nutsserver.ServerConfig;
import net.thevpc.nuts.toolbox.nutsserver.bundled._IOUtils;
import net.thevpc.nuts.toolbox.nutsserver.bundled._StringUtils;
import net.thevpc.nuts.toolbox.nutsserver.http.NutsHttpServerConfig;

public class NutsServerMain
implements NutsApplication {
    public static final Pattern HOST_PATTERN = Pattern.compile("((<?protocol>(http|https|admin))://)?(<host>[a-zA-Z0-9_-]+)(<port>:[0-9]+)?");
    private CountDownLatch lock = new CountDownLatch(1);

    public static void main(String[] args) {
        new NutsServerMain().runAndExit(args);
    }

    public void run(NutsApplicationContext context) {
        NutsCommandLine cmdLine = context.getCommandLine().setCommandName("nuts-server");
        cmdLine.setCommandName("nuts-server");
        while (cmdLine.hasNext()) {
            if (cmdLine.next(new String[]{"start"}) != null) {
                this.start(context, cmdLine);
                return;
            }
            if (cmdLine.next(new String[]{"stop"}) != null) {
                this.stop(context, cmdLine);
                return;
            }
            if (cmdLine.next(new String[]{"list"}) != null) {
                this.list(context, cmdLine);
                return;
            }
            if (cmdLine.next(new String[]{"status"}) != null) {
                this.status(context, cmdLine);
                return;
            }
            context.configureLast(cmdLine);
        }
        this.list(context, cmdLine);
    }

    private void list(NutsApplicationContext context, NutsCommandLine cmdLine) {
        DefaultNutsWorkspaceServerManager serverManager = new DefaultNutsWorkspaceServerManager(context.getSession());
        cmdLine.setCommandName("nuts-server list").unexpectedArgument();
        if (cmdLine.isExecMode()) {
            List<NutsServer> servers = serverManager.getServers();
            NutsPrintStream out = context.getSession().out();
            if (servers.isEmpty()) {
                out.print("No Server is Running by current instance\n");
            }
            NutsTextManager text = context.getWorkspace().text();
            for (NutsServer o : servers) {
                if (o.isRunning()) {
                    out.printf("%s %s\n", new Object[]{text.forStyled("running", NutsTextStyle.primary4()), o.getServerId()});
                    continue;
                }
                out.printf("%s %s\n", new Object[]{text.forStyled("stopped", NutsTextStyle.primary4()), o.getServerId()});
            }
        }
    }

    private void stop(NutsApplicationContext context, NutsCommandLine cmdLine) {
        DefaultNutsWorkspaceServerManager serverManager = new DefaultNutsWorkspaceServerManager(context.getSession());
        NutsCommandLineManager commandLineFormat = context.getWorkspace().commandLine();
        int count = 0;
        while (cmdLine.hasNext()) {
            if (count == 0) {
                cmdLine.required();
            } else if (cmdLine.isEmpty()) break;
            ++count;
            String s = cmdLine.nextRequiredNonOption(commandLineFormat.createName("ServerName")).getString();
            if (!cmdLine.isExecMode()) continue;
            serverManager.stopServer(s);
        }
    }

    private void start(NutsApplicationContext context, NutsCommandLine commandLine) {
        DefaultNutsWorkspaceServerManager serverManager = new DefaultNutsWorkspaceServerManager(context.getSession());
        NutsCommandLineManager commandLineFormat = context.getWorkspace().commandLine();
        SrvInfoList servers = new SrvInfoList(context.getSession());
        while (commandLine.hasNext()) {
            if (commandLine.next(new String[]{"--http"}) != null) {
                servers.add().serverType = "http";
                continue;
            }
            if (commandLine.next(new String[]{"--https"}) != null) {
                servers.add().serverType = "https";
                continue;
            }
            if (commandLine.next(new String[]{"--admin"}) != null) {
                servers.add().serverType = "admin";
                continue;
            }
            NutsArgument a = commandLine.nextBoolean(new String[]{"-R", "--read-only"});
            if (a != null) {
                servers.current().readOnly = a.getBooleanValue();
                continue;
            }
            a = commandLine.nextString(new String[]{"-n", "--name"});
            if (a != null) {
                servers.current().name = a.getStringValue();
                continue;
            }
            a = commandLine.nextString(new String[]{"-a", "--address"});
            if (a != null) {
                servers.current().addr = a.getStringValue();
                continue;
            }
            a = commandLine.nextString(new String[]{"-p", "--port"});
            if (a != null) {
                servers.current().port = a.getArgumentValue().getInt();
                continue;
            }
            a = commandLine.nextString(new String[]{"-h", "--host"});
            if (a != null || (a = commandLine.nextNonOption()) != null) {
                StringBuilder s = new StringBuilder();
                if (a.getStringKey().equals("-h") || a.getStringKey().equals("--host")) {
                    s.append(a.getStringValue());
                } else {
                    s.append(a.getString());
                }
                HostStr u = this.parseHostStr(s.toString(), context, true);
                if (u.protocol.isEmpty()) {
                    u.protocol = "http";
                }
                servers.add().set(u);
                continue;
            }
            a = commandLine.nextString(new String[]{"-l", "--backlog"});
            if (a != null) {
                servers.current().port = a.getArgumentValue().getInt();
                continue;
            }
            a = commandLine.nextString(new String[]{"--ssl-certificate"});
            if (a != null) {
                servers.current().sslCertificate = a.getStringValue();
                continue;
            }
            a = commandLine.nextString(new String[]{"--ssl-passphrase"});
            if (a != null) {
                servers.current().sslPassphrase = a.getStringValue();
                continue;
            }
            a = commandLine.nextString(new String[]{"-w", "--workspace"});
            if (a != null) {
                Object ws = a.getString();
                String serverContext = "";
                if (((String)ws).contains("@")) {
                    serverContext = ((String)ws).substring(0, ((String)ws).indexOf(64));
                    ws = ((String)ws).substring(((String)ws).indexOf(64) + 1);
                }
                if (servers.current().workspaceLocations.containsKey(serverContext)) {
                    throw new NutsIllegalArgumentException(context.getSession(), NutsMessage.cstyle((String)"nuts-server: server workspace context already defined %s", (Object[])new Object[]{serverContext}));
                }
                servers.current().workspaceLocations.put(serverContext, (String)ws);
                continue;
            }
            context.configureLast(commandLine);
        }
        if (commandLine.isExecMode()) {
            if (servers.all.isEmpty()) {
                servers.add().set(new HostStr("http", "0.0.0.0", -1));
            }
            for (SrvInfo server : servers.all) {
                for (Map.Entry<String, String> entry : server.workspaceLocations.entrySet()) {
                    NutsWorkspace nutsWorkspace = null;
                    String wsContext = entry.getKey();
                    String wsLocation = entry.getValue();
                    if (_StringUtils.isBlank(wsContext) || wsContext.equals(".")) {
                        wsContext = "";
                    }
                    if (_StringUtils.isBlank(wsContext)) {
                        if (context.getWorkspace() == null) {
                            throw new NutsIllegalArgumentException(context.getSession(), NutsMessage.cstyle((String)"nuts-server: missing workspace", (Object[])new Object[0]));
                        }
                        nutsWorkspace = context.getWorkspace();
                        server.workspaces.put(wsContext, nutsWorkspace);
                        continue;
                    }
                    nutsWorkspace = server.workspaces.get(wsContext);
                    if (nutsWorkspace != null) continue;
                    nutsWorkspace = Nuts.openWorkspace((NutsWorkspaceOptions)Nuts.createOptionsBuilder().setWorkspace(wsLocation).setOpenMode(NutsOpenMode.OPEN_OR_ERROR).setReadOnly(Boolean.valueOf(server.readOnly)).build()).getWorkspace();
                    server.workspaces.put(wsContext, nutsWorkspace);
                }
            }
            HashSet<String> visitedNames = new HashSet<String>();
            for (SrvInfo server : servers.all) {
                ServerConfig config0 = null;
                switch (server.serverType) {
                    case "http": 
                    case "https": {
                        ServerConfig config = new NutsHttpServerConfig();
                        try {
                            ((NutsHttpServerConfig)config).setAddress(server.addr == null ? null : InetAddress.getByName(server.addr));
                        }
                        catch (UnknownHostException e) {
                            throw new UncheckedIOException(e);
                        }
                        server.name = this.validateName(server.name, "https".equals(server.serverType) ? "nuts-https-server" : "nuts-http-server", visitedNames);
                        ((NutsHttpServerConfig)config).setServerId(server.name);
                        ((NutsHttpServerConfig)config).setPort(server.port);
                        ((NutsHttpServerConfig)config).setBacklog(server.backlog);
                        ((NutsHttpServerConfig)config).getWorkspaces().putAll(server.workspaces);
                        if ("https".equals(server.serverType)) {
                            ((NutsHttpServerConfig)config).setTls(true);
                            if (server.sslCertificate == null) {
                                throw new NutsIllegalArgumentException(context.getSession(), NutsMessage.cstyle((String)"nuts-server: missing SSL certificate", (Object[])new Object[0]));
                            }
                            try {
                                ((NutsHttpServerConfig)config).setSslKeystoreCertificate(_IOUtils.loadByteArray(new File(server.sslCertificate)));
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException(e);
                            }
                            if (server.sslPassphrase == null) {
                                throw new NutsIllegalArgumentException(context.getSession(), NutsMessage.cstyle((String)"nuts-server: missing SSL passphrase", (Object[])new Object[0]));
                            }
                            ((NutsHttpServerConfig)config).setSslKeystorePassphrase(server.sslPassphrase.toCharArray());
                        }
                        config0 = config;
                        break;
                    }
                    case "admin": {
                        ServerConfig config = new AdminServerConfig();
                        try {
                            ((AdminServerConfig)config).setAddress(server.addr == null ? null : InetAddress.getByName(server.addr));
                        }
                        catch (UnknownHostException e) {
                            throw new UncheckedIOException(e);
                        }
                        server.name = this.validateName(server.name, "nuts-admin-server", visitedNames);
                        ((AdminServerConfig)config).setServerId(server.name);
                        ((AdminServerConfig)config).setPort(server.port);
                        ((AdminServerConfig)config).setBacklog(server.backlog);
                        config0 = config;
                        break;
                    }
                    default: {
                        throw new NutsIllegalArgumentException(context.getSession(), NutsMessage.cstyle((String)"nuts-server: unsupported server type %s", (Object[])new Object[]{server.serverType}));
                    }
                }
                serverManager.startServer(config0);
            }
        }
        this.waitAllServers();
    }

    private HostStr parseHostStr(String host, NutsApplicationContext context, boolean srv) {
        try {
            Matcher pattern = HOST_PATTERN.matcher(host);
            HostStr v = new HostStr();
            v.protocol = "";
            v.addr = srv ? "0.0.0.0" : "localhost";
            v.port = -1;
            if (pattern.find()) {
                if (pattern.group("protocol") != null) {
                    v.protocol = pattern.group("protocol");
                }
                v.addr = pattern.group("host");
                if (pattern.group("port") != null) {
                    v.port = Integer.parseInt(pattern.group("port"));
                }
            } else {
                throw new NutsIllegalArgumentException(context.getSession(), NutsMessage.cstyle((String)"invalid Host : %s", (Object[])new Object[]{v.protocol}));
            }
            return v;
        }
        catch (Exception ex) {
            throw new NutsIllegalArgumentException(context.getSession(), NutsMessage.cstyle((String)"invalid", (Object[])new Object[0]));
        }
    }

    private void status(NutsApplicationContext context, NutsCommandLine commandLine) {
        DefaultNutsWorkspaceServerManager serverManager = new DefaultNutsWorkspaceServerManager(context.getSession());
        NutsCommandLineManager commandLineFormat = context.getWorkspace().commandLine();
        SrvInfoList servers = new SrvInfoList(context.getSession());
        while (commandLine.hasNext()) {
            if (commandLine.next(new String[]{"--http"}) != null) {
                servers.add().serverType = "http";
                continue;
            }
            if (commandLine.next(new String[]{"--https"}) != null) {
                servers.add().serverType = "https";
                continue;
            }
            if (commandLine.next(new String[]{"--admin"}) != null) {
                servers.add().serverType = "admin";
                continue;
            }
            NutsArgument a = commandLine.nextString(new String[]{"-a", "--address"});
            if (a != null) {
                servers.current().addr = a.getStringValue();
                continue;
            }
            a = commandLine.nextString(new String[]{"-p", "--port"});
            if (a != null) {
                servers.current().port = a.getArgumentValue().getInt();
                continue;
            }
            a = commandLine.nextString(new String[]{"-h", "--host"});
            if (a != null || (a = commandLine.nextNonOption()) != null) {
                StringBuilder s = new StringBuilder();
                if (a.getStringKey().equals("-h") || a.getStringKey().equals("--host")) {
                    s.append(a.getStringValue());
                } else {
                    s.append(a.getString());
                }
                HostStr u = this.parseHostStr(s.toString(), context, false);
                servers.add().set(u);
                continue;
            }
            context.configureLast(commandLine);
        }
        if (commandLine.isExecMode()) {
            if (servers.all.isEmpty()) {
                servers.add().set(new HostStr("http", "localhost", 8899));
                servers.add().set(new HostStr("https", "localhost", 8899));
                servers.add().set(new HostStr("admin", "localhost", 8898));
            }
            ArrayList<StatusResult> results = new ArrayList<StatusResult>();
            for (SrvInfo server : servers.all) {
                String addr2;
                String aliveType = null;
                String url = null;
                if (server.serverType.isEmpty() || server.serverType.equals("http")) {
                    try {
                        addr2 = server.addr != null ? server.addr : "localhost";
                        url = "http://" + addr2 + (server.port > 0 ? ":" + server.port : ":8899");
                        new URL(url + "/archetype-catalog.xml").openStream();
                        aliveType = "maven";
                    }
                    catch (Exception addr2) {
                        // empty catch block
                    }
                }
                if (aliveType == null && (server.serverType.isEmpty() || server.serverType.equals("https"))) {
                    addr2 = server.addr != null ? server.addr : "localhost";
                    url = "https://" + addr2 + (server.port > 0 ? ":" + server.port : ":8899");
                    try {
                        new URL(url + "/.files").openStream();
                        aliveType = "nuts";
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (aliveType == null && (server.serverType.isEmpty() || server.serverType.equals("admin"))) {
                    url = "admin://" + server.addr + (server.port > 0 ? ":" + server.port : ":8898");
                    try (Socket s = new Socket(InetAddress.getByName(server.addr), server.port > 0 ? server.port : 8898);){
                        InputStreamReader in = new InputStreamReader(s.getInputStream());
                        if (this.readString("Nuts Admin Service", in)) {
                            aliveType = "admin";
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (aliveType != null) {
                    results.add(new StatusResult(url, aliveType, "alive"));
                    continue;
                }
                url = (server.serverType.isEmpty() ? "?" : server.serverType) + "://" + server.addr + (server.port > 0 ? ":" + server.port : "");
                results.add(new StatusResult(url, server.serverType.isEmpty() ? "?" : server.serverType, "stopped"));
            }
            if (context.getSession().isPlainOut()) {
                NutsTextManager text = context.getWorkspace().text();
                for (StatusResult result : results) {
                    context.getSession().out().printf("%s server at %s is %s%n", new Object[]{text.forStyled(result.type, NutsTextStyle.primary4()), result.host, result.status.equals("stopped") ? text.forStyled("stopped", NutsTextStyle.error()) : text.forStyled("alive", NutsTextStyle.success())});
                }
            } else {
                context.getSession().getWorkspace().formats().object(results).println();
            }
        }
    }

    public boolean readString(String toRead, Reader reader) throws IOException {
        for (char c : toRead.toCharArray()) {
            int y = reader.read();
            if (y == c) continue;
            return false;
        }
        return true;
    }

    public void stopWaiting() {
        if (this.lock.getCount() > 0L) {
            this.lock.countDown();
        }
    }

    private void waitAllServers() {
        try {
            this.lock.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private String validateName(String name, String defaultName, Set<String> visited) {
        if (name == null) {
            name = "";
        }
        if ((name = name.trim()).isEmpty()) {
            name = defaultName;
        }
        int x = 1;
        while (true) {
            String n;
            if (!visited.contains(n = name + (x == 1 ? "" : "-" + x))) {
                visited.add(n);
                return n;
            }
            ++x;
        }
    }

    static class SrvInfo {
        String name = null;
        String serverType = "http";
        String addr = null;
        int port = -1;
        int backlog = -1;
        String sslCertificate = null;
        String sslPassphrase = null;
        Map<String, String> workspaceLocations = new LinkedHashMap<String, String>();
        Map<String, NutsWorkspace> workspaces = new HashMap<String, NutsWorkspace>();
        boolean readOnly = false;

        SrvInfo() {
        }

        public void set(HostStr s) {
            if (s != null) {
                this.serverType = s.protocol;
                this.addr = s.addr;
                this.port = s.port;
            }
        }
    }

    static class SrvInfoList {
        List<SrvInfo> all = new ArrayList<SrvInfo>();
        NutsSession session;

        SrvInfoList(NutsSession ws) {
            this.session = ws;
        }

        SrvInfo add() {
            SrvInfo s = new SrvInfo();
            this.all.add(s);
            return s;
        }

        SrvInfo current() {
            if (this.all.isEmpty()) {
                throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"nuts-server: server type missing", (Object[])new Object[0]));
            }
            return this.all.get(this.all.size() - 1);
        }
    }

    private static class StatusResult {
        String host;
        String type;
        String status;

        public StatusResult(String host, String type, String status) {
            this.host = host;
            this.status = status;
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public String getHost() {
            return this.host;
        }

        public String getStatus() {
            return this.status;
        }
    }

    private class HostStr {
        String protocol = "http";
        String addr = null;
        int port = -1;

        public HostStr() {
        }

        public HostStr(String protocol, String addr, int port) {
            this.protocol = protocol;
            this.addr = addr;
            this.port = port;
        }
    }
}

