/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.noapi;

import net.thevpc.nuts.NutsAppCmdProcessor;
import net.thevpc.nuts.NutsApplication;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.toolbox.noapi.NOpenAPIService;

public class NoapiMain
implements NutsApplication,
NutsAppCmdProcessor {
    private NOpenAPIService service;
    String command;
    String path;
    String target;
    boolean openAPI;
    boolean keep;
    String openAPIFormat;

    public static void main(String[] args) {
        new NoapiMain().runAndExit(args);
    }

    public void run(NutsApplicationContext appContext) {
        String[] args = appContext.getArguments();
        this.service = new NOpenAPIService(appContext);
        NutsCommandLine cmdLine = appContext.getCommandLine();
        appContext.processCommandLine((NutsAppCmdProcessor)this);
    }

    public boolean onCmdNextOption(NutsArgument option, NutsCommandLine commandline, NutsApplicationContext context) {
        switch (option.getString()) {
            case "--yaml": {
                commandline.nextBoolean(new String[0]);
                this.openAPIFormat = "yaml";
                return true;
            }
            case "--keep": {
                commandline.nextBoolean(new String[0]);
                this.keep = true;
                return true;
            }
            case "--json": {
                commandline.nextBoolean(new String[0]);
                this.openAPIFormat = "json";
                return true;
            }
            case "--open-api": {
                commandline.nextBoolean(new String[0]);
                this.openAPI = true;
                return true;
            }
            case "--pdf": {
                commandline.nextBoolean(new String[0]);
                this.command = "pdf";
                return true;
            }
        }
        return false;
    }

    public boolean onCmdNextNonOption(NutsArgument nonOption, NutsCommandLine commandline, NutsApplicationContext context) {
        if (this.path == null) {
            this.path = commandline.nextString(new String[0]).getKey().getString();
            return true;
        }
        if (this.target == null) {
            this.target = commandline.nextString(new String[0]).getKey().getString();
            return true;
        }
        return false;
    }

    public void onCmdFinishParsing(NutsCommandLine commandline, NutsApplicationContext context) {
        if (this.path == null) {
            commandline.required(NutsMessage.cstyle((String)"missing path", (Object[])new Object[0]));
        }
        if (this.command == null) {
            this.command = "pdf";
        }
    }

    public void onCmdExec(NutsCommandLine commandline, NutsApplicationContext context) {
        switch (this.command) {
            case "pdf": {
                NOpenAPIService service = new NOpenAPIService(context);
                service.run(this.path, this.target, this.keep);
            }
        }
    }
}

