/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.noapi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsArrayElement;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementEntry;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsObjectElement;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsTmp;
import net.thevpc.nuts.lib.md.MdColumn;
import net.thevpc.nuts.lib.md.MdDocument;
import net.thevpc.nuts.lib.md.MdDocumentBuilder;
import net.thevpc.nuts.lib.md.MdElement;
import net.thevpc.nuts.lib.md.MdFactory;
import net.thevpc.nuts.lib.md.MdHorizontalAlign;
import net.thevpc.nuts.lib.md.MdRow;
import net.thevpc.nuts.lib.md.MdTable;
import net.thevpc.nuts.lib.md.MdTableBuilder;
import net.thevpc.nuts.lib.md.asciidoctor.AsciiDoctorWriter;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;

public class NOpenAPIService {
    private NutsApplicationContext appContext;

    public NOpenAPIService(NutsApplicationContext appContext) {
        this.appContext = appContext;
    }

    public void run(String source, String target, boolean keep) {
        String targetType = "pdf";
        if (target == null) {
            target = this.addExtension(source, "pdf").toString();
            targetType = "pdf";
        } else if (target.equals(".pdf")) {
            target = this.addExtension(source, "pdf").toString();
            targetType = "pdf";
        } else if (target.equals(".adoc")) {
            target = this.addExtension(source, "adoc").toString();
            targetType = "adoc";
        }
        MdDocument md = this.toMarkdown(source);
        NutsSession session = this.appContext.getSession();
        if (targetType.equals("adoc")) {
            this.writeAdoc(md, target, session.isPlainTrace());
        } else if (targetType.equals("pdf")) {
            String temp = null;
            temp = keep ? this.addExtension(source, "adoc").toString() : NutsTmp.of((NutsSession)session).createTempFile("temp.adoc").toString();
            this.writeAdoc(md, temp, keep && session.isPlainTrace());
            if (new File(target).getParentFile() != null) {
                new File(target).getParentFile().mkdirs();
            }
            Asciidoctor asciidoctor = Asciidoctor.Factory.create();
            String outfile = asciidoctor.convertFile(new File(temp), OptionsBuilder.options().backend("pdf").safe(SafeMode.UNSAFE).toFile(new File(target)));
            if (session.isPlainTrace()) {
                session.out().printf("generated pdf %s\n", new Object[]{NutsTexts.of((NutsSession)session).ofStyled(target, NutsTextStyle.primary4())});
            }
            if (!keep) {
                new File(temp).delete();
            }
        } else {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unsupported", (Object[])new Object[0]));
        }
    }

    private void writeAdoc(MdDocument md, String target, boolean trace) {
        try (AsciiDoctorWriter mw = new AsciiDoctorWriter((Writer)new FileWriter(target));){
            mw.write(md);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        if (trace) {
            this.appContext.getSession().out().printf("generated src %s\n", new Object[]{NutsTexts.of((NutsSession)this.appContext.getSession()).ofStyled(target, NutsTextStyle.primary4())});
        }
    }

    private Path addExtension(String source, String ext) {
        Path path = Paths.get(source, new String[0]);
        String n = path.getFileName().toString();
        n = n.endsWith(".json") ? n.substring(0, n.length() - ".json".length()) + "." + ext : (n.endsWith(".yml") ? n.substring(0, n.length() - ".yml".length()) + "." + ext : (n.endsWith(".yaml") ? n.substring(0, n.length() - ".yaml".length()) + "." + ext : n + "." + ext));
        return path.getParent().resolve(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MdDocument toMarkdown(String source) {
        Throwable throwable;
        boolean json = false;
        try {
            throwable = null;
            try (BufferedReader r = Files.newBufferedReader(Paths.get(source, new String[0]));){
                String t;
                while ((t = r.readLine()) != null) {
                    if ((t = t.trim()).length() <= 0) continue;
                    if (t.startsWith("{")) {
                        json = true;
                    }
                    break;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        try {
            throwable = null;
            try (InputStream inputStream = Files.newInputStream(Paths.get(source, new String[0]), new OpenOption[0]);){
                MdDocument mdDocument = this.toMarkdown(inputStream, json);
                return mdDocument;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private NutsElement loadElement(InputStream inputStream, boolean json) {
        NutsSession session = this.appContext.getSession();
        if (json) {
            return (NutsElement)NutsElements.of((NutsSession)session).json().parse(inputStream, NutsElement.class);
        }
        return (NutsElement)NutsElements.of((NutsSession)session).json().parse(inputStream, NutsElement.class);
    }

    private MdDocument toMarkdown(InputStream inputStream, boolean json) {
        NutsSession session = this.appContext.getSession();
        NutsElements prv = NutsElements.of((NutsSession)session);
        MdDocumentBuilder doc = new MdDocumentBuilder();
        doc.setProperty("headers", (Object)new String[]{":source-highlighter: coderay", ":icons: font", ":icon-set: pf", ":doctype: book", ":toc:", ":toclevels: 3", ":appendix-caption: Appx", ":sectnums:", ":chapter-label:"});
        doc.setDate((Temporal)LocalDate.now());
        doc.setSubTitle("RESTRICTED - INTERNAL");
        NutsElement obj = this.loadElement(inputStream, json);
        ArrayList<Object> all = new ArrayList<Object>();
        NutsObjectElement entries = obj.asObject();
        String documentTitle = entries.getObject("info").getString("title");
        doc.setTitle(documentTitle);
        String documentVersion = entries.getObject("info").getString("version");
        doc.setVersion(documentVersion);
        all.add(MdFactory.title((int)1, (String)documentTitle));
        all.add(MdFactory.seq((MdElement[])new MdElement[]{MdFactory.text((String)"API Reference")}));
        all.add(MdFactory.title((int)2, (String)"INTRODUCTION"));
        all.add(MdFactory.text((String)entries.getObject("info").getString("description").trim()));
        all.add(MdFactory.title((int)3, (String)"CONTACT"));
        all.add(MdFactory.table().addColumns(new MdTableBuilder.MdColumnBuilder[]{MdFactory.column().setName("NAME"), MdFactory.column().setName("EMAIL"), MdFactory.column().setName("URL")}).addRows(new MdTableBuilder.MdRowBuilder[]{MdFactory.row().addCells(new MdElement[]{MdFactory.text((String)entries.getObject("info").getObject("contact").getString("name")), MdFactory.text((String)entries.getObject("info").getObject("contact").getString("email")), MdFactory.text((String)entries.getObject("info").getObject("contact").getString("url"))})}).build());
        all.add(MdFactory.title((int)3, (String)"SERVER LIST"));
        for (Object srv : entries.getArray((NutsElement)prv.ofString("servers"))) {
            NutsObjectElement srvObj = srv.asObject();
            all.add(MdFactory.title((int)4, (String)srvObj.getString("url")));
            all.add(MdFactory.text((String)srvObj.getString("description")));
            NutsElement vars = srvObj.get((NutsElement)prv.ofString("variables"));
            if (vars == null || vars.isEmpty()) continue;
            MdTableBuilder mdTableBuilder = MdFactory.table().addColumns(new MdTableBuilder.MdColumnBuilder[]{MdFactory.column().setName("NAME"), MdFactory.column().setName("SPEC"), MdFactory.column().setName("DESCRIPTION")});
            for (NutsElementEntry variables : vars.asObject()) {
                mdTableBuilder.addRows(new MdTableBuilder.MdRowBuilder[]{MdFactory.row().addCells(new MdElement[]{MdFactory.text((String)variables.getKey().asString()), MdFactory.text((String)variables.getValue().asObject().getString("default")), MdFactory.text((String)variables.getValue().asObject().getString("description"))})});
            }
            all.add(mdTableBuilder.build());
        }
        if (!entries.getObject("components").getObject("headers").isEmpty()) {
            all.add(MdFactory.title((int)3, (String)"HEADERS"));
            all.add(MdFactory.text((String)"This section includes common Headers to be included in the incoming requests."));
            MdTableBuilder table = MdFactory.table().addColumns(new MdTableBuilder.MdColumnBuilder[]{MdFactory.column().setName("NAME"), MdFactory.column().setName("TYPE"), MdFactory.column().setName("REQUIRED"), MdFactory.column().setName("DESCRIPTION")});
            for (NutsElementEntry ee : entries.getObject("components").getObject("headers")) {
                table.addRows(new MdTableBuilder.MdRowBuilder[]{MdFactory.row().addCells(new MdElement[]{MdFactory.codeBacktick3((String)"", (String)(ee.getKey() + (ee.getValue().asObject().getBoolean("deprecated") ? " (DEPRECATED)" : ""))), MdFactory.codeBacktick3((String)"", (String)ee.getValue().asObject().getObject("schema").getString("type")), MdFactory.text((String)(ee.getValue().asObject().getBoolean("required") ? "required" : "")), MdFactory.text((String)ee.getValue().asObject().getString("description"))})});
            }
            all.add(table.build());
        }
        if (!entries.getObject("components").getObject("securitySchemes").isEmpty()) {
            all.add(MdFactory.title((int)3, (String)"SECURITY AND AUTHENTICATION"));
            all.add(MdFactory.text((String)"This section includes security configurations."));
            block15: for (NutsElementEntry ee : entries.getObject("components").getObject("securitySchemes")) {
                String type = ee.getValue().asObject().getString("type");
                switch (type) {
                    case "apiKey": {
                        all.add(MdFactory.title((int)4, (String)(ee.getKey() + " (Api Key)")));
                        all.add(MdFactory.text((String)ee.getValue().asObject().getString("description")));
                        all.add(MdFactory.table().addColumns(new MdTableBuilder.MdColumnBuilder[]{MdFactory.column().setName("NAME"), MdFactory.column().setName("IN")}).addRows(new MdTableBuilder.MdRowBuilder[]{MdFactory.row().addCells(new MdElement[]{MdFactory.codeBacktick3((String)"", (String)ee.getValue().asObject().getString("name")), MdFactory.codeBacktick3((String)"", (String)ee.getValue().asObject().getString("in").toUpperCase())})}).build());
                        continue block15;
                    }
                    case "http": {
                        all.add(MdFactory.title((int)4, (String)(ee.getKey() + " (Http)")));
                        all.add(MdFactory.text((String)ee.getValue().asObject().getString("description")));
                        all.add(MdFactory.table().addColumns(new MdTableBuilder.MdColumnBuilder[]{MdFactory.column().setName("SCHEME"), MdFactory.column().setName("BEARER")}).addRows(new MdTableBuilder.MdRowBuilder[]{MdFactory.row().addCells(new MdElement[]{MdFactory.text((String)ee.getValue().asObject().getString("scheme")), MdFactory.text((String)ee.getValue().asObject().getString("bearerFormat"))})}).build());
                        continue block15;
                    }
                    case "oauth2": {
                        all.add(MdFactory.title((int)4, (String)(ee.getKey() + " (Oauth2)")));
                        all.add(MdFactory.text((String)ee.getValue().asObject().getString("description")));
                        continue block15;
                    }
                    case "openIdConnect": {
                        all.add(MdFactory.title((int)4, (String)(ee.getKey() + " (OpenId Connect)")));
                        all.add(MdFactory.text((String)ee.getValue().asObject().getString("description")));
                        all.add(MdFactory.table().addColumns(new MdTableBuilder.MdColumnBuilder[]{MdFactory.column().setName("URL")}).addRows(new MdTableBuilder.MdRowBuilder[]{MdFactory.row().addCells(new MdElement[]{MdFactory.text((String)ee.getValue().asObject().getString("openIdConnectUrl"))})}).build());
                        continue block15;
                    }
                }
                all.add(MdFactory.title((int)4, (String)(ee.getKey() + " (" + type + ")")));
                all.add(MdFactory.text((String)ee.getValue().asObject().getString("description")));
            }
        }
        all.add(MdFactory.title((int)2, (String)"API"));
        for (NutsElementEntry path : entries.get((NutsElement)prv.ofString("paths")).asObject()) {
            String url = path.getKey().asString();
            for (NutsElementEntry ss : path.getValue().asObject()) {
                NutsObjectElement requestBody;
                MdTable tab;
                String method = ss.getKey().asString();
                NutsObjectElement call = ss.getValue().asObject();
                all.add(MdFactory.title((int)3, (String)(method.toUpperCase() + " " + url)));
                all.add(MdFactory.text((String)call.getString("summary")));
                all.add(MdFactory.codeBacktick3((String)"", (String)("[" + method.toUpperCase() + "] " + url)));
                all.add(MdFactory.text((String)call.getString("description")));
                all.add(MdFactory.title((int)4, (String)"REQUEST"));
                List headerParameters = call.getArray((NutsElement)prv.ofString("parameters")).stream().filter(x -> x.asObject().getString("in").equals("header")).collect(Collectors.toList());
                List queryParameters = call.getArray((NutsElement)prv.ofString("parameters")).stream().filter(x -> x.asObject().getString("in").equals("query")).collect(Collectors.toList());
                if (!headerParameters.isEmpty()) {
                    all.add(MdFactory.title((int)5, (String)"HEADER PARAMETERS"));
                    tab = new MdTable(new MdColumn[]{new MdColumn(MdFactory.text((String)"NAME"), MdHorizontalAlign.LEFT), new MdColumn(MdFactory.text((String)"TYPE"), MdHorizontalAlign.LEFT), new MdColumn(MdFactory.text((String)"REQUIRED"), MdHorizontalAlign.LEFT), new MdColumn(MdFactory.text((String)"DESCRIPTION"), MdHorizontalAlign.LEFT)}, (MdRow[])headerParameters.stream().map(headerParameter -> new MdRow(new MdElement[]{MdFactory.codeBacktick3((String)"", (String)headerParameter.asObject().getString("name")), MdFactory.codeBacktick3((String)"", (String)headerParameter.asObject().getString("type")), MdFactory.text((String)(headerParameter.asObject().getBoolean("required") ? "required" : "")), MdFactory.text((String)headerParameter.asObject().getString("description"))}, false)).toArray(MdRow[]::new));
                    all.add(tab);
                }
                if (!queryParameters.isEmpty()) {
                    all.add(MdFactory.title((int)5, (String)"QUERY PARAMETERS"));
                    tab = new MdTable(new MdColumn[]{new MdColumn(MdFactory.text((String)"NAME"), MdHorizontalAlign.LEFT), new MdColumn(MdFactory.text((String)"TYPE"), MdHorizontalAlign.LEFT), new MdColumn(MdFactory.text((String)"REQUIRED"), MdHorizontalAlign.LEFT), new MdColumn(MdFactory.text((String)"DESCRIPTION"), MdHorizontalAlign.LEFT)}, (MdRow[])queryParameters.stream().map(headerParameter -> new MdRow(new MdElement[]{MdFactory.codeBacktick3((String)"", (String)headerParameter.asObject().getString("name")), MdFactory.codeBacktick3((String)"", (String)headerParameter.asObject().getString("type")), MdFactory.text((String)(headerParameter.asObject().getBoolean("required") ? "required" : "")), MdFactory.text((String)headerParameter.asObject().getString("description"))}, false)).toArray(MdRow[]::new));
                    all.add(tab);
                }
                if ((requestBody = call.getObject("requestBody")) != null && !requestBody.isEmpty()) {
                    boolean required = requestBody.getBoolean("required");
                    String desc = requestBody.getString("description");
                    NutsObjectElement r = requestBody.getObject("content");
                    for (NutsElementEntry ii : r) {
                        all.add(MdFactory.title((int)5, (String)("REQUEST BODY - " + ii.getKey() + (required ? " [required]" : ""))));
                        all.add(MdFactory.text((String)desc));
                        all.add(MdFactory.codeBacktick3((String)"javascript", (String)this.toCode(ii.getValue(), "")));
                    }
                }
                all.add(MdFactory.title((int)4, (String)"RESPONSE"));
                call.getObject("responses").stream().forEach(x -> {
                    NutsElement s = x.getKey();
                    NutsElement v = x.getValue();
                    all.add(MdFactory.title((int)5, (String)("STATUS CODE - " + s)));
                    all.add(MdFactory.text((String)v.asObject().getString("description")));
                    for (NutsElementEntry content : v.asObject().getObject("content")) {
                        all.add(MdFactory.title((int)6, (String)("RESPONSE MODEL - " + content.getKey())));
                        all.add(MdFactory.codeBacktick3((String)"javascript", (String)this.toCode(content.getValue(), "")));
                    }
                });
            }
        }
        doc.setContent(MdFactory.seq(all));
        return doc.build();
    }

    private String toCode(NutsElement o, String indent) {
        NutsSession session = this.appContext.getSession();
        NutsElements prv = NutsElements.of((NutsSession)session);
        String descSep = " // ";
        if (o.isObject()) {
            NutsElement a = o.asObject().get((NutsElement)prv.ofString("schema"));
            if (a != null && a.isObject()) {
                NutsObjectElement schema = o.asObject().getObject("schema");
                String t = schema.getString("type");
                if (t.equals("object")) {
                    StringBuilder sb = new StringBuilder("{");
                    for (NutsElementEntry p : schema.getObject("properties")) {
                        sb.append("\n" + indent + "  " + p.getKey() + ": " + this.toCode(p.getValue(), indent + "  "));
                    }
                    sb.append("\n" + indent + "}");
                    NutsElement desc = o.asObject().get((NutsElement)prv.ofString("description"));
                    if (desc != null && !desc.asString().isEmpty()) {
                        return sb + descSep + desc.asString();
                    }
                    return sb.toString();
                }
            } else if (o.asObject().get((NutsElement)prv.ofString("type")).isString()) {
                String t = o.asObject().get((NutsElement)prv.ofString("type")).asString();
                if (t.equals("object")) {
                    StringBuilder sb = new StringBuilder("{");
                    for (NutsElementEntry p : o.asObject().getObject("properties")) {
                        sb.append("\n" + indent + "  " + p.getKey() + ": " + this.toCode(p.getValue(), indent + "  "));
                    }
                    sb.append("\n" + indent + "}");
                    NutsElement desc = o.asObject().get((NutsElement)prv.ofString("description"));
                    if (desc != null && !desc.asString().isEmpty()) {
                        return sb + descSep + desc.asString();
                    }
                    return sb.toString();
                }
                NutsElement anEnum = o.asObject().get((NutsElement)prv.ofString("enum"));
                if (t.equals("boolean")) {
                    NutsArrayElement en;
                    NutsElement ee = o.asObject().get((NutsElement)prv.ofString("example"));
                    if (ee != null && !ee.isNull()) {
                        if (ee.isString()) {
                            return ee.asString();
                        }
                        return ee.asString();
                    }
                    NutsElement desc = o.asObject().get((NutsElement)prv.ofString("description"));
                    NutsArrayElement nutsArrayElement = en = anEnum == null ? null : anEnum.asArray();
                    if (en != null && en.isEmpty()) {
                        String r = "boolean ALLOWED:" + en.stream().map(x -> x.isNull() ? "null" : x.asString()).collect(Collectors.joining(", "));
                        if (!desc.asString().isEmpty()) {
                            return r + descSep + desc.asString();
                        }
                        return r;
                    }
                    if (desc != null && !desc.asString().isEmpty()) {
                        return "boolean" + descSep + desc.asString();
                    }
                    return "boolean";
                }
                if (t.equals("string")) {
                    NutsArrayElement en;
                    NutsElement ee = o.asObject().get((NutsElement)prv.ofString("example"));
                    if (ee != null && !ee.isNull()) {
                        if (ee.isString()) {
                            return "'" + ee.asString() + "'";
                        }
                        return "'" + ee.asString() + "'";
                    }
                    NutsElement desc = o.asObject().get((NutsElement)prv.ofString("description"));
                    NutsArrayElement nutsArrayElement = en = anEnum == null ? null : anEnum.asArray();
                    if (en != null && !en.isEmpty()) {
                        String r = "string ALLOWED:" + en.stream().map(x -> x.isNull() ? "null" : x.asString()).collect(Collectors.joining(", "));
                        if (desc != null && !desc.asString().isEmpty()) {
                            return r + descSep + desc.asString();
                        }
                        return r;
                    }
                    if (desc != null && !desc.asString().isEmpty()) {
                        return "string" + descSep + desc.asString();
                    }
                    return "string";
                }
                if (t.equals("integer")) {
                    NutsArrayElement en;
                    NutsElement desc = o.asObject().get((NutsElement)prv.ofString("description"));
                    NutsArrayElement nutsArrayElement = en = anEnum == null ? null : anEnum.asArray();
                    if (en != null && !en.isEmpty()) {
                        String r = "integer ALLOWED:" + en.stream().map(x -> x.isNull() ? "null" : x.asString()).collect(Collectors.joining(", "));
                        if (!desc.asString().isEmpty()) {
                            return r + descSep + desc.asString();
                        }
                        return r;
                    }
                    if (desc != null && !desc.asString().isEmpty()) {
                        return "integer" + descSep + desc.asString();
                    }
                    return "integer";
                }
            } else if (o.asObject().get((NutsElement)prv.ofString("type")) == null || o.asObject().get((NutsElement)prv.ofString("type")).isNull()) {
                NutsElement desc = o.asObject().get((NutsElement)prv.ofString("description"));
                if (desc != null && !desc.asString().isEmpty()) {
                    return "null\n" + desc.asString();
                }
                return "null";
            }
        }
        return "";
    }
}

