/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.noapi;

import net.thevpc.nuts.NutsApplication;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCommandLineProcessor;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.toolbox.noapi.NOpenAPIService;

public class NoapiMain
implements NutsApplication {
    private NOpenAPIService service;

    public static void main(String[] args) {
        new NoapiMain().runAndExit(args);
    }

    public void run(final NutsApplicationContext appContext) {
        String[] args = appContext.getArguments();
        this.service = new NOpenAPIService(appContext);
        NutsCommandLine cmdLine = appContext.getCommandLine();
        appContext.processCommandLine(new NutsCommandLineProcessor(){
            String command;
            String path;
            String target;
            boolean openAPI;
            boolean keep;
            String openAPIFormat;

            public boolean onNextOption(NutsArgument option, NutsCommandLine commandline) {
                switch (option.getString()) {
                    case "--yaml": {
                        commandline.nextBoolean(new String[0]);
                        this.openAPIFormat = "yaml";
                        return true;
                    }
                    case "--keep": {
                        commandline.nextBoolean(new String[0]);
                        this.keep = true;
                        return true;
                    }
                    case "--json": {
                        commandline.nextBoolean(new String[0]);
                        this.openAPIFormat = "json";
                        return true;
                    }
                    case "--open-api": {
                        commandline.nextBoolean(new String[0]);
                        this.openAPI = true;
                        return true;
                    }
                    case "--pdf": {
                        commandline.nextBoolean(new String[0]);
                        this.command = "pdf";
                        return true;
                    }
                }
                return false;
            }

            public boolean onNextNonOption(NutsArgument nonOption, NutsCommandLine commandline) {
                if (this.path == null) {
                    this.path = commandline.nextString(new String[0]).getStringKey();
                    return true;
                }
                if (this.target == null) {
                    this.target = commandline.nextString(new String[0]).getStringKey();
                    return true;
                }
                return false;
            }

            public void onPrepare(NutsCommandLine commandline) {
                if (this.path == null) {
                    commandline.required(NutsMessage.cstyle((String)"missing path", (Object[])new Object[0]));
                }
                if (this.command == null) {
                    this.command = "pdf";
                }
            }

            public void onExec() {
                switch (this.command) {
                    case "pdf": {
                        NOpenAPIService service = new NOpenAPIService(appContext);
                        service.run(this.path, this.target, this.keep);
                    }
                }
            }
        });
    }
}

