/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.mvn;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.thevpc.nuts.NutsApplication;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.toolbox.mvn.MavenCli2;

public class NutsMvnMain
implements NutsApplication {
    private static final Logger LOG = Logger.getLogger(NutsMvnMain.class.getName());

    public static void main(String[] args) {
        new NutsMvnMain().runAndExit(args);
    }

    public void run(NutsApplicationContext appContext) {
        String command = null;
        ArrayList<String> args2 = new ArrayList<String>();
        Options o = new Options();
        NutsCommandLine cmd = appContext.getCommandLine();
        while (cmd.hasNext()) {
            if (command == null) {
                if (appContext.configureFirst(cmd)) continue;
                NutsArgument a = cmd.nextBoolean(new String[]{"-j", "--json"});
                if (a != null) {
                    o.json = a.getBooleanValue();
                    continue;
                }
                a = cmd.next(new String[]{"build"});
                if (a != null) {
                    command = "build";
                    continue;
                }
                a = cmd.next(new String[]{"get"});
                if (a != null) {
                    command = "get";
                    continue;
                }
                command = "default";
                args2.add(cmd.next().getString());
                continue;
            }
            args2.add(cmd.next().getString());
        }
        if (command == null) {
            command = "build";
        }
        if (cmd.isExecMode()) {
            MavenCli2 cli = new MavenCli2(appContext);
            String[] args2Arr = args2.toArray(new String[0]);
            switch (command) {
                case "build": 
                case "default": {
                    ArrayList<String> defaultArgs = new ArrayList<String>();
                    for (String ar : args2Arr) {
                        if (ar.startsWith("-D")) {
                            String[] as = ar.substring(2).split("=");
                            cli.setProperty(as[0], as[1]);
                            continue;
                        }
                        defaultArgs.add(ar);
                    }
                    int r = NutsMvnMain.callMvn(cli, appContext, o, defaultArgs.toArray(new String[0]));
                    if (r == 0) {
                        return;
                    }
                    throw new NutsExecutionException(appContext.getSession(), NutsMessage.cstyle((String)"Maven Call exited with code %d", (Object[])new Object[]{r}), r);
                }
                case "get": {
                    cli.setArtifactId(args2Arr[0]);
                    String repo = null;
                    if (args2Arr.length > 1) {
                        repo = args2Arr[1];
                    }
                    if ("central".equals(repo)) {
                        repo = null;
                    }
                    if ("vpc-public-maven".equals(repo)) {
                        repo = "https://raw.github.com/thevpc/vpc-public-maven/master";
                    }
                    if (repo != null) {
                        cli.setRepoUrl(repo);
                    }
                    Path dir = NutsMvnMain.createTempPom(appContext.getSession());
                    cli.setWorkingDirectory(dir.toString());
                    int r = NutsMvnMain.callMvn(cli, appContext, o, "dependency:get");
                    try {
                        NutsMvnMain.delete(dir);
                    }
                    catch (IOException ex) {
                        throw new IllegalArgumentException(ex);
                    }
                    if (r == 0) {
                        return;
                    }
                    throw new NutsExecutionException(appContext.getSession(), NutsMessage.cstyle((String)"Maven Call exited with code %s", (Object[])new Object[]{r}), r);
                }
            }
        }
    }

    private static int callMvn(MavenCli2 cli, NutsApplicationContext appContext, Options options, String ... args) {
        if (options.json) {
            try {
                cli.setGrabString(true);
                int r = cli.doMain(args);
                String s = cli.getResultString();
                if (s.contains("BUILD SUCCESS")) {
                    appContext.getSession().out().println("{'result':'success'}");
                    return 0;
                }
                if (r == 0) {
                    r = 1;
                }
                appContext.getSession().out().println("{'result':'error'}");
                return r;
            }
            catch (Exception ex) {
                LOG.log(Level.FINE, "error executing mvn command " + Arrays.toString(args), ex);
                appContext.getSession().out().println("{'result':'error'}");
                return 1;
            }
        }
        return cli.doMain(args);
    }

    private static Path createTempPom(NutsSession session) {
        NutsWorkspace ws = session.getWorkspace();
        Path d = Paths.get(ws.io().tmp().setSession(session).createTempFolder(null), new String[0]);
        try (BufferedWriter out = Files.newBufferedWriter(d.resolve("pom.xml"), new OpenOption[0]);){
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n    <modelVersion>4.0.0</modelVersion>\n    <groupId>temp</groupId>\n    <artifactId>temp-nuts</artifactId>\n    <version>1.0.0</version>\n    <packaging>jar</packaging>\n    <properties>\n        <project.build.sourceEncoding>UTF-8</project.build.sourceEncoding>\n        <maven.compiler.source>1.8</maven.compiler.source>\n        <maven.compiler.target>1.8</maven.compiler.target>\n    </properties>\n    <dependencies>\n    </dependencies>\n    <repositories>\n        <repository>\n            <id>vpc-public-maven</id>\n            <url>https://raw.github.com/thevpc/vpc-public-maven/master</url>\n            <snapshots>\n                <enabled>true</enabled>\n                <updatePolicy>always</updatePolicy>\n            </snapshots>\n        </repository>\n    </repositories>\n    <pluginRepositories>\n        <pluginRepository>\n            <id>vpc-public-maven</id>\n            <url>https://raw.github.com/thevpc/vpc-public-maven/master</url>\n            <snapshots>\n                <enabled>true</enabled>\n                <updatePolicy>always</updatePolicy>\n            </snapshots>\n        </pluginRepository>\n    </pluginRepositories>\n</project>\n");
            out.write(System.getProperty("line.separator"));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return d;
    }

    public static int[] delete(Path file) throws IOException {
        final int[] deleted = new int[]{0, 0};
        Files.walkFileTree(file, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                deleted[1] = deleted[1] + 1;
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                deleted[0] = deleted[0] + 1;
                return FileVisitResult.CONTINUE;
            }
        });
        return deleted;
    }

    public static class Options {
        boolean json = false;
    }
}

