/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.njob.time;

import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.thevpc.nuts.toolbox.njob.time.TimePeriod;
import net.thevpc.nuts.toolbox.njob.time.TimespanPattern;

public class TimePeriods {
    private Map<ChronoUnit, Double> values = new HashMap<ChronoUnit, Double>();

    public TimePeriods add(double v, ChronoUnit t) {
        if (v != 0.0) {
            Double d = this.values.get(t);
            if (d == null) {
                d = 0.0;
            }
            d = d + v;
            this.values.put(t, d);
        }
        return this;
    }

    public TimePeriods add(TimePeriod p) {
        if (p == null) {
            return this;
        }
        return this.add(p.getCount(), p.getUnit());
    }

    public TimePeriod[] getPeriodArray() {
        Object[] timePeriods = (TimePeriod[])this.values.entrySet().stream().map(x -> new TimePeriod((Double)x.getValue(), (ChronoUnit)x.getKey())).toArray(TimePeriod[]::new);
        Arrays.sort(timePeriods);
        return timePeriods;
    }

    public TimePeriod getPart(ChronoUnit a) {
        Double r = this.values.get(a);
        return r == null ? new TimePeriod(0.0, a) : new TimePeriod(r, a);
    }

    public TimePeriod toUnit(ChronoUnit a, TimespanPattern timespanPattern) {
        TimePeriods e = new TimePeriods();
        for (TimePeriod v : this.getPeriodArray()) {
            e.add(v.toUnit(a, timespanPattern));
        }
        Double r = e.values.get(a);
        return new TimePeriod(r == null ? 0.0 : r, a);
    }

    public String toString() {
        if (this.values.isEmpty()) {
            return "0";
        }
        TreeSet<ChronoUnit> r = new TreeSet<ChronoUnit>(new Comparator<ChronoUnit>(){

            @Override
            public int compare(ChronoUnit o1, ChronoUnit o2) {
                return o2.compareTo(o1);
            }
        });
        r.addAll(this.values.keySet());
        return r.stream().map(x -> new TimePeriod(this.values.get(x), (ChronoUnit)x).toString()).collect(Collectors.joining(" "));
    }
}

