/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.njob.time;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Date;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.toolbox.njob.time.TimePeriod;
import net.thevpc.nuts.toolbox.njob.time.TimespanPattern;

public class TimeParser {
    boolean parseTimes = true;
    boolean parseDates = true;
    String defaultTimeKeyword = "evening";

    private static void reachDayOfWeek(boolean future, Calendar c, int dayOfWeek) {
        if (future) {
            while (c.get(7) != dayOfWeek) {
                c.add(6, 1);
            }
        } else {
            while (c.get(7) != dayOfWeek) {
                c.add(6, -1);
            }
        }
    }

    public Predicate<Instant> parseInstantFilter(String s, boolean lenient) {
        if (s.startsWith(">=")) {
            Instant p = new TimeParser().parseInstant(s.substring(2), lenient);
            if (p != null) {
                return x -> x != null && x.compareTo(p) >= 0;
            }
            TimePeriod p0 = TimePeriod.parse(s.substring(1), lenient);
            if (p0 == null) {
                return null;
            }
            Instant p1 = p0.addTo(Instant.now(), TimespanPattern.DEFAULT);
            return x -> x != null && x.compareTo(p1) >= 0;
        }
        if (s.startsWith(">")) {
            Instant p = new TimeParser().parseInstant(s.substring(1), lenient);
            if (p != null) {
                return x -> x != null && x.compareTo(p) > 0;
            }
            TimePeriod p0 = TimePeriod.parse(s.substring(1), lenient);
            if (p0 == null) {
                return null;
            }
            Instant p1 = p0.addTo(Instant.now(), TimespanPattern.DEFAULT);
            return x -> x != null && x.compareTo(p1) > 0;
        }
        if (s.startsWith("<=")) {
            Instant p = new TimeParser().parseInstant(s.substring(2), lenient);
            if (p != null) {
                return x -> x != null && x.compareTo(p) <= 0;
            }
            TimePeriod p0 = TimePeriod.parse(s.substring(1), lenient);
            if (p0 == null) {
                return null;
            }
            Instant p1 = p0.addTo(Instant.now(), TimespanPattern.DEFAULT);
            return x -> x != null && x.compareTo(p1) <= 0;
        }
        if (s.startsWith("<")) {
            Instant p = new TimeParser().parseInstant(s.substring(1), lenient);
            if (p != null) {
                return x -> x != null && x.compareTo(p) < 0;
            }
            TimePeriod p0 = TimePeriod.parse(s.substring(1), lenient);
            if (p0 == null) {
                return null;
            }
            Instant p1 = p0.addTo(Instant.now(), TimespanPattern.DEFAULT);
            return x -> x != null && x.compareTo(p1) < 0;
        }
        Instant p = new TimeParser().parseInstant(s, lenient);
        if (p != null) {
            return x -> x != null && x.compareTo(p) == 0;
        }
        TimePeriod p0 = TimePeriod.parse(s.substring(1), lenient);
        if (p0 == null) {
            return null;
        }
        Instant p1 = p0.addTo(Instant.now(), TimespanPattern.DEFAULT);
        return x -> x != null && x.compareTo(p1) == 0;
    }

    public Instant parseInstant(String a, boolean lenient) {
        return this.parseInstant(new PatternStringBuilder(a), lenient);
    }

    public Instant parseInstant(PatternStringBuilder a, boolean lenient) {
        try {
            if (a.matches("[0-9]{4}-[0-9]{2}-[0-9]{2}")) {
                return Instant.parse(a + "T00:00:00Z");
            }
            if (a.matches("[0-9]{2}[hH][0-9]{2}")) {
                return Instant.parse(new SimpleDateFormat("yyyy-MM-dd").format(new Date()) + "T" + a.toString().replace("[hH]", ":") + "Z");
            }
            if (a.matches("[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}")) {
                return Instant.parse(a + ":00Z");
            }
            if (a.matches("[0-9]{4}-[0-9]{2}-[0-9]{2}[T@][0-9]{2}:[0-9]{2}")) {
                return Instant.parse(a.toString().replace('@', 'T') + ":00Z");
            }
            if (a.matches("[0-9]{4}-[0-9]{2}-[0-9]{2}[@T][0-9]{2}:[0-9]{2}:[0-9]{2}")) {
                return Instant.parse(a.toString().replace('@', 'T') + "Z");
            }
            if (a.matches("[a-zA-Z]+ [0-9]{2}:[0-9]{2}:[0-9]{2}")) {
                return Instant.parse(a.toString().replace('@', 'T') + "Z");
            }
            String day = null;
            String time = null;
            boolean future = false;
            DecimalFormat D2 = new DecimalFormat("00");
            while (!a.isEmpty()) {
                String s;
                if (this.parseDates && (s = a.readMatchAnyCase("today|tonight|yesterday|tomorrow|sunday|monday|tuesday|wednesday|thursday|friday|saturday|sun|mon|tue|wed|thu|fri|sat")) != null) {
                    day = s;
                    continue;
                }
                s = a.readMatchAnyCase("next");
                if (s != null) {
                    future = true;
                    continue;
                }
                s = a.readMatchAnyCase("last");
                if (s != null) {
                    future = false;
                    continue;
                }
                s = a.readMatchAnyCase("this");
                if (s != null) {
                    day = "today";
                    continue;
                }
                s = a.readMatchAnyCase("morning|afternoon|evening|night|sametime|samehour|same-time|same-hour|midnight|midday");
                if (s != null) {
                    time = this.timeStringFromKeyword(s);
                    continue;
                }
                s = a.readMatchAnyCase("[0-9]{2}:[0-9]{2}:[0-9]{2}");
                if (s != null) {
                    time = s;
                    continue;
                }
                s = a.readMatchAnyCase("[0-9]{2}[hH][0-9]{2}");
                if (s != null) {
                    time = s.replace("[hH]", ":") + ":00";
                    continue;
                }
                s = a.readMatchAnyCase("[0-9]{1,2}[hH]");
                if (s != null) {
                    time = s.replace("[hH]", ":") + ":00:00";
                    if (time.length() != 7) continue;
                    time = "0" + time;
                    continue;
                }
                s = a.readMatchAnyCase("[0-9]{1,2}am");
                if (s != null) {
                    int i = Integer.parseInt(s.substring(0, s.length() - 2));
                    if (i == 12) {
                        i = 0;
                    }
                    if ((time = i + ":00:00").length() != 7) continue;
                    time = "0" + time;
                    continue;
                }
                s = a.readMatchAnyCase("[0-9]{1,2}pm");
                if (s != null) {
                    int t = Integer.parseInt(s.substring(0, s.length() - 2));
                    if ((t += 12) == 24) {
                        t = 0;
                    }
                    if ((time = t + ":00:00").length() != 7) continue;
                    time = "0" + time;
                    continue;
                }
                if (a.trimStart()) continue;
                if (lenient) {
                    return null;
                }
                throw new IllegalArgumentException("Unexpected " + a);
            }
            Calendar c = Calendar.getInstance();
            c.set(14, 0);
            c.set(13, 0);
            c.set(12, 0);
            c.set(11, 0);
            if (time != null && time.equals("24:00:00")) {
                c.add(6, 1);
                time = "00:00:00";
            }
            if (day != null) {
                switch (day.toLowerCase()) {
                    case "today": {
                        if (time != null) break;
                        time = this.timeStringFromKeyword("afternoon");
                        break;
                    }
                    case "tonight": {
                        if (time != null) break;
                        time = this.timeStringFromKeyword("night");
                        break;
                    }
                    case "yesterday": {
                        c.add(6, -1);
                        break;
                    }
                    case "tomorrow": {
                        c.add(6, 1);
                        break;
                    }
                    case "sunday": 
                    case "sun": {
                        TimeParser.reachDayOfWeek(future, c, 1);
                        break;
                    }
                    case "monday": 
                    case "mon": {
                        TimeParser.reachDayOfWeek(future, c, 2);
                        break;
                    }
                    case "tuesday": 
                    case "tue": {
                        TimeParser.reachDayOfWeek(future, c, 3);
                        break;
                    }
                    case "wednesday": 
                    case "wed": {
                        TimeParser.reachDayOfWeek(future, c, 4);
                        break;
                    }
                    case "thursday": 
                    case "thu": {
                        TimeParser.reachDayOfWeek(future, c, 5);
                        break;
                    }
                    case "friday": 
                    case "fri": {
                        TimeParser.reachDayOfWeek(future, c, 6);
                        break;
                    }
                    case "saturday": 
                    case "sat": {
                        TimeParser.reachDayOfWeek(future, c, 7);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported");
                    }
                }
                if (time == null) {
                    time = this.timeStringFromKeyword(this.defaultTimeKeyword);
                }
                c.set(11, Integer.parseInt(time.substring(0, 2), 10));
                c.set(12, Integer.parseInt(time.substring(3, 5), 10));
                c.set(13, Integer.parseInt(time.substring(6, 8), 10));
            }
            return c.toInstant();
        }
        catch (RuntimeException ex) {
            if (lenient) {
                return null;
            }
            throw ex;
        }
    }

    private String timeStringFromKeyword(String s) {
        if (s.matches("[0-9]{2}:[0-9]{2}:[0-9]{2}")) {
            return s;
        }
        if (s.matches("[0-9]{2}:[0-9]{2}")) {
            return s + ":00";
        }
        LocalTime lt = LocalTime.now();
        DecimalFormat D2 = new DecimalFormat("00");
        return s.equalsIgnoreCase("morning") ? "08:00:00" : (s.equalsIgnoreCase("afternoon") ? "14:00:00" : (s.equalsIgnoreCase("evening") ? "18:00:00" : (s.equalsIgnoreCase("night") ? "20:00:00" : (s.equalsIgnoreCase("sametime") ? D2.format(lt.getHour()) + ":" + D2.format(lt.getMinute()) + ":00" : (s.equalsIgnoreCase("same-time") ? D2.format(lt.getHour()) + ":" + D2.format(lt.getMinute()) + ":00" : (s.equalsIgnoreCase("samehour") ? D2.format(lt.getHour()) + ":00:00" : (s.equalsIgnoreCase("same-hour") ? D2.format(lt.getHour()) + ":00:00" : (s.equalsIgnoreCase("midnight") ? "24:00:00" : (s.equalsIgnoreCase("midday") ? "12:00:00" : "00:00:00")))))))));
    }

    private boolean isWordChar(char wc) {
        return Character.isAlphabetic(wc);
    }

    private boolean isWord(String w, String where, int from) {
        if (from > 0 && this.isWordChar(where.charAt(from - 1))) {
            return false;
        }
        return from + w.length() >= where.length() || !this.isWordChar(where.charAt(from - w.length()));
    }

    private int indexOfWord(String w, String where) {
        int i = 0;
        while (i < where.length()) {
            int t = where.indexOf(w, i);
            if (this.isWord(w, where, t)) {
                return t;
            }
            i = t + w.length();
        }
        return -1;
    }

    public TimeParser setTimeOnly(boolean b) {
        this.parseDates = false;
        return this;
    }

    static class PatternStringBuilder {
        StringBuilder value = new StringBuilder();

        public PatternStringBuilder(String s) {
            this.value.append(s);
        }

        boolean matches(String pattern) {
            return this.value.toString().matches(pattern);
        }

        String readMatch(String pattern) {
            Pattern r = Pattern.compile("^(?<x>(" + pattern + ").*");
            Matcher m = r.matcher(this.value.toString());
            if (m.find()) {
                String y = m.group("x");
                this.value.delete(0, y.length());
                return y;
            }
            return null;
        }

        String readMatchAnyCase(String pattern) {
            Pattern r = Pattern.compile("^(?<x>(" + pattern + "))($|(\\W.*))", 2);
            Matcher m = r.matcher(this.value.toString());
            if (m.find()) {
                String y = m.group("x");
                this.value.delete(0, y.length());
                return y;
            }
            return null;
        }

        public String toString() {
            return this.value.toString();
        }

        boolean isEmpty() {
            return this.value.length() == 0;
        }

        public boolean trimStart() {
            if (this.value.length() > 0) {
                int ok;
                for (ok = 0; ok < this.value.length() && this.value.charAt(ok) <= ' '; ++ok) {
                }
                if (ok > 0) {
                    this.value.delete(0, ok);
                    return true;
                }
            }
            return false;
        }
    }
}

