/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.njob.time;

import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import net.thevpc.nuts.toolbox.njob.time.TimePeriod;

public class TimeFormatter {
    boolean fuzzy = true;
    boolean daySuffix = true;

    protected String extractTimeName2(LocalTime d) {
        if (d.getMinute() == 0 && d.getHour() == 0) {
            return "00:00";
        }
        if (d.getMinute() == 59 && d.getHour() == 23) {
            return "midnight";
        }
        DecimalFormat df2 = new DecimalFormat("00");
        return df2.format(d.getHour()) + ":" + df2.format(d.getMinute());
    }

    protected String extractTodayTimeName(LocalTime d) {
        LocalTime n;
        long u;
        if (d.getMinute() == 0 && d.getHour() == 0) {
            return "00:00";
        }
        if (d.getMinute() == 59 && d.getHour() == 23) {
            return "midnight";
        }
        if (this.fuzzy && Math.abs(u = ChronoUnit.MINUTES.between(n = LocalTime.now(), d)) < 240L) {
            if (u > 0L && u < 600L) {
                return "in " + new TimePeriod(u, ChronoUnit.MINUTES).toTimePeriods().toString();
            }
            if (-u > 0L && -u < 600L) {
                return -u + "mn ago";
            }
        }
        DecimalFormat df2 = new DecimalFormat("00");
        return df2.format(d.getHour()) + ":" + df2.format(d.getMinute());
    }

    protected boolean isToday(LocalDate d) {
        LocalDate n = LocalDateTime.now().toLocalDate();
        return n.equals(d);
    }

    protected String extractDateName(LocalDate d, String qualifier) {
        LocalDate n = LocalDateTime.now().toLocalDate();
        if (d.equals(n)) {
            if (qualifier != null) {
                if (qualifier.equals("midnight")) {
                    return qualifier;
                }
                if (qualifier.equals("night")) {
                    return "tonight";
                }
                return "this " + qualifier;
            }
            return "today";
        }
        if (d.equals(n.plus(-1L, ChronoUnit.DAYS))) {
            String t = "yesterday";
            if (qualifier != null) {
                return "yesterday " + qualifier;
            }
            return t;
        }
        if (d.equals(n.plus(1L, ChronoUnit.DAYS))) {
            String t = "tomorrow";
            if (qualifier != null) {
                return "tomorrow " + qualifier;
            }
            return t;
        }
        if (d.equals(n.plus(-2L, ChronoUnit.DAYS))) {
            return "two days ago";
        }
        if (d.equals(n.plus(-3L, ChronoUnit.DAYS))) {
            return "three days ago";
        }
        if (d.equals(n.plus(-4L, ChronoUnit.DAYS))) {
            return "four days ago";
        }
        if (d.equals(n.plus(-5L, ChronoUnit.DAYS))) {
            return "five days ago";
        }
        if (d.equals(n.plus(-6L, ChronoUnit.DAYS))) {
            return "six days ago";
        }
        if (d.equals(n.plus(2L, ChronoUnit.DAYS))) {
            return "in two days";
        }
        if (d.equals(n.plus(3L, ChronoUnit.DAYS))) {
            return "in three days";
        }
        if (d.equals(n.plus(4L, ChronoUnit.DAYS))) {
            return "in four days";
        }
        if (d.equals(n.plus(5L, ChronoUnit.DAYS))) {
            return "in five days";
        }
        if (d.equals(n.plus(6L, ChronoUnit.DAYS))) {
            return "in six days";
        }
        if (d.equals(n.plus(-7L, ChronoUnit.DAYS))) {
            return "last week";
        }
        if (d.equals(n.plus(7L, ChronoUnit.DAYS))) {
            return "next week";
        }
        DecimalFormat df2 = new DecimalFormat("00");
        DecimalFormat df4 = new DecimalFormat("0000");
        return df4.format(d.getYear()) + "-" + df2.format(d.getMonth().getValue()) + "-" + df2.format(d.getDayOfMonth());
    }

    public String format(LocalDateTime d) {
        String r = null;
        if (d.getMinute() <= 1 && d.getHour() == 0) {
            r = this.extractDateName(d.toLocalDate().minus(1L, ChronoUnit.DAYS), "midnight");
        } else {
            String t;
            boolean today = this.isToday(d.toLocalDate());
            int h = d.toLocalTime().getHour();
            String string = t = today ? this.extractTodayTimeName(d.toLocalTime()) : this.extractTimeName2(d.toLocalTime());
            if (t.equals("midnight")) {
                r = this.extractDateName(d.toLocalDate(), t);
            } else {
                String dd = this.extractDateName(d.toLocalDate(), h < 12 ? "morning" : (h >= 14 && h < 18 ? "afternoon" : (h >= 18 && h < 20 ? "evening" : (h >= 20 ? "night" : null))));
                r = dd + " " + t;
            }
        }
        if (this.daySuffix) {
            r = r.equals("midnight") && d.getMinute() <= 1 && d.getHour() == 0 ? r + " " + d.toLocalDate().minus(1L, ChronoUnit.DAYS).getDayOfWeek().toString().toLowerCase().substring(0, 3) : r + " " + d.getDayOfWeek().toString().toLowerCase().substring(0, 3);
        }
        return r;
    }
}

