/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.njob;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsArgumentName;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsMutableTableModel;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTableFormat;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.toolbox.njob.JobService;
import net.thevpc.nuts.toolbox.njob.JobServiceCmd;
import net.thevpc.nuts.toolbox.njob.model.NFlag;
import net.thevpc.nuts.toolbox.njob.model.NJob;
import net.thevpc.nuts.toolbox.njob.model.NJobGroup;
import net.thevpc.nuts.toolbox.njob.model.NPriority;
import net.thevpc.nuts.toolbox.njob.model.NProject;
import net.thevpc.nuts.toolbox.njob.model.NTask;
import net.thevpc.nuts.toolbox.njob.model.NTaskStatus;
import net.thevpc.nuts.toolbox.njob.model.NTaskStatusFilter;
import net.thevpc.nuts.toolbox.njob.time.TimeParser;
import net.thevpc.nuts.toolbox.njob.time.TimePeriod;
import net.thevpc.nuts.toolbox.njob.time.TimespanPattern;

public class NTasksSubCmd {
    private JobService service;
    private NutsApplicationContext context;
    private NutsSession session;
    private JobServiceCmd parent;

    public NTasksSubCmd(JobServiceCmd parent) {
        this.parent = parent;
        this.context = parent.context;
        this.service = parent.service;
        this.session = parent.session;
    }

    public void runTaskAdd(NutsCommandLine cmd) {
        boolean list = false;
        boolean show = false;
        boolean nameVisited = false;
        ArrayList<Consumer<NTask>> runLater = new ArrayList<Consumer<NTask>>();
        while (cmd.hasNext()) {
            String s;
            NutsArgument a = cmd.nextBoolean(new String[]{"--list", "-l"});
            if (a != null) {
                list = a.getBooleanValue();
                continue;
            }
            a = cmd.nextBoolean(new String[]{"--show", "-s"});
            if (a != null) {
                show = a.getBooleanValue();
                continue;
            }
            a = cmd.nextString(new String[]{"--on", "--due", "-t"});
            if (a != null) {
                s = a.getValue().getString();
                runLater.add(t -> t.setDueTime(new TimeParser().parseInstant(s, false)));
                continue;
            }
            a = cmd.nextString(new String[]{"--at"});
            if (a != null) {
                s = a.getValue().getString();
                runLater.add(t -> t.setDueTime(new TimeParser().setTimeOnly(true).parseInstant(s, false)));
                continue;
            }
            a = cmd.nextString(new String[]{"--start"});
            if (a != null) {
                s = a.getValue().getString();
                runLater.add(t -> t.setStartTime(new TimeParser().parseInstant(s, false)));
                continue;
            }
            a = cmd.nextString(new String[]{"--end"});
            if (a != null) {
                s = a.getValue().getString();
                runLater.add(t -> t.setEndTime(new TimeParser().parseInstant(s, false)));
                continue;
            }
            a = cmd.nextString(new String[]{"--for"});
            if (a != null) {
                s = a.getValue().getString();
                runLater.add(t -> {
                    Instant u = new TimeParser().parseInstant(s, true);
                    if (u != null) {
                        t.setDueTime(u);
                    } else {
                        t.setProject(s);
                    }
                });
                continue;
            }
            a = cmd.nextString(new String[]{"-p", "--project"});
            if (a != null) {
                s = a.getValue().getString();
                runLater.add(t -> t.setProject(s));
                continue;
            }
            a = cmd.nextString(new String[]{"-n", "--name"});
            if (a != null) {
                s = a.getValue().getString();
                runLater.add(t -> t.setName(s));
                continue;
            }
            a = cmd.nextString(new String[]{"-f", "--flag"});
            if (a != null) {
                s = a.getValue().getString();
                runLater.add(t -> {
                    String v = s;
                    NFlag f = null;
                    f = "random".equalsIgnoreCase(v) ? NFlag.values()[(int)(Math.random() * (double)NFlag.values().length)] : NFlag.valueOf(v.toUpperCase());
                    t.setFlag(f);
                });
                continue;
            }
            a = cmd.nextString(new String[]{"-j", "--job"});
            if (a != null) {
                s = a.getValue().getString();
                runLater.add(t -> {
                    String jobId = s;
                    NJob job = this.service.jobs().getJob(jobId);
                    if (job == null) {
                        cmd.throwError(NutsMessage.cstyle((String)"invalid job %s", (Object[])new Object[]{jobId}));
                    }
                    t.setJobId(job.getId());
                });
                continue;
            }
            a = cmd.nextString(new String[]{"-T", "--parent"});
            if (a != null) {
                s = a.getValue().getString();
                runLater.add(t -> {
                    String taskId = s;
                    NTask parentTask = this.service.tasks().getTask(taskId);
                    if (parentTask == null) {
                        cmd.throwError(NutsMessage.cstyle((String)"invalid parent task %s", (Object[])new Object[]{taskId}));
                    }
                    t.setParentTaskId(parentTask.getId());
                });
                continue;
            }
            a = cmd.nextString(new String[]{"-P", "--priority"});
            if (a != null) {
                s = a.getValue().getString();
                runLater.add(t -> {
                    String v = s;
                    NPriority p = NPriority.NORMAL;
                    p = v.equalsIgnoreCase("higher") ? p.higher() : (v.equalsIgnoreCase("lower") ? p.lower() : NPriority.valueOf(v.toLowerCase()));
                    t.setPriority(p);
                });
                continue;
            }
            a = cmd.nextString(new String[]{"-o", "--obs"});
            if (a != null) {
                s = a.getValue().getString();
                runLater.add(t -> t.setObservations(s));
                continue;
            }
            a = cmd.nextString(new String[]{"-d", "--duration"});
            if (a != null) {
                s = a.getValue().getString();
                runLater.add(t -> t.setDuration(TimePeriod.parse(s, true)));
                continue;
            }
            a = cmd.next(new String[]{"--wip"});
            if (a != null) {
                runLater.add(t -> t.setStatus(NTaskStatus.WIP));
                continue;
            }
            a = cmd.next(new String[]{"--done"});
            if (a != null) {
                runLater.add(t -> t.setStatus(NTaskStatus.DONE));
                continue;
            }
            a = cmd.next(new String[]{"--cancel"});
            if (a != null) {
                runLater.add(t -> t.setStatus(NTaskStatus.CANCELLED));
                continue;
            }
            a = cmd.next(new String[]{"--todo"});
            if (a != null) {
                runLater.add(t -> t.setStatus(NTaskStatus.TODO));
                continue;
            }
            a = cmd.next(new String[]{"--high"});
            if (a != null) {
                runLater.add(t -> t.setPriority(NPriority.HIGH));
                continue;
            }
            a = cmd.next(new String[]{"--critical"});
            if (a != null) {
                runLater.add(t -> t.setPriority(NPriority.CRITICAL));
                continue;
            }
            a = cmd.next(new String[]{"--normal"});
            if (a != null) {
                runLater.add(t -> t.setPriority(NPriority.NORMAL));
                continue;
            }
            if (cmd.peek().isNonOption() && !nameVisited) {
                String n = cmd.next(NutsArgumentName.of((String)"name", (NutsSession)this.session)).getString();
                runLater.add(t -> t.setName(n));
                continue;
            }
            cmd.unexpectedArgument();
        }
        if (cmd.isExecMode()) {
            NTask t2 = new NTask();
            for (Consumer consumer : runLater) {
                consumer.accept(t2);
            }
            this.service.tasks().addTask(t2);
            if (this.context.getSession().isPlainTrace()) {
                this.context.getSession().out().printf("task %s (%s) added.\n", new Object[]{NutsTexts.of((NutsSession)this.context.getSession()).ofStyled(t2.getId(), NutsTextStyle.primary5()), t2.getName()});
            }
            if (show) {
                this.runTaskShow(NutsCommandLine.of((String[])new String[]{t2.getId()}, (NutsSession)this.session));
            }
            if (list) {
                this.runTaskList(NutsCommandLine.of((String[])new String[0], (NutsSession)this.session));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void runTaskUpdate(NutsCommandLine cmd) {
        ArrayList<NTask> tasks = new ArrayList<NTask>();
        boolean list = false;
        boolean show = false;
        ArrayList<Consumer<NTask>> runLater = new ArrayList<Consumer<NTask>>();
        block74: while (cmd.hasNext()) {
            Object a = cmd.peek();
            switch (a.getKey().getString()) {
                case "--list": 
                case "-l": {
                    list = cmd.nextBoolean(new String[0]).getBooleanValue();
                    continue block74;
                }
                case "--show": 
                case "-s": {
                    show = cmd.nextBoolean(new String[0]).getBooleanValue();
                    continue block74;
                }
                case "--start": {
                    Instant instant = new TimeParser().parseInstant(cmd.nextString(new String[0]).getValue().getString(), false);
                    runLater.add(t -> t.setStartTime(instant));
                    continue block74;
                }
                case "-t": 
                case "--on": 
                case "--due": {
                    String string = cmd.nextString(new String[0]).getValue().getString();
                    runLater.add(t -> t.setDueTime(TimePeriod.parseOpPeriodAsInstant(string, t.getDueTime(), true)));
                    continue block74;
                }
                case "--at": {
                    Instant instant = new TimeParser().setTimeOnly(true).parseInstant(cmd.nextString(new String[0]).getValue().getString(), false);
                    runLater.add(t -> t.setDueTime(instant));
                    continue block74;
                }
                case "--end": {
                    Instant instant = new TimeParser().parseInstant(cmd.nextString(new String[0]).getValue().getString(), false);
                    runLater.add(t -> t.setEndTime(instant));
                    continue block74;
                }
                case "--wip": {
                    cmd.skip();
                    runLater.add(t -> t.setStatus(NTaskStatus.WIP));
                    continue block74;
                }
                case "--done": {
                    cmd.skip();
                    runLater.add(t -> t.setStatus(NTaskStatus.DONE));
                    continue block74;
                }
                case "--cancel": {
                    cmd.skip();
                    runLater.add(t -> t.setStatus(NTaskStatus.CANCELLED));
                    continue block74;
                }
                case "--todo": {
                    cmd.skip();
                    runLater.add(t -> t.setStatus(NTaskStatus.TODO));
                    continue block74;
                }
                case "--high": {
                    cmd.skip();
                    runLater.add(t -> t.setPriority(NPriority.HIGH));
                    continue block74;
                }
                case "--critical": {
                    cmd.skip();
                    runLater.add(t -> t.setPriority(NPriority.CRITICAL));
                    continue block74;
                }
                case "--normal": {
                    cmd.skip();
                    runLater.add(t -> t.setPriority(NPriority.NORMAL));
                    continue block74;
                }
                case "++P": 
                case "++prio": 
                case "--prio++": {
                    cmd.skip();
                    runLater.add(t -> t.setPriority((t.getPriority() == null ? NPriority.NORMAL : t.getPriority()).higher()));
                    continue block74;
                }
                case "--P": 
                case "--prio": 
                case "--prio--": {
                    void var9_20;
                    a = cmd.next();
                    String string = a.getValue().getString();
                    if (!a.getKey().getString().equals("--prio")) {
                        Object var9_19 = null;
                    }
                    if (var9_20 == null) {
                        runLater.add(t -> t.setPriority((t.getPriority() == null ? NPriority.NORMAL : t.getPriority()).higher()));
                        continue block74;
                    }
                    NPriority pp = NPriority.parse((String)var9_20);
                    runLater.add(t -> t.setPriority(pp));
                    continue block74;
                }
                case "--status": {
                    NTaskStatus nTaskStatus = NTaskStatus.parse(cmd.nextString(new String[0]).getValue().getString());
                    runLater.add(t -> t.setStatus(nTaskStatus));
                    continue block74;
                }
                case "-d": 
                case "--duration": {
                    TimePeriod timePeriod = TimePeriod.parse(cmd.nextString(new String[0]).getValue().getString(), false);
                    runLater.add(t -> t.setDuration(timePeriod));
                    continue block74;
                }
                case "-n": 
                case "--name": {
                    String string = cmd.nextString(new String[0]).getValue().getString();
                    runLater.add(t -> t.setName(string));
                    continue block74;
                }
                case "-f": 
                case "--flag": {
                    String string = cmd.nextString(new String[0]).getValue().getString();
                    NFlag f = NFlag.parse(string);
                    runLater.add(t -> t.setFlag(f));
                    continue block74;
                }
                case "-j": 
                case "--job": {
                    String string = cmd.nextString(new String[0]).getValue().getString();
                    NJob job = this.service.jobs().getJob(string);
                    if (job == null) {
                        cmd.throwError(NutsMessage.cstyle((String)"invalid job %s", (Object[])new Object[]{string}));
                    }
                    runLater.add(t -> t.setJobId(job.getId()));
                    continue block74;
                }
                case "-T": 
                case "--parent": {
                    String string = cmd.nextString(new String[0]).getValue().getString();
                    NTask parentTask = this.service.tasks().getTask(string);
                    if (parentTask == null) {
                        cmd.throwError(NutsMessage.cstyle((String)"invalid parent task %s", (Object[])new Object[]{string}));
                    }
                    runLater.add(t -> t.setParentTaskId(parentTask.getId()));
                    continue block74;
                }
                case "-P": 
                case "--priority": {
                    String string = cmd.nextString(new String[0]).getValue().getString();
                    runLater.add(t -> {
                        NPriority p = t.getPriority();
                        p = string.equalsIgnoreCase("higher") ? p.higher() : (string.equalsIgnoreCase("lower") ? p.lower() : NPriority.parse(string));
                        t.setPriority(p);
                    });
                    continue block74;
                }
                case "--for": {
                    String string = cmd.nextString(new String[0]).getValue().getString();
                    runLater.add(t -> {
                        Instant u = TimePeriod.parseOpPeriodAsInstant(string, t.getDueTime(), true);
                        if (u != null) {
                            t.setDueTime(u);
                        } else {
                            t.setProject(string);
                        }
                    });
                    continue block74;
                }
                case "-p": 
                case "--project": {
                    String string = cmd.nextString(new String[0]).getValue().getString();
                    runLater.add(t -> t.setProject(string));
                    continue block74;
                }
                case "-o": 
                case "--obs": {
                    String string = cmd.nextString(new String[0]).getValue().getString();
                    runLater.add(t -> t.setObservations(string));
                    continue block74;
                }
                case "-o+": 
                case "--obs+": 
                case "+obs": {
                    String string = cmd.nextString(new String[0]).getValue().getString();
                    runLater.add(t -> {
                        String s = t.getObservations();
                        if (s == null) {
                            s = "";
                        }
                        if (!(s = s.trim()).isEmpty()) {
                            s = s + "\n";
                        }
                        s = s + string;
                        s = s.trim();
                        t.setObservations(s);
                    });
                    continue block74;
                }
            }
            if (a.isNonOption()) {
                String string = cmd.next().toString();
                NTask t2 = this.findTask(string, cmd);
                tasks.add(t2);
                continue;
            }
            cmd.unexpectedArgument();
        }
        if (tasks.isEmpty()) {
            cmd.throwError(NutsMessage.formatted((String)"task id expected"));
        }
        if (cmd.isExecMode()) {
            for (NTask task : tasks) {
                for (Consumer consumer : runLater) {
                    consumer.accept(task);
                }
            }
            NutsTexts text = NutsTexts.of((NutsSession)this.context.getSession());
            for (NTask task : new LinkedHashSet(tasks)) {
                this.service.tasks().updateTask(task);
                if (!this.context.getSession().isPlainTrace()) continue;
                this.context.getSession().out().printf("task %s (%s) updated.\n", new Object[]{text.ofStyled(task.getId(), NutsTextStyle.primary5()), text.ofStyled(task.getName(), NutsTextStyle.primary1())});
            }
            if (show) {
                for (NTask t3 : new LinkedHashSet(tasks)) {
                    this.runTaskList(NutsCommandLine.of((String[])new String[]{t3.getId()}, (NutsSession)this.session));
                }
            }
            if (list) {
                this.runTaskList(NutsCommandLine.of((String[])new String[0], (NutsSession)this.session));
            }
        }
    }

    private void runTaskList(NutsCommandLine cmd) {
        TimespanPattern hoursPerDay = TimespanPattern.WORK;
        int count = 100;
        NJobGroup groupBy = null;
        ChronoUnit countType = null;
        ChronoUnit timeUnit = null;
        Predicate<NTask> whereFilter = null;
        NTaskStatusFilter status = null;
        while (cmd.hasNext()) {
            NutsArgument a = cmd.peek();
            block37 : switch (a.getKey().getString()) {
                case "-w": 
                case "--weeks": {
                    countType = ChronoUnit.WEEKS;
                    count = cmd.nextString(new String[0]).getValue().getInt();
                    break;
                }
                case "-m": 
                case "--months": {
                    countType = ChronoUnit.MONTHS;
                    count = cmd.nextString(new String[0]).getValue().getInt();
                    break;
                }
                case "-l": {
                    countType = null;
                    count = cmd.nextString(new String[0]).getValue().getInt();
                    break;
                }
                case "-u": 
                case "--unit": {
                    timeUnit = TimePeriod.parseUnit(cmd.nextString(new String[0]).getValue().getString(), false);
                    break;
                }
                case "--todo": {
                    cmd.nextString(new String[0]);
                    status = NTaskStatusFilter.TODO;
                    break;
                }
                case "-a": 
                case "--all": {
                    cmd.nextString(new String[0]);
                    status = NTaskStatusFilter.ALL;
                    break;
                }
                case "-r": 
                case "--recent": {
                    cmd.nextString(new String[0]);
                    status = NTaskStatusFilter.RECENT;
                    break;
                }
                case "--cancelled": {
                    cmd.nextString(new String[0]);
                    status = NTaskStatusFilter.CANCELLED;
                    break;
                }
                case "--closed": {
                    cmd.nextString(new String[0]);
                    status = NTaskStatusFilter.CLOSED;
                    break;
                }
                case "--wip": {
                    cmd.nextString(new String[0]);
                    status = NTaskStatusFilter.WIP;
                    break;
                }
                case "-o": 
                case "--open": {
                    cmd.nextString(new String[0]);
                    status = NTaskStatusFilter.OPEN;
                    break;
                }
                case "-g": 
                case "--group": 
                case "--groupBy": 
                case "--groupby": 
                case "--group-by": {
                    NutsArgument y = cmd.nextString(new String[0]);
                    switch (y.getValue().getString()) {
                        case "p": 
                        case "project": {
                            groupBy = NJobGroup.PROJECT_NAME;
                            break block37;
                        }
                        case "n": 
                        case "name": {
                            groupBy = NJobGroup.NAME;
                            break block37;
                        }
                        case "s": 
                        case "summary": {
                            groupBy = NJobGroup.SUMMARY;
                            break block37;
                        }
                    }
                    cmd.pushBack(y).unexpectedArgument(NutsMessage.cstyle((String)"invalid value", (Object[])new Object[0]));
                    break;
                }
                case "--project": 
                case "-p": {
                    String s = cmd.nextString(new String[0]).getValue().getString();
                    Predicate<String> sp = this.parent.createProjectFilter(s);
                    Predicate<NTask> t = x -> sp.test(x.getProject());
                    whereFilter = this.parent.appendPredicate(whereFilter, t);
                    break;
                }
                case "-n": 
                case "--name": {
                    String s = cmd.nextString(new String[0]).getValue().getString();
                    Predicate<String> sp = this.parent.createStringFilter(s);
                    Predicate<NTask> t = x -> sp.test(x.getName());
                    whereFilter = this.parent.appendPredicate(whereFilter, t);
                    break;
                }
                case "-b": 
                case "--beneficiary": {
                    String s = cmd.nextString(new String[0]).getValue().getString();
                    Predicate<String> sp = this.parent.createStringFilter(s);
                    Predicate<NTask> t = x -> {
                        NProject project = this.service.projects().getProject(x.getProject());
                        return sp.test(project == null ? "" : project.getBeneficiary());
                    };
                    whereFilter = this.parent.appendPredicate(whereFilter, t);
                    break;
                }
                case "-c": 
                case "--company": {
                    String s = cmd.nextString(new String[0]).getValue().getString();
                    Predicate<String> sp = this.parent.createStringFilter(s);
                    Predicate<NTask> t = x -> {
                        NProject project = this.service.projects().getProject(x.getProject());
                        return sp.test(project == null ? "" : project.getCompany());
                    };
                    whereFilter = this.parent.appendPredicate(whereFilter, t);
                    break;
                }
                case "-d": 
                case "--duration": {
                    String s = cmd.nextString(new String[0]).getValue().getString();
                    Predicate<TimePeriod> p = TimePeriod.parseFilter(s, false);
                    Predicate<NTask> t = x -> p.test(x.getDuration());
                    whereFilter = this.parent.appendPredicate(whereFilter, t);
                    break;
                }
                case "-t": 
                case "--startTime": 
                case "--start-time": {
                    String s = cmd.nextString(new String[0]).getValue().getString();
                    Predicate<Instant> t = new TimeParser().parseInstantFilter(s, false);
                    whereFilter = this.parent.appendPredicate(whereFilter, x -> t.test(x.getStartTime()));
                    break;
                }
                default: {
                    cmd.unexpectedArgument();
                }
            }
        }
        if (cmd.isExecMode()) {
            Stream<NTask> r = this.service.tasks().findTasks(status, null, count, countType, whereFilter, groupBy, timeUnit, hoursPerDay);
            if (this.context.getSession().isPlainTrace()) {
                NutsMutableTableModel m = NutsMutableTableModel.of((NutsSession)this.session);
                ArrayList lastResults = new ArrayList();
                int[] index = new int[1];
                r.forEach(x -> {
                    index[0] = index[0] + 1;
                    m.newRow().addCells(this.toTaskRowArray((NTask)x, this.parent.createHashId(index[0], -1)));
                    lastResults.add(x);
                });
                this.context.getSession().setProperty("LastResults", (Object)lastResults.toArray(new NTask[0]));
                NutsTableFormat.of((NutsSession)this.session).setBorder("spaces").setValue((Object)m).println();
            } else {
                this.context.getSession().out().printf(r.collect(Collectors.toList()));
            }
        }
    }

    private Object[] toTaskRowArray(NTask x, String index) {
        String project = x.getProject();
        NProject p = project == null ? null : this.service.projects().getProject(project);
        NTaskStatus s = x.getStatus();
        String dte0 = this.parent.getFormattedDate(x.getDueTime());
        NutsTextBuilder dte = NutsTexts.of((NutsSession)this.session).builder();
        if (s == NTaskStatus.CANCELLED || s == NTaskStatus.DONE) {
            dte.append((Object)dte0, NutsTextStyle.pale());
        } else if (x.getDueTime() != null && x.getDueTime().compareTo(Instant.now()) < 0) {
            dte.append((Object)dte0, NutsTextStyle.error());
        } else {
            dte.append((Object)dte0, NutsTextStyle.keyword((int)2));
        }
        String projectName = p != null ? p.getName() : (project != null ? project : "*");
        return new Object[]{index, NutsTexts.of((NutsSession)this.session).builder().append((Object)x.getId(), NutsTextStyle.pale()), this.parent.getFlagString(x.getFlag()), this.parent.getStatusString(x.getStatus()), this.parent.getPriorityString(x.getPriority()), dte.immutable(), this.parent.getFormattedProject(projectName), x.getName()};
    }

    private void runTaskRemove(NutsCommandLine cmd) {
        NutsTexts text = NutsTexts.of((NutsSession)this.context.getSession());
        while (cmd.hasNext()) {
            NutsArgument a = cmd.next();
            if (!cmd.isExecMode()) continue;
            NTask t = this.findTask(a.toString(), cmd);
            if (this.service.tasks().removeTask(t.getId())) {
                if (!this.context.getSession().isPlainTrace()) continue;
                this.context.getSession().out().printf("task %s removed.\n", new Object[]{text.ofStyled(a.toString(), NutsTextStyle.primary5())});
                continue;
            }
            this.context.getSession().out().printf("task %s %s.\n", new Object[]{text.ofStyled(a.toString(), NutsTextStyle.primary5()), text.ofStyled("not found", NutsTextStyle.error())});
        }
    }

    private void runTaskShow(NutsCommandLine cmd) {
        while (cmd.hasNext()) {
            NutsArgument a = cmd.next();
            if (!cmd.isExecMode()) continue;
            NTask task = this.findTask(a.toString(), cmd);
            if (task == null) {
                this.context.getSession().out().printf("```kw %s```: ```error not found```.\n", new Object[]{a.toString()});
                continue;
            }
            this.context.getSession().out().printf("```kw %s```:\n", new Object[]{task.getId()});
            String prefix = "\t                    ";
            Object[] objectArray = new Object[1];
            objectArray[0] = JobServiceCmd.formatWithPrefix(task.getName(), prefix);
            this.context.getSession().out().printf("\t```kw2 task name```     : %s\n", objectArray);
            Object[] objectArray2 = new Object[1];
            objectArray2[0] = JobServiceCmd.formatWithPrefix((Object)task.getStatus(), prefix);
            this.context.getSession().out().printf("\t```kw2 status```        : %s\n", objectArray2);
            Object[] objectArray3 = new Object[1];
            objectArray3[0] = JobServiceCmd.formatWithPrefix((Object)task.getPriority(), prefix);
            this.context.getSession().out().printf("\t```kw2 priority```      : %s\n", objectArray3);
            String project = task.getProject();
            NProject p = this.service.projects().getProject(project);
            if (project == null || project.length() == 0) {
                this.context.getSession().out().printf("\t```kw2 project```       : %s\n", new Object[]{""});
            } else {
                Object[] objectArray4 = new Object[2];
                objectArray4[0] = project;
                objectArray4[1] = JobServiceCmd.formatWithPrefix(p == null ? "?" : p.getName(), prefix);
                this.context.getSession().out().printf("\t```kw2 project```       : %s (%s)\n", objectArray4);
            }
            Object[] objectArray5 = new Object[1];
            objectArray5[0] = JobServiceCmd.formatWithPrefix((Object)task.getFlag(), prefix);
            this.context.getSession().out().printf("\t```kw2 flag```          : %s\n", objectArray5);
            Object[] objectArray6 = new Object[1];
            objectArray6[0] = JobServiceCmd.formatWithPrefix(task.getParentTaskId(), prefix);
            this.context.getSession().out().printf("\t```kw2 parent id```     : %s\n", objectArray6);
            Object[] objectArray7 = new Object[1];
            objectArray7[0] = JobServiceCmd.formatWithPrefix(task.getJobId(), prefix);
            this.context.getSession().out().printf("\t```kw2 job id```        : %s\n", objectArray7);
            Object[] objectArray8 = new Object[1];
            objectArray8[0] = JobServiceCmd.formatWithPrefix(task.getDueTime(), prefix);
            this.context.getSession().out().printf("\t```kw2 due time```      : %s\n", objectArray8);
            Object[] objectArray9 = new Object[1];
            objectArray9[0] = JobServiceCmd.formatWithPrefix(task.getStartTime(), prefix);
            this.context.getSession().out().printf("\t```kw2 start time```    : %s\n", objectArray9);
            Object[] objectArray10 = new Object[1];
            objectArray10[0] = JobServiceCmd.formatWithPrefix(task.getEndTime(), prefix);
            this.context.getSession().out().printf("\t```kw2 end time```      : %s\n", objectArray10);
            Object[] objectArray11 = new Object[1];
            objectArray11[0] = JobServiceCmd.formatWithPrefix(task.getDuration(), prefix);
            this.context.getSession().out().printf("\t```kw2 duration```      : %s\n", objectArray11);
            Object[] objectArray12 = new Object[1];
            objectArray12[0] = JobServiceCmd.formatWithPrefix(task.getInternalDuration(), prefix);
            this.context.getSession().out().printf("\t```kw2 duration extra```: %s\n", objectArray12);
            Object[] objectArray13 = new Object[1];
            objectArray13[0] = JobServiceCmd.formatWithPrefix(task.getCreationTime(), prefix);
            this.context.getSession().out().printf("\t```kw2 creation time``` : %s\n", objectArray13);
            Object[] objectArray14 = new Object[1];
            objectArray14[0] = JobServiceCmd.formatWithPrefix(task.getModificationTime(), prefix);
            this.context.getSession().out().printf("\t```kw2 modif. time```   : %s\n", objectArray14);
            Object[] objectArray15 = new Object[1];
            objectArray15[0] = JobServiceCmd.formatWithPrefix(task.getObservations(), prefix);
            this.context.getSession().out().printf("\t```kw2 observations```  : %s\n", objectArray15);
        }
    }

    public boolean runTaskCommands(NutsCommandLine cmd) {
        if (cmd.next(new String[]{"a t", "t a", "ta", "at", "add task", "tasks add"}) != null) {
            this.runTaskAdd(cmd);
            return true;
        }
        if (cmd.next(new String[]{"t u", "u t", "tu", "ut", "update task", "tasks update"}) != null) {
            this.runTaskUpdate(cmd);
            return true;
        }
        if (cmd.next(new String[]{"l t", "t l", "lt", "tl", "list tasks", "tasks list"}) != null) {
            this.runTaskList(cmd);
            return true;
        }
        if (cmd.next(new String[]{"tr", "rt", "trm", "rmt", "t r", "r t", "t rm", "rm t", "remove task", "remove tasks", "rm task", "rm tasks", "tasks remove", "tasks rm"}) != null) {
            this.runTaskRemove(cmd);
            return true;
        }
        if (cmd.next(new String[]{"st", "ts", "s t", "t s", "show task", "show tasks", "tasks show"}) != null) {
            this.runTaskShow(cmd);
            return true;
        }
        if (cmd.next(new String[]{"t", "tasks"}) != null) {
            if (cmd.next(new String[]{"--help"}) != null) {
                this.parent.showCustomHelp("njob-tasks");
            } else {
                this.runTaskList(cmd);
            }
            return true;
        }
        return false;
    }

    private NTask findTask(String pid, NutsCommandLine cmd) {
        NTask t = null;
        if (pid.startsWith("#")) {
            Object lastResults;
            int x = JobServiceCmd.parseIntOrFF(pid.substring(1));
            if (x >= 1 && (lastResults = this.context.getSession().getProperty("LastResults")) instanceof NTask[] && x <= ((NTask[])lastResults).length) {
                t = ((NTask[])lastResults)[x - 1];
            }
        }
        if (t == null) {
            t = this.service.tasks().getTask(pid);
        }
        if (t == null) {
            cmd.throwError(NutsMessage.cstyle((String)"task not found: %s", (Object[])new Object[]{pid}));
        }
        return t;
    }
}

