/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.njob;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.toolbox.njob.JobService;
import net.thevpc.nuts.toolbox.njob.NJobConfigStore;
import net.thevpc.nuts.toolbox.njob.model.NJob;
import net.thevpc.nuts.toolbox.njob.model.NJobGroup;
import net.thevpc.nuts.toolbox.njob.model.NProject;
import net.thevpc.nuts.toolbox.njob.time.TimePeriod;
import net.thevpc.nuts.toolbox.njob.time.TimePeriods;
import net.thevpc.nuts.toolbox.njob.time.TimespanPattern;
import net.thevpc.nuts.toolbox.njob.time.WeekDay;

public class NJobsSubService {
    private NutsApplicationContext context;
    private NJobConfigStore dal;
    private JobService service;

    public NJobsSubService(NutsApplicationContext context, NJobConfigStore dal, JobService service) {
        this.context = context;
        this.dal = dal;
        this.service = service;
    }

    public void addJob(NJob job) {
        NProject p;
        String project;
        if (job.getName() == null) {
            job.setName("work");
        }
        job.setCreationTime(Instant.now());
        job.setModificationTime(job.getCreationTime());
        if (job.getStartTime() == null) {
            Calendar c = Calendar.getInstance();
            c.set(14, 0);
            c.set(13, 0);
            c.set(12, 0);
            c.set(10, 8);
            job.setStartTime(c.getTime().toInstant());
        }
        if (job.getDuration() == null) {
            job.setDuration(new TimePeriod(1.0, ChronoUnit.HOURS));
        }
        if (job.getProject() == null) {
            job.setProject("misc");
        }
        if ((project = job.getProject()) != null && (p = this.service.projects().getProject(project)) == null) {
            if (this.service.isIdFormat(project)) {
                throw new NoSuchElementException("Project not found: " + project);
            }
            p = new NProject();
            p.setName(project);
            this.service.projects().addProject(p);
        }
        job.setId(null);
        this.dal.store(job);
    }

    public Stream<NJob> findWeekJobs(Instant date) {
        return this.findAllJobs().filter(x -> {
            WeekDay d0;
            WeekDay d = WeekDay.MONDAY;
            if (x.getProject() != null && (d0 = this.service.projects().getProject(x.getProject()).getStartWeekDay()) != null) {
                d = d0;
            }
            return this.service.getStartWeek(date, d).equals(this.service.getStartWeek(x.getStartTime(), d));
        });
    }

    public Stream<NJob> findLastJobs(Instant endTime, int lastCount, ChronoUnit lastUnit, Predicate<NJob> whereFilter, NJobGroup groupBy, ChronoUnit groupTimeUnit, TimespanPattern groupPattern) {
        Instant endTime0 = endTime == null ? Instant.now() : endTime;
        Stream<NJob> s = this.findAllJobs().filter(x -> {
            if (endTime != null && x.getStartTime().compareTo(endTime) > 0) {
                return false;
            }
            if (lastCount >= 0 && lastUnit != null) {
                LocalDate endDate = endTime0.atZone(ZoneId.systemDefault()).toLocalDate();
                LocalDate startDate = x.getStartTime().atZone(ZoneId.systemDefault()).toLocalDate();
                return lastCount <= 0 || lastUnit.between(startDate, endDate) <= (long)lastCount;
            }
            return true;
        }).sorted((o1, o2) -> -o1.getStartTime().compareTo(o2.getStartTime()));
        if (whereFilter != null) {
            s = s.filter(whereFilter);
        }
        if (lastUnit == null && lastCount > 0) {
            s = s.limit(lastCount);
        }
        if (groupBy != null) {
            s = s.collect(Collectors.groupingBy(NJobGroup.PROJECT_NAME.equals((Object)groupBy) ? x -> x.getProject() : (NJobGroup.NAME.equals((Object)groupBy) ? x -> x.getProject() + ":" + x.getName() : (NJobGroup.SUMMARY.equals((Object)groupBy) ? x -> "summary" : x -> x.getId())))).entrySet().stream().map(x -> this.groupJobs((Collection)x.getValue(), groupTimeUnit, groupPattern));
        }
        return s;
    }

    public void updateJob(NJob job) {
        NProject p;
        String project;
        if (job.getName() == null) {
            job.setName("work");
        }
        Instant now = Instant.now();
        if (job.getCreationTime() == null) {
            job.setCreationTime(now);
        }
        job.setModificationTime(now);
        if (job.getObservations() == null) {
            job.setObservations("");
        }
        if (job.getStartTime() == null) {
            // empty if block
        }
        if (job.getStartTime() == null) {
            Calendar c = Calendar.getInstance();
            c.set(14, 0);
            c.set(13, 0);
            c.set(12, 0);
            c.set(10, 8);
            job.setStartTime(c.getTime().toInstant());
        }
        if (job.getDuration() == null) {
            job.setDuration(new TimePeriod(1.0, ChronoUnit.HOURS));
        }
        if (job.getProject() == null) {
            job.setProject("misc");
        }
        if ((project = job.getProject()) != null && (p = this.service.projects().getProject(project)) == null) {
            if (this.service.isIdFormat(project)) {
                throw new NoSuchElementException("Project not found: " + project);
            }
            p = new NProject();
            p.setName(project);
            this.service.projects().addProject(p);
        }
        this.dal.store(job);
    }

    public Stream<NJob> tailWeekJobs(int count) {
        Instant w0 = this.service.getStartWeek(this.service.subWeek(count), WeekDay.SUNDAY);
        Instant w1 = this.service.getStartWeek(this.service.subWeek(count - 1), WeekDay.SUNDAY);
        return this.findAllJobs().filter(x -> x.getStartTime().compareTo(w0) >= 0 && x.getStartTime().compareTo(w1) < 0);
    }

    public NJob getJob(String jobId) {
        return this.dal.load(NJob.class, jobId);
    }

    public Stream<NJob> findMonthJobs(Instant date) {
        if (date == null) {
            date = Instant.now();
        }
        Instant finalDate = date;
        return this.findAllJobs().filter(x -> this.service.getStartMonth(finalDate).equals(this.service.getStartMonth(x.getStartTime())));
    }

    public NJob groupJobs(Collection<NJob> value, ChronoUnit timeUnit, TimespanPattern hoursPerDay) {
        return this.groupJobs(value.toArray(new NJob[0]), timeUnit, hoursPerDay);
    }

    public NJob groupJobs(NJob[] value, ChronoUnit timeUnit, TimespanPattern hoursPerDay) {
        NJob t = new NJob();
        TimePeriods tp = new TimePeriods();
        TreeSet<ChronoUnit> atu = new TreeSet<ChronoUnit>();
        TreeSet<String> names = new TreeSet<String>();
        TreeSet<String> projects = new TreeSet<String>();
        for (NJob nJob : value) {
            tp.add(nJob.getDuration());
            t.setStartTime(nJob.getStartTime());
            atu.add(nJob.getDuration().getUnit());
            names.add(nJob.getName());
            projects.add(nJob.getProject());
        }
        t.setProject(projects.size() == 0 ? "" : (projects.size() == 1 ? projects.toArray()[0].toString() : (projects.size() <= 3 || String.join((CharSequence)",", projects).length() < 20 ? String.join((CharSequence)",", projects) : String.valueOf(projects.size()) + " projects")));
        ChronoUnit[] atu0 = atu.toArray(new ChronoUnit[0]);
        String jobs = " Job" + (value.length == 1 ? "" : "s");
        String named = names.size() == 0 ? "" : (names.size() == 1 ? " named " + names.toArray()[0] : " with " + names.size() + " different names");
        t.setName(value.length + jobs + named);
        t.setDuration(tp.toUnit(timeUnit != null ? timeUnit : (atu0.length == 0 ? ChronoUnit.DAYS : atu0[0]), hoursPerDay));
        t.setId(UUID.randomUUID().toString());
        return t;
    }

    public boolean removeJob(String jobId) {
        long count = this.service.tasks().findAllTasks().filter(x -> jobId.equals(x.getJobId())).count();
        if (count > 1L) {
            throw new NutsIllegalArgumentException(this.context.getSession(), NutsMessage.cstyle((String)"job is used in %d tasks. It cannot be removed.", (Object[])new Object[]{count}));
        }
        if (count > 0L) {
            throw new NutsIllegalArgumentException(this.context.getSession(), NutsMessage.cstyle((String)"job is used in one task. It cannot be removed.", (Object[])new Object[0]));
        }
        return this.dal.delete(NJob.class, (Object)jobId);
    }

    public Stream<NJob> findAllJobs() {
        return this.dal.search(NJob.class);
    }
}

