/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.njob;

import java.time.Instant;
import java.util.Calendar;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.toolbox.njob.NJobConfigStore;
import net.thevpc.nuts.toolbox.njob.NJobsSubService;
import net.thevpc.nuts.toolbox.njob.NProjectsSubService;
import net.thevpc.nuts.toolbox.njob.NTasksSubService;
import net.thevpc.nuts.toolbox.njob.time.WeekDay;

public class JobService {
    private NutsApplicationContext context;
    private NJobConfigStore dal;
    private NJobsSubService jobs;
    private NTasksSubService tasks;
    private NProjectsSubService projects;

    public JobService(NutsApplicationContext context) {
        this.context = context;
        this.dal = new NJobConfigStore(context);
        this.jobs = new NJobsSubService(context, this.dal, this);
        this.tasks = new NTasksSubService(context, this.dal, this);
        this.projects = new NProjectsSubService(context, this.dal, this);
    }

    public static String wildcardToRegex(String pattern) {
        if (pattern == null) {
            pattern = "*";
        }
        char[] cc = pattern.toCharArray();
        StringBuilder sb = new StringBuilder("^");
        block5: for (int i = 0; i < cc.length; ++i) {
            char c = cc[i];
            switch (c) {
                case '$': 
                case '+': 
                case '.': 
                case '{': 
                case '}': {
                    sb.append('\\').append(c);
                    continue block5;
                }
                case '?': {
                    sb.append(".");
                    continue block5;
                }
                case '*': {
                    sb.append(".*");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append('$');
        return sb.toString();
    }

    public NJobsSubService jobs() {
        return this.jobs;
    }

    public NTasksSubService tasks() {
        return this.tasks;
    }

    public NProjectsSubService projects() {
        return this.projects;
    }

    public boolean isIdFormat(String s) {
        return s != null && s.matches("[0-9a-fA-F-]{36}");
    }

    public Instant getStartWeek(Instant date, WeekDay startWeekDay) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(date.toEpochMilli());
        int d = c.get(7);
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        int d0 = startWeekDay.ordinal() - WeekDay.SUNDAY.ordinal() + 1;
        if (d != d0) {
            c.add(6, d0 - d);
        }
        return Instant.ofEpochMilli(c.getTimeInMillis());
    }

    public Instant getStartMonth(Instant date) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(date.toEpochMilli());
        int d = c.get(7);
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        c.add(5, 1);
        return Instant.ofEpochMilli(c.getTimeInMillis());
    }

    public Instant subWeek(int weekIndex) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(Instant.now().toEpochMilli());
        int d = c.get(7);
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        c.add(7, -weekIndex);
        return Instant.ofEpochMilli(c.getTimeInMillis());
    }
}

