/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.njob;

import java.lang.reflect.Field;
import java.util.UUID;
import java.util.stream.Stream;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsFunction;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsUnsafeFunction;
import net.thevpc.nuts.toolbox.njob.model.Id;
import net.thevpc.nuts.toolbox.njob.model.NJob;
import net.thevpc.nuts.toolbox.njob.model.NProject;
import net.thevpc.nuts.toolbox.njob.model.NTask;

public class NJobConfigStore {
    private NutsApplicationContext context;
    private NutsElements json;
    private NutsPath dbPath;

    public NJobConfigStore(NutsApplicationContext applicationContext) {
        this.context = applicationContext;
        NutsSession session = applicationContext.getSession();
        this.json = NutsElements.of((NutsSession)session).json().setNtf(false);
        this.json.setCompact(false);
        this.dbPath = applicationContext.getVersionFolder(NutsStoreLocation.CONFIG, "0.8.0.0").resolve("db");
    }

    private Field getKeyField(Class o) {
        for (Field declaredField : o.getDeclaredFields()) {
            Id a = declaredField.getAnnotation(Id.class);
            if (a == null) continue;
            declaredField.setAccessible(true);
            return declaredField;
        }
        throw new RuntimeException("missing @Id field");
    }

    private Object getKey(Object o) {
        try {
            return this.getKeyField(o.getClass()).get(o);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String getEntityName(Class o) {
        return o.getSimpleName().toLowerCase();
    }

    private NutsPath getObjectFile(Object o) {
        return this.getFile(this.getEntityName(o.getClass()), this.getKey(o));
    }

    private NutsPath getFile(String entityName, Object id) {
        return this.dbPath.resolve(entityName).resolve(id + ".json");
    }

    public <T> Stream<T> search(Class<T> type) {
        NutsPath f = this.getFile(this.getEntityName(type), "any").getParent();
        NutsFunction parse = NutsFunction.of(x -> this.json.parse(x, type), (String)"parse");
        return f.list().filter(x -> x.isRegularFile() && x.getName().endsWith(".json"), "isRegularFile() && matches(*.json)").mapUnsafe((NutsUnsafeFunction)parse, null).filterNonNull().stream();
    }

    public <T> T load(Class<T> type, Object id) {
        NutsPath f = this.getFile(this.getEntityName(type), id);
        if (f.exists()) {
            return (T)this.json.parse(f, type);
        }
        return null;
    }

    public void store(Object o) {
        String ii;
        Object j;
        if (o instanceof NJob) {
            j = (NJob)o;
            String ii2 = ((NJob)j).getId();
            if (ii2 == null) {
                ((NJob)j).setId(this.generateId(NJob.class));
            }
        } else if (o instanceof NTask) {
            j = (NTask)o;
            String ii3 = ((NTask)j).getId();
            if (ii3 == null) {
                ((NTask)j).setId(this.generateId(NTask.class));
            }
        } else if (o instanceof NProject && (ii = ((NProject)(j = (NProject)o)).getId()) == null) {
            ((NProject)j).setId(this.generateId(NProject.class));
        }
        NutsPath objectFile = this.getObjectFile(o);
        objectFile.mkParentDirs();
        this.json.setValue(o).println(objectFile);
    }

    public String generateId(Class clz) {
        String nid;
        NutsPath f;
        do {
            nid = UUID.randomUUID().toString();
        } while ((f = this.getFile(this.getEntityName(clz), nid)).exists());
        return nid;
    }

    public boolean delete(Class entityName, Object id) {
        return this.delete(this.getEntityName(entityName), id);
    }

    public boolean delete(String entityName, Object id) {
        NutsPath f = this.getFile(entityName, id);
        if (f.exists()) {
            f.delete();
            return true;
        }
        return false;
    }
}

