/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.njob;

import java.time.Instant;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.toolbox.njob.JobService;
import net.thevpc.nuts.toolbox.njob.NJobConfigStore;
import net.thevpc.nuts.toolbox.njob.model.NJob;
import net.thevpc.nuts.toolbox.njob.model.NProject;
import net.thevpc.nuts.toolbox.njob.model.NTask;
import net.thevpc.nuts.toolbox.njob.time.WeekDay;

public class NProjectsSubService {
    private NutsApplicationContext context;
    private NJobConfigStore dal;
    private JobService service;

    public NProjectsSubService(NutsApplicationContext context, NJobConfigStore dal, JobService service) {
        this.context = context;
        this.dal = dal;
        this.service = service;
    }

    public void addProject(NProject p) {
        String name = p.getName();
        if (name == null) {
            throw new NutsIllegalArgumentException(this.context.getSession(), NutsMessage.cstyle((String)"invalid project", (Object[])new Object[0]));
        }
        p.setId(null);
        NProject p0 = this.getProject(name);
        if (p0 != null) {
            throw new NutsIllegalArgumentException(this.context.getSession(), NutsMessage.cstyle((String)"project already exists: %d", (Object[])new Object[]{name}));
        }
        if (p.getBeneficiary() == null) {
            p.setBeneficiary("unspecified");
        }
        if (p.getCompany() == null) {
            String t = this.findAllProjects().filter(x -> x.getBeneficiary().equals(p.getBeneficiary())).sorted(Comparator.comparing(NProject::getCreationTime).reversed()).map(x -> p.getBeneficiary()).findFirst().orElse(null);
            if (t == null) {
                t = p.getBeneficiary();
            }
            p.setCompany(t);
        }
        p.setCreationTime(Instant.now());
        p.setModificationTime(p.getCreationTime());
        if (p.getStartTime() == null) {
            p.setStartTime(Instant.now());
        }
        if (p.getStartWeekDay() == null) {
            p.setStartWeekDay(WeekDay.MONDAY);
        }
        this.dal.store(p);
    }

    public Stream<NProject> findAllProjects() {
        return this.dal.search(NProject.class);
    }

    public void updateProject(NProject p) {
        String name = p.getName();
        if (name == null) {
            throw new NutsIllegalArgumentException(this.context.getSession(), NutsMessage.cstyle((String)"invalid project", (Object[])new Object[0]));
        }
        String id = p.getId();
        if (id == null) {
            p.setId(this.dal.generateId(NProject.class));
        }
        if (p.getBeneficiary() == null) {
            p.setBeneficiary("unspecified");
        }
        if (p.getCompany() == null) {
            p.setCompany(p.getBeneficiary());
        }
        p.setModificationTime(Instant.now());
        if (p.getCreationTime() == null) {
            p.setCreationTime(p.getModificationTime());
        }
        if (p.getStartTime() == null) {
            p.setStartTime(Instant.now());
        }
        if (p.getStartWeekDay() == null) {
            p.setStartWeekDay(WeekDay.MONDAY);
        }
        this.dal.store(p);
    }

    public NProject getProjectOrError(String projectNameOrId) {
        NProject p = this.getProject(projectNameOrId);
        if (p == null) {
            throw new NutsIllegalArgumentException(this.context.getSession(), NutsMessage.cstyle((String)"project not found %s", (Object[])new Object[]{projectNameOrId}));
        }
        return p;
    }

    public NProject getProject(String projectNameOrId) {
        if (this.service.isIdFormat(projectNameOrId)) {
            return this.dal.load(NProject.class, projectNameOrId);
        }
        return this.findAllProjects().filter(x -> Objects.equals(x.getName(), projectNameOrId)).findFirst().orElse(null);
    }

    public boolean removeProject(String projectName) {
        long countJobs = this.service.jobs().findAllJobs().filter(x -> projectName.equals(x.getProject())).count();
        long countTasks = this.service.tasks().findAllTasks().filter(x -> projectName.equals(x.getProject())).count();
        if (countJobs > 0L || countTasks > 0L) {
            StringBuilder sb = new StringBuilder();
            if (countJobs > 0L) {
                sb.append(countJobs > 1L ? "one job" : countJobs + " jobs");
            }
            if (countTasks > 0L) {
                if (sb.length() > 0) {
                    sb.append(" and ");
                }
                sb.append(countTasks > 1L ? "one task" : countTasks + " task");
            }
            throw new NutsIllegalArgumentException(this.context.getSession(), NutsMessage.cstyle((String)"Project is used in %s. It cannot be removed.", (Object[])new Object[]{sb}));
        }
        return this.dal.delete(NProject.class, (Object)projectName);
    }

    public boolean isUsedProject(String id) {
        NProject destinationJob = this.getProject(id);
        if (destinationJob == null) {
            return false;
        }
        if (this.service.tasks().findAllTasks().filter(x -> Objects.equals(x.getProject(), destinationJob.getId()) || Objects.equals(x.getProject(), destinationJob.getName())).findFirst().orElse(null) != null) {
            return true;
        }
        return this.service.jobs().findAllJobs().filter(x -> Objects.equals(x.getProject(), destinationJob.getId()) || Objects.equals(x.getProject(), destinationJob.getName())).findFirst().orElse(null) != null;
    }

    public void mergeProjects(String destination, String ... others) {
        NProject destinationJob = this.getProjectOrError(destination);
        List src = Arrays.asList(others).stream().map(x -> this.getProjectOrError((String)x)).collect(Collectors.toList());
        for (NProject s : src) {
            this.service.tasks().findAllTasks().filter(x -> Objects.equals(x.getProject(), s.getId()) || Objects.equals(x.getProject(), s.getName())).forEach(t -> {
                t.setProject(destinationJob.getId());
                this.service.tasks().updateTask((NTask)t);
            });
            this.service.jobs().findAllJobs().filter(x -> Objects.equals(x.getProject(), s.getId()) || Objects.equals(x.getProject(), s.getName())).forEach(t -> {
                t.setProject(destinationJob.getId());
                this.service.jobs().updateJob((NJob)t);
            });
            this.removeProject(s.getId());
        }
    }

    public Stream<NProject> findProjects() {
        return this.findAllProjects();
    }
}

