/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.njob;

import java.io.InputStream;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsCommandAutoCompleteResolver;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCommandReadHighlighter;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.toolbox.njob.JobAutoCompleter;
import net.thevpc.nuts.toolbox.njob.JobService;
import net.thevpc.nuts.toolbox.njob.NJobsSubCmd;
import net.thevpc.nuts.toolbox.njob.NProjectsSubCmd;
import net.thevpc.nuts.toolbox.njob.NTasksSubCmd;
import net.thevpc.nuts.toolbox.njob.model.NFlag;
import net.thevpc.nuts.toolbox.njob.model.NPriority;
import net.thevpc.nuts.toolbox.njob.model.NProject;
import net.thevpc.nuts.toolbox.njob.model.NTaskStatus;
import net.thevpc.nuts.toolbox.njob.model.NTaskStatusFilter;
import net.thevpc.nuts.toolbox.njob.time.TimeFormatter;

public class JobServiceCmd {
    protected JobService service;
    protected NutsApplicationContext context;
    protected NutsWorkspace ws;
    private NJobsSubCmd jobs;
    private NTasksSubCmd tasks;
    private NProjectsSubCmd projects;

    public JobServiceCmd(NutsApplicationContext context) {
        this.context = context;
        this.service = new JobService(context);
        this.ws = context.getWorkspace();
        this.jobs = new NJobsSubCmd(this);
        this.tasks = new NTasksSubCmd(this);
        this.projects = new NProjectsSubCmd(this);
    }

    protected static String formatWithPrefix(Object value, String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        if (value == null) {
            value = "";
        }
        if (value instanceof Instant) {
            value = LocalDateTime.ofInstant((Instant)value, ZoneId.systemDefault());
        }
        return Arrays.stream(value.toString().split("(\n|\r\n)")).collect(Collectors.joining("\n" + prefix));
    }

    public static int parseIntOrFF(String s) {
        if (s == null || s.isEmpty()) {
            return -1;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public boolean runCommands(NutsCommandLine cmd) {
        if (this.projects.runProjectCommands(cmd)) {
            return true;
        }
        if (this.jobs.runJobCommands(cmd)) {
            return true;
        }
        if (this.tasks.runTaskCommands(cmd)) {
            return true;
        }
        if (cmd.next(new String[]{"summary"}) != null) {
            this.runSummary(cmd);
            return true;
        }
        if (cmd.next(new String[]{"help"}) != null) {
            int n = 0;
            String[] stringArray = new String[]{"jobs", "projects", "tasks"};
            int n2 = stringArray.length;
            if (n < n2) {
                String s = stringArray[n];
                if (cmd.isExecMode()) {
                    this.showCustomHelp("njob-" + s);
                }
                return true;
            }
            if (cmd.isExecMode()) {
                this.showCustomHelp("njob");
            }
            return true;
        }
        return false;
    }

    private void runSummary(NutsCommandLine cmd) {
        if (cmd.isExecMode()) {
            long projectsCount = this.service.projects().findProjects().count();
            long tasksCount = this.service.tasks().findTasks(NTaskStatusFilter.OPEN, null, -1, null, null, null, null, null).count();
            long jobsCount = this.service.jobs().findMonthJobs(null).count();
            long allJobsCount = this.service.jobs().findLastJobs(null, -1, null, null, null, null, null).count();
            NutsTextManager text = this.context.getWorkspace().text();
            this.context.getSession().out().printf("%s open task%s\n", new Object[]{text.forStyled("" + tasksCount, NutsTextStyle.primary1()), tasksCount == 1L ? "" : "s"});
            this.context.getSession().out().printf("%s job%s %s\n", new Object[]{text.forStyled("" + allJobsCount, NutsTextStyle.primary1()), allJobsCount == 1L ? "" : "s", allJobsCount == 0L ? "" : text.builder().append((Object)"(").append((Object)("" + jobsCount), NutsTextStyle.primary1()).append((Object)" this month)")});
            this.context.getSession().out().printf("%s project%s\n", new Object[]{text.forStyled("" + projectsCount, NutsTextStyle.primary1()), projectsCount == 1L ? "" : "s"});
        }
    }

    protected void showCustomHelp(String name) {
        NutsTextManager text = this.context.getWorkspace().text();
        this.context.getSession().out().println((NutsString)text.parser().parseResource("/net/thevpc/nuts/toolbox/" + name + ".ntf", text.parser().createLoader(this.getClass().getClassLoader())));
    }

    protected NutsString getFormattedProject(String projectName) {
        NutsTextBuilder builder = this.ws.text().builder();
        builder.getStyleGenerator().setIncludeForeground(true).setUsePaletteColors();
        return builder.appendHash((Object)projectName).immutable();
    }

    protected String getFormattedDate(Instant x) {
        if (x == null) {
            return "?";
        }
        return new TimeFormatter().format(x.atZone(ZoneId.systemDefault()).toLocalDateTime());
    }

    protected NutsString getCheckedString(Boolean x) {
        if (x == null) {
            return this.context.getWorkspace().text().forPlain("");
        }
        if (x.booleanValue()) {
            return this.context.getWorkspace().text().forPlain("\u2611");
        }
        return this.context.getWorkspace().text().forPlain("\u25a1");
    }

    protected NutsString getPriorityString(NPriority x) {
        if (x == null) {
            return this.context.getWorkspace().text().forPlain("N");
        }
        switch (x) {
            case NONE: {
                return this.ws.text().forStyled("0", NutsTextStyle.pale());
            }
            case LOW: {
                return this.ws.text().forStyled("L", NutsTextStyle.pale());
            }
            case NORMAL: {
                return this.ws.text().forPlain("N");
            }
            case MEDIUM: {
                return this.ws.text().forStyled("M", NutsTextStyle.primary1());
            }
            case URGENT: {
                return this.ws.text().forStyled("U", NutsTextStyle.primary2());
            }
            case HIGH: {
                return this.ws.text().forStyled("H", NutsTextStyle.primary3());
            }
            case CRITICAL: {
                return this.ws.text().forStyled("C", NutsTextStyle.fail());
            }
        }
        return this.context.getWorkspace().text().forPlain("?");
    }

    protected NutsString getStatusString(NTaskStatus x) {
        NutsTextManager text = this.context.getWorkspace().text();
        if (x == null) {
            return text.forPlain("*");
        }
        switch (x) {
            case TODO: {
                return text.forPlain("\u24c9");
            }
            case DONE: {
                return text.forStyled("\u2611", NutsTextStyle.success());
            }
            case WIP: {
                return text.forStyled("\u24cc", NutsTextStyle.primary1());
            }
            case CANCELLED: {
                return text.forStyled("\u2718", NutsTextStyle.fail());
            }
        }
        return text.forPlain("?");
    }

    private NutsString getFlagString(String x, int index) {
        switch (index) {
            case 1: {
                return this.ws.text().forStyled(x, NutsTextStyle.primary1());
            }
            case 2: {
                return this.ws.text().forStyled(x, NutsTextStyle.primary2());
            }
            case 3: {
                return this.ws.text().forStyled(x, NutsTextStyle.primary3());
            }
            case 4: {
                return this.ws.text().forStyled(x, NutsTextStyle.primary4());
            }
            case 5: {
                return this.ws.text().forStyled(x, NutsTextStyle.primary5());
            }
        }
        throw new NutsIllegalArgumentException(this.context.getSession(), NutsMessage.cstyle((String)"invalid index %s", (Object[])new Object[]{index}));
    }

    protected NutsString getFlagString(NFlag x) {
        if (x == null) {
            x = NFlag.NONE;
        }
        switch (x) {
            case NONE: {
                return this.context.getWorkspace().text().forPlain("\u2690");
            }
            case STAR1: {
                return this.getFlagString("\u2605", 1);
            }
            case STAR2: {
                return this.getFlagString("\u2605", 2);
            }
            case STAR3: {
                return this.getFlagString("\u2605", 3);
            }
            case STAR4: {
                return this.getFlagString("\u2605", 4);
            }
            case STAR5: {
                return this.getFlagString("\u2605", 5);
            }
            case FLAG1: {
                return this.getFlagString("\u2691", 1);
            }
            case FLAG2: {
                return this.getFlagString("\u2691", 2);
            }
            case FLAG3: {
                return this.getFlagString("\u2691", 3);
            }
            case FLAG4: {
                return this.getFlagString("\u2691", 4);
            }
            case FLAG5: {
                return this.getFlagString("\u2691", 5);
            }
            case KING1: {
                return this.getFlagString("\u265a", 1);
            }
            case KING2: {
                return this.getFlagString("\u265a", 2);
            }
            case KING3: {
                return this.getFlagString("\u265a", 3);
            }
            case KING4: {
                return this.getFlagString("\u265a", 4);
            }
            case KING5: {
                return this.getFlagString("\u265a", 5);
            }
            case HEART1: {
                return this.getFlagString("\u2665", 1);
            }
            case HEART2: {
                return this.getFlagString("\u2665", 2);
            }
            case HEART3: {
                return this.getFlagString("\u2665", 3);
            }
            case HEART4: {
                return this.getFlagString("\u2665", 4);
            }
            case HEART5: {
                return this.getFlagString("\u2665", 5);
            }
            case PHONE1: {
                return this.getFlagString("\u260e", 1);
            }
            case PHONE2: {
                return this.getFlagString("\u260e", 2);
            }
            case PHONE3: {
                return this.getFlagString("\u260e", 3);
            }
            case PHONE4: {
                return this.getFlagString("\u260e", 4);
            }
            case PHONE5: {
                return this.getFlagString("\u260e", 5);
            }
        }
        return this.context.getWorkspace().text().forPlain("[" + x.toString().toLowerCase() + "]");
    }

    protected <T> Predicate<T> appendPredicate(Predicate<T> whereFilter, Predicate<T> t) {
        whereFilter = whereFilter == null ? t : whereFilter.and(t);
        return whereFilter;
    }

    protected Predicate<String> createStringFilter(String s) {
        if (s.length() > 0 && s.startsWith("/") && s.endsWith("/")) {
            Pattern pattern = Pattern.compile(s);
            return x -> pattern.matcher(x == null ? "" : x).matches();
        }
        if (s.length() > 0 && s.contains("*")) {
            Pattern pattern = Pattern.compile(JobService.wildcardToRegex(s));
            return x -> pattern.matcher(x == null ? "" : x).matches();
        }
        return x -> s.equals(x == null ? "" : x);
    }

    public void runInteractive(NutsCommandLine cmdLine) {
        NutsSession session = this.context.getSession();
        this.context.getWorkspace().term().enableRichTerm();
        this.context.getWorkspace().term().getSystemTerminal().setCommandAutoCompleteResolver((NutsCommandAutoCompleteResolver)new JobAutoCompleter()).setCommandHistory(this.context.getWorkspace().commandLine().createHistory().setPath(Paths.get(this.context.getVarFolder(), new String[0]).resolve("njob-history.hist")).build()).setCommandReadHighlighter(new NutsCommandReadHighlighter(){

            public NutsText highlight(String buffer, NutsSession session) {
                return session.getWorkspace().text().forCode("sh", buffer).parse(session);
            }
        });
        this.context.getWorkspace().env().setProperty(JobServiceCmd.class.getName(), (Object)this);
        NutsTextManager text = this.context.getWorkspace().text();
        session.out().printf("%s interactive mode. type %s to quit.%n", new Object[]{text.forStyled(this.context.getAppId().getArtifactId() + " " + this.context.getAppId().getVersion(), NutsTextStyle.primary1()), text.forStyled("q", NutsTextStyle.error())});
        InputStream in = session.getTerminal().in();
        Throwable lastError = null;
        while (true) {
            String line = null;
            try {
                line = session.getTerminal().readLine("> ", new Object[0]);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            if (line == null) break;
            if (line.isEmpty()) continue;
            if (line.trim().equals("q") || line.trim().equals("quit") || line.trim().equals("exit")) break;
            if (line.trim().equals("err") || line.trim().equals("show-error") || line.trim().equals("show error")) {
                if (lastError == null) continue;
                lastError.printStackTrace(session.out().asPrintStream());
                continue;
            }
            NutsCommandLine cmd = this.ws.commandLine().parse(line);
            cmd.setCommandName(this.context.getAppId().getArtifactId());
            try {
                lastError = null;
                boolean b = this.runCommands(cmd);
                if (b) continue;
                session.out().println("```error command not found```");
            }
            catch (Exception ex) {
                lastError = ex;
                String m = ex.getMessage();
                if (m == null) {
                    m = ex.toString();
                }
                session.err().printf("```error ERROR: %s```\n", new Object[]{m});
            }
        }
    }

    public Predicate<String> createProjectFilter(String s) {
        if (this.service.isIdFormat(s)) {
            return this.createStringFilter(s);
        }
        Predicate<String> sp = this.createStringFilter(s);
        return x -> {
            NProject y = this.service.projects().getProject((String)x);
            return y != null && sp.test(y.getName());
        };
    }

    protected String createHashId(int value, int maxValues) {
        return "#" + value;
    }
}

