/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.njob.time;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.toolbox.njob.time.TimeParser;
import net.thevpc.nuts.toolbox.njob.time.TimePeriods;
import net.thevpc.nuts.toolbox.njob.time.TimespanPattern;

public class TimePeriod
implements Comparable<TimePeriod> {
    private static Pattern PATTERN = Pattern.compile("(?<val>[0-9]+([.][0-9]+)?)[ ]*(?<unit>([a-zA-Z]+))");
    private double count;
    private ChronoUnit unit;

    public TimePeriod(double count, ChronoUnit unit) {
        this.count = count;
        this.unit = unit;
    }

    public static Instant parseOpPeriodAsInstant(String str, Instant initial, boolean lenient) {
        if (str.startsWith("+")) {
            TimePeriod parse = TimePeriod.parse(str.substring(1), lenient);
            if (lenient) {
                return null;
            }
            return parse.addTo(initial, TimespanPattern.WORK);
        }
        if (str.startsWith("-")) {
            TimePeriod parse = TimePeriod.parse(str.substring(1), lenient);
            return parse.neg().addTo(initial, TimespanPattern.WORK);
        }
        return new TimeParser().parseInstant(str, lenient);
    }

    public static Predicate<TimePeriod> parseFilter(String s, boolean lenient) {
        if (s.endsWith(" ago")) {
            TimePeriod p = TimePeriod.parse(s.substring(0, s.length() - " ago".length()), lenient);
            if (p == null) {
                return null;
            }
            return x -> x != null && x.compareTo(p) >= 0;
        }
        if (s.startsWith(">=")) {
            TimePeriod p = TimePeriod.parse(s.substring(2), lenient);
            if (p == null) {
                return null;
            }
            return x -> x != null && x.compareTo(p) >= 0;
        }
        if (s.startsWith(">")) {
            TimePeriod p = TimePeriod.parse(s.substring(1), lenient);
            if (p == null) {
                return null;
            }
            return x -> x != null && x.compareTo(p) > 0;
        }
        if (s.startsWith("<=")) {
            TimePeriod p = TimePeriod.parse(s.substring(2), lenient);
            if (p == null) {
                return null;
            }
            return x -> x != null && x.compareTo(p) <= 0;
        }
        if (s.startsWith("<")) {
            TimePeriod p = TimePeriod.parse(s.substring(1), lenient);
            if (p == null) {
                return null;
            }
            return x -> x != null && x.compareTo(p) < 0;
        }
        TimePeriod p = TimePeriod.parse(s, lenient);
        if (p == null) {
            return null;
        }
        return x -> x != null && x.compareTo(p) == 0;
    }

    public static ChronoUnit parseUnit(String u, boolean lenient) {
        switch (u.toLowerCase()) {
            case "ns": 
            case "nanos": 
            case "nano": 
            case "nanosecond": 
            case "nanoseconds": {
                return ChronoUnit.NANOS;
            }
            case "ms": 
            case "milli": 
            case "millis": 
            case "millisecond": 
            case "milliseconds": {
                return ChronoUnit.MILLIS;
            }
            case "s": 
            case "sec": 
            case "secs": 
            case "second": 
            case "seconds": {
                return ChronoUnit.SECONDS;
            }
            case "mn": 
            case "min": 
            case "mins": 
            case "minute": 
            case "minutes": {
                return ChronoUnit.MINUTES;
            }
            case "h": 
            case "hour": 
            case "hours": {
                return ChronoUnit.HOURS;
            }
            case "d": 
            case "day": 
            case "days": {
                return ChronoUnit.DAYS;
            }
        }
        if (lenient) {
            return null;
        }
        throw new IllegalArgumentException("Unsupported time unit " + u);
    }

    public static TimePeriod parse(String str, boolean lenient) {
        Matcher matcher;
        if (str == null || str.trim().isEmpty()) {
            return null;
        }
        ChronoUnit defaultUnit = null;
        if (defaultUnit == null) {
            defaultUnit = ChronoUnit.MILLIS;
        }
        if ((matcher = PATTERN.matcher(str)).find()) {
            double unitCount = 0.0;
            try {
                unitCount = Double.parseDouble(matcher.group("val"));
            }
            catch (Exception ex) {
                if (lenient) {
                    return null;
                }
                throw new IllegalArgumentException("Invalid Time period " + matcher.group("val"));
            }
            if (unitCount < 0.0) {
                if (lenient) {
                    return null;
                }
                throw new IllegalArgumentException("Invalid Time period " + matcher.group("val"));
            }
            String u = matcher.group("unit");
            if (u == null) {
                u = "ms";
            }
            ChronoUnit unit = TimePeriod.parseUnit(u, lenient);
            return new TimePeriod(unitCount, unit);
        }
        if (lenient) {
            return null;
        }
        throw new IllegalArgumentException("Invalid Time period format " + str);
    }

    public TimePeriod neg() {
        if (this.count == 0.0) {
            return this;
        }
        return new TimePeriod(-this.count, this.unit);
    }

    public double getCount() {
        return this.count;
    }

    public ChronoUnit getUnit() {
        return this.unit;
    }

    public String toString() {
        String v = this.count == (double)((int)this.count) ? String.valueOf((int)this.count) : String.valueOf(this.count);
        switch (this.unit) {
            case DAYS: {
                return v + "d";
            }
            case HOURS: {
                return v + "h";
            }
            case MINUTES: {
                return v + "mn";
            }
            case SECONDS: {
                return v + "s";
            }
            case MILLIS: {
                return v + "ms";
            }
            case MICROS: {
                return v + "us";
            }
            case NANOS: {
                return v + "ns";
            }
        }
        return String.valueOf((int)this.count) + this.unit.toString().toLowerCase();
    }

    public TimePeriod toUnit(ChronoUnit u, TimespanPattern pattern) {
        double hoursPerDay = pattern.getHoursPerDay();
        switch (this.unit) {
            case DAYS: {
                switch (u) {
                    case DAYS: {
                        return this;
                    }
                    case HOURS: {
                        return new TimePeriod(hoursPerDay * this.count, ChronoUnit.HOURS);
                    }
                    case MINUTES: {
                        return new TimePeriod(this.count * 60.0 * hoursPerDay, ChronoUnit.MINUTES);
                    }
                    case SECONDS: {
                        return new TimePeriod(this.count * 3600.0 * hoursPerDay, ChronoUnit.SECONDS);
                    }
                    case MILLIS: {
                        return new TimePeriod(this.count * 3600000.0 * hoursPerDay, ChronoUnit.MILLIS);
                    }
                    case MICROS: {
                        return new TimePeriod(this.count * 3.6E9 * hoursPerDay, ChronoUnit.MICROS);
                    }
                    case NANOS: {
                        return new TimePeriod(this.count * 3.6E12 * hoursPerDay, ChronoUnit.NANOS);
                    }
                }
                break;
            }
            case HOURS: {
                switch (u) {
                    case DAYS: {
                        return new TimePeriod(this.count / hoursPerDay, ChronoUnit.DAYS);
                    }
                    case HOURS: {
                        return this;
                    }
                    case MINUTES: {
                        return new TimePeriod(this.count * 60.0, ChronoUnit.MINUTES);
                    }
                    case SECONDS: {
                        return new TimePeriod(this.count * 3600.0, ChronoUnit.SECONDS);
                    }
                    case MILLIS: {
                        return new TimePeriod(this.count * 3600000.0, ChronoUnit.MILLIS);
                    }
                    case MICROS: {
                        return new TimePeriod(this.count * 3.6E9, ChronoUnit.MICROS);
                    }
                    case NANOS: {
                        return new TimePeriod(this.count * 3.6E12, ChronoUnit.NANOS);
                    }
                }
                break;
            }
            case MINUTES: {
                switch (u) {
                    case DAYS: {
                        return new TimePeriod(this.count / 60.0 / hoursPerDay, ChronoUnit.DAYS);
                    }
                    case HOURS: {
                        return new TimePeriod(this.count / 60.0, ChronoUnit.HOURS);
                    }
                    case MINUTES: {
                        return this;
                    }
                    case SECONDS: {
                        return new TimePeriod(this.count * 60.0, ChronoUnit.SECONDS);
                    }
                    case MILLIS: {
                        return new TimePeriod(this.count * 60000.0, ChronoUnit.MILLIS);
                    }
                    case MICROS: {
                        return new TimePeriod(this.count * 6.0E7, ChronoUnit.MICROS);
                    }
                    case NANOS: {
                        return new TimePeriod(this.count * 6.0E10, ChronoUnit.NANOS);
                    }
                }
                break;
            }
            case SECONDS: {
                switch (u) {
                    case DAYS: {
                        return new TimePeriod(this.count / 3600.0 / hoursPerDay, ChronoUnit.DAYS);
                    }
                    case HOURS: {
                        return new TimePeriod(this.count / 3600.0, ChronoUnit.HOURS);
                    }
                    case MINUTES: {
                        return new TimePeriod(this.count / 60.0, ChronoUnit.MINUTES);
                    }
                    case SECONDS: {
                        return this;
                    }
                    case MILLIS: {
                        return new TimePeriod(this.count * 1000.0, ChronoUnit.MILLIS);
                    }
                    case MICROS: {
                        return new TimePeriod(this.count * 1000000.0, ChronoUnit.MICROS);
                    }
                    case NANOS: {
                        return new TimePeriod(this.count * 1.0E9, ChronoUnit.NANOS);
                    }
                }
                break;
            }
            case MILLIS: {
                switch (u) {
                    case DAYS: {
                        return new TimePeriod(this.count / 3600000.0 / hoursPerDay, ChronoUnit.DAYS);
                    }
                    case HOURS: {
                        return new TimePeriod(this.count / 3600000.0, ChronoUnit.HOURS);
                    }
                    case MINUTES: {
                        return new TimePeriod(this.count / 60000.0, ChronoUnit.MINUTES);
                    }
                    case SECONDS: {
                        return new TimePeriod(this.count / 1000.0, ChronoUnit.SECONDS);
                    }
                    case MILLIS: {
                        return this;
                    }
                    case MICROS: {
                        return new TimePeriod(this.count * 1000.0, ChronoUnit.MICROS);
                    }
                    case NANOS: {
                        return new TimePeriod(this.count * 1000000.0, ChronoUnit.NANOS);
                    }
                }
                break;
            }
            case MICROS: {
                switch (u) {
                    case DAYS: {
                        return new TimePeriod(this.count / 3.6E9 / hoursPerDay, ChronoUnit.DAYS);
                    }
                    case HOURS: {
                        return new TimePeriod(this.count / 3.6E9, ChronoUnit.HOURS);
                    }
                    case MINUTES: {
                        return new TimePeriod(this.count / 6.0E7, ChronoUnit.MINUTES);
                    }
                    case SECONDS: {
                        return new TimePeriod(this.count / 1000000.0, ChronoUnit.SECONDS);
                    }
                    case MILLIS: {
                        return new TimePeriod(this.count / 1000.0, ChronoUnit.MILLIS);
                    }
                    case MICROS: {
                        return this;
                    }
                    case NANOS: {
                        return new TimePeriod(this.count * 1000.0, ChronoUnit.NANOS);
                    }
                }
                break;
            }
            case NANOS: {
                switch (u) {
                    case DAYS: {
                        return new TimePeriod(this.count / 3.6E12 / hoursPerDay, ChronoUnit.DAYS);
                    }
                    case HOURS: {
                        return new TimePeriod(this.count / 3.6E12, ChronoUnit.HOURS);
                    }
                    case MINUTES: {
                        return new TimePeriod(this.count / 6.0E10, ChronoUnit.MINUTES);
                    }
                    case SECONDS: {
                        return new TimePeriod(this.count / 1.0E9, ChronoUnit.SECONDS);
                    }
                    case MILLIS: {
                        return new TimePeriod(this.count / 1000000.0, ChronoUnit.MILLIS);
                    }
                    case MICROS: {
                        return new TimePeriod(this.count / 1000.0, ChronoUnit.MICROS);
                    }
                    case NANOS: {
                        return this;
                    }
                }
            }
        }
        throw new IllegalArgumentException("Unsupported conversion");
    }

    @Override
    public int compareTo(TimePeriod p) {
        if (p == null) {
            return -1;
        }
        ChronoUnit t0 = this.getUnit();
        if (this.getUnit().compareTo(p.getUnit()) > 0) {
            t0 = p.getUnit();
        }
        return Double.compare(this.toUnit((ChronoUnit)t0, (TimespanPattern)TimespanPattern.DEFAULT).count, p.toUnit((ChronoUnit)t0, (TimespanPattern)TimespanPattern.DEFAULT).count);
    }

    public Instant addTo(Instant i, TimespanPattern pattern) {
        TimePeriod[] periodArray;
        block9: for (TimePeriod timePeriod : periodArray = this.toTimePeriods().getPeriodArray()) {
            switch (timePeriod.getUnit()) {
                case DAYS: {
                    i = i.plus((long)((int)timePeriod.getCount()), ChronoUnit.DAYS);
                    continue block9;
                }
                case HOURS: {
                    i = i.plus((long)((int)timePeriod.getCount()), ChronoUnit.HOURS);
                    continue block9;
                }
                case MINUTES: {
                    i = i.plus((long)((int)timePeriod.getCount()), ChronoUnit.MINUTES);
                    continue block9;
                }
                case SECONDS: {
                    i = i.plus((long)((int)timePeriod.getCount()), ChronoUnit.SECONDS);
                    continue block9;
                }
                case MILLIS: {
                    i = i.plus((long)((int)timePeriod.getCount()), ChronoUnit.MILLIS);
                    continue block9;
                }
                case MICROS: {
                    i = i.plus((long)((int)timePeriod.getCount()), ChronoUnit.MICROS);
                    continue block9;
                }
                case NANOS: {
                    i = i.plus((long)((int)timePeriod.getCount()), ChronoUnit.NANOS);
                }
            }
        }
        return i;
    }

    public TimePeriods toTimePeriods() {
        switch (this.unit) {
            case DAYS: {
                double c = this.count < 0.0 ? -this.count : this.count;
                int c0 = (int)c;
                double f = (c - (double)c0) * 24.0;
                TimePeriods s = new TimePeriods();
                s.add(c0, ChronoUnit.DAYS);
                if (f != 0.0) {
                    TimePeriods pp = new TimePeriod(f, ChronoUnit.MINUTES).toTimePeriods();
                    for (TimePeriod tt : Arrays.asList(pp.getPeriodArray())) {
                        if (c >= 0.0) {
                            s.add(tt);
                            continue;
                        }
                        s.add(tt.neg());
                    }
                }
                return s;
            }
            case HOURS: {
                double c = this.count < 0.0 ? -this.count : this.count;
                int c0 = (int)c;
                double f = (c - (double)c0) * 60.0;
                int d = c0 / 24;
                int h = c0 % 24;
                TimePeriods s = new TimePeriods();
                s.add(d, ChronoUnit.DAYS);
                s.add(h, ChronoUnit.HOURS);
                if (f != 0.0) {
                    TimePeriods pp = new TimePeriod(f, ChronoUnit.MINUTES).toTimePeriods();
                    for (TimePeriod tt : Arrays.asList(pp.getPeriodArray())) {
                        if (c >= 0.0) {
                            s.add(tt);
                            continue;
                        }
                        s.add(tt.neg());
                    }
                }
                return s;
            }
            case MINUTES: {
                double c = this.count < 0.0 ? -this.count : this.count;
                int c0 = (int)c;
                double f = (c - (double)c0) * 60.0;
                int d = c0 / 1440;
                int h = c0 % 1440 / 60;
                int mn = c0 % 60;
                TimePeriods s = new TimePeriods();
                s.add(d, ChronoUnit.DAYS);
                s.add(h, ChronoUnit.HOURS);
                s.add(mn, ChronoUnit.MINUTES);
                if (f != 0.0) {
                    TimePeriods pp = new TimePeriod(f, ChronoUnit.SECONDS).toTimePeriods();
                    for (TimePeriod tt : Arrays.asList(pp.getPeriodArray())) {
                        if (c >= 0.0) {
                            s.add(tt);
                            continue;
                        }
                        s.add(tt.neg());
                    }
                }
                return s;
            }
            case SECONDS: {
                double c = this.count < 0.0 ? -this.count : this.count;
                long c0 = (int)c;
                double f = (c - (double)c0) * 1000.0;
                int d = (int)(c0 / 86400L);
                int h = (int)(c0 % 86400L / 3600L);
                int mn = (int)(c0 % 3600L) / 60;
                int sec = (int)(c0 % 60L);
                TimePeriods s = new TimePeriods();
                s.add(d, ChronoUnit.DAYS);
                s.add(h, ChronoUnit.HOURS);
                s.add(mn, ChronoUnit.MINUTES);
                s.add(sec, ChronoUnit.SECONDS);
                if (f != 0.0) {
                    TimePeriods pp = new TimePeriod(f, ChronoUnit.MILLIS).toTimePeriods();
                    for (TimePeriod tt : Arrays.asList(pp.getPeriodArray())) {
                        if (c >= 0.0) {
                            s.add(tt);
                            continue;
                        }
                        s.add(tt.neg());
                    }
                }
                return s;
            }
            case MILLIS: {
                double c = this.count < 0.0 ? -this.count : this.count;
                long c0 = (int)c;
                double f = (c - (double)c0) * 1000.0;
                int d = (int)(c0 / 86400000L);
                int h = (int)(c0 % 86400000L / 3600000L);
                int mn = (int)(c0 % 3600000L) / 60000;
                int sec = (int)(c0 % 3600000L) / 1000;
                int msec = (int)(c0 % 1000L);
                TimePeriods s = new TimePeriods();
                s.add(d, ChronoUnit.DAYS);
                s.add(h, ChronoUnit.HOURS);
                s.add(mn, ChronoUnit.MINUTES);
                s.add(sec, ChronoUnit.SECONDS);
                s.add(msec, ChronoUnit.MILLIS);
                if (f != 0.0) {
                    TimePeriods pp = new TimePeriod(f, ChronoUnit.MICROS).toTimePeriods();
                    for (TimePeriod tt : Arrays.asList(pp.getPeriodArray())) {
                        if (c >= 0.0) {
                            s.add(tt);
                            continue;
                        }
                        s.add(tt.neg());
                    }
                }
                return s;
            }
            case MICROS: {
                double c = this.count < 0.0 ? -this.count : this.count;
                long c0 = (int)c;
                double f = (c - (double)c0) * 1000.0;
                int d = (int)(c0 / 86400000000L);
                int h = (int)(c0 % 86400000000L / 3600000000L);
                int mn = (int)(c0 % 3600000000L) / 60000000;
                int sec = (int)(c0 % 3600000000L) / 1000000;
                int msec = (int)(c0 % 1000000L) / 1000;
                int micsec = (int)(c0 % 1000L);
                TimePeriods s = new TimePeriods();
                s.add(d, ChronoUnit.DAYS);
                s.add(h, ChronoUnit.HOURS);
                s.add(mn, ChronoUnit.MINUTES);
                s.add(sec, ChronoUnit.SECONDS);
                s.add(msec, ChronoUnit.MILLIS);
                s.add(micsec, ChronoUnit.MICROS);
                if (f != 0.0) {
                    TimePeriods pp = new TimePeriod(f, ChronoUnit.NANOS).toTimePeriods();
                    for (TimePeriod tt : Arrays.asList(pp.getPeriodArray())) {
                        if (c >= 0.0) {
                            s.add(tt);
                            continue;
                        }
                        s.add(tt.neg());
                    }
                }
                return s;
            }
            case NANOS: {
                double c = this.count < 0.0 ? -this.count : this.count;
                long c0 = (int)c;
                int d = (int)(c0 / 86400000000000L);
                int h = (int)(c0 % 86400000000000L / 3600000000000L);
                int mn = (int)(c0 % 3600000000000L / 60000000000L);
                int sec = (int)(c0 % 3600000000L / 1000000000L);
                int msec = (int)(c0 % 1000000L) % 1000000;
                int micsec = (int)(c0 % 1000000L) / 1000;
                int nano = (int)(c0 % 1000L);
                TimePeriods s = new TimePeriods();
                s.add(d, ChronoUnit.DAYS);
                s.add(h, ChronoUnit.HOURS);
                s.add(mn, ChronoUnit.MINUTES);
                s.add(sec, ChronoUnit.SECONDS);
                s.add(msec, ChronoUnit.MILLIS);
                s.add(micsec, ChronoUnit.MICROS);
                s.add(nano, ChronoUnit.NANOS);
                return s;
            }
        }
        throw new IllegalArgumentException("Unsupported " + this.unit);
    }
}

