/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.njob;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsMutableTableModel;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.toolbox.njob.JobService;
import net.thevpc.nuts.toolbox.njob.JobServiceCmd;
import net.thevpc.nuts.toolbox.njob.model.NProject;
import net.thevpc.nuts.toolbox.njob.time.TimeParser;
import net.thevpc.nuts.toolbox.njob.time.WeekDay;

public class NProjectsSubCmd {
    private JobService service;
    private NutsApplicationContext context;
    private NutsWorkspace ws;
    private JobServiceCmd parent;

    public NProjectsSubCmd(JobServiceCmd parent) {
        this.parent = parent;
        this.context = parent.context;
        this.service = parent.service;
        this.ws = parent.ws;
    }

    public void runProjectAdd(NutsCommandLine cmd) {
        NProject t = new NProject();
        boolean list = false;
        boolean show = false;
        while (cmd.hasNext()) {
            NutsArgument a = cmd.peek();
            if (a.getStringKey().equals("--list") || a.getStringKey().equals("-l")) {
                list = cmd.nextBoolean(new String[0]).getBooleanValue();
                continue;
            }
            if (a.getStringKey().equals("--show") || a.getStringKey().equals("-s")) {
                show = cmd.nextBoolean(new String[0]).getBooleanValue();
                continue;
            }
            if (a.getStringKey().equals("-t") || a.getStringKey().equals("--start") || a.getStringKey().equals("--on")) {
                t.setStartTime(new TimeParser().parseInstant(cmd.nextString(new String[0]).getStringValue(), false));
                continue;
            }
            if (a.getStringKey().equals("--at")) {
                t.setStartTime(new TimeParser().setTimeOnly(true).parseInstant(cmd.nextString(new String[0]).getStringValue(), false));
                continue;
            }
            if (a.getStringKey().equals("-b") || a.getStringKey().equals("--beneficiary") || a.getStringKey().equals("--for")) {
                t.setBeneficiary(cmd.nextString(new String[0]).getStringValue());
                continue;
            }
            if (a.getStringKey().equals("-c") || a.getStringKey().equals("--company") || a.getStringKey().equals("--via")) {
                t.setCompany(cmd.nextString(new String[0]).getStringValue());
                continue;
            }
            if (a.getStringKey().equals("-1") || a.getStringKey().equals("--day1")) {
                t.setStartWeekDay(WeekDay.parse(cmd.nextString(new String[0]).getStringValue()));
                continue;
            }
            if (a.getStringKey().equals("-o") || a.getStringKey().equals("--obs")) {
                t.setObservations(cmd.nextString(new String[0]).getStringValue());
                continue;
            }
            if (a.isNonOption()) {
                if (t.getName() == null) {
                    t.setName(cmd.next().toString());
                    continue;
                }
                cmd.unexpectedArgument();
                continue;
            }
            cmd.unexpectedArgument();
        }
        if (cmd.isExecMode()) {
            this.service.projects().addProject(t);
            if (this.context.getSession().isPlainTrace()) {
                this.context.getSession().out().printf("project %s (%s) added.\n", new Object[]{this.context.getWorkspace().text().forStyled(t.getId(), NutsTextStyle.primary5()), t.getName()});
            }
            if (show) {
                this.runProjectShow(this.ws.commandLine().create(new String[]{t.getId()}));
            }
            if (list) {
                this.runProjectList(this.ws.commandLine().create(new String[0]));
            }
        }
    }

    public void runProjectUpdate(NutsCommandLine cmd) {
        ArrayList<NProject> projects = new ArrayList<NProject>();
        boolean list = false;
        boolean show = false;
        String mergeTo = null;
        ArrayList<Consumer<NProject>> runLater = new ArrayList<Consumer<NProject>>();
        block33: while (cmd.hasNext()) {
            NutsArgument a = cmd.peek();
            switch (a.getStringKey()) {
                case "-l": 
                case "--list": {
                    list = cmd.nextBoolean(new String[0]).getBooleanValue();
                    continue block33;
                }
                case "-s": 
                case "--show": {
                    show = cmd.nextBoolean(new String[0]).getBooleanValue();
                    continue block33;
                }
                case "--on": 
                case "--start": {
                    Object v = new TimeParser().parseInstant(cmd.nextString(new String[0]).getStringValue(), false);
                    runLater.add(arg_0 -> NProjectsSubCmd.lambda$runProjectUpdate$0((Instant)v, arg_0));
                    continue block33;
                }
                case "--at": {
                    Object v = new TimeParser().setTimeOnly(true).parseInstant(cmd.nextString(new String[0]).getStringValue(), false);
                    runLater.add(arg_0 -> NProjectsSubCmd.lambda$runProjectUpdate$1((Instant)v, arg_0));
                    continue block33;
                }
                case "--for": 
                case "--beneficiary": 
                case "-b": {
                    Object v = cmd.nextString(new String[0]).getStringValue();
                    runLater.add(arg_0 -> NProjectsSubCmd.lambda$runProjectUpdate$2((String)v, arg_0));
                    continue block33;
                }
                case "--company": 
                case "--via": 
                case "-c": {
                    Object v = cmd.nextString(new String[0]).getStringValue();
                    runLater.add(arg_0 -> NProjectsSubCmd.lambda$runProjectUpdate$3((String)v, arg_0));
                    continue block33;
                }
                case "--day1": 
                case "-1": {
                    Object v = WeekDay.parse(cmd.nextString(new String[0]).getStringValue());
                    runLater.add(arg_0 -> NProjectsSubCmd.lambda$runProjectUpdate$4((WeekDay)((Object)v), arg_0));
                    continue block33;
                }
                case "--obs": 
                case "-o": {
                    Object v = cmd.nextString(new String[0]).getStringValue();
                    runLater.add(arg_0 -> NProjectsSubCmd.lambda$runProjectUpdate$5((String)v, arg_0));
                    continue block33;
                }
                case "--merge-to": {
                    NutsArgument c = cmd.nextString(new String[0]);
                    if (!c.isEnabled()) continue block33;
                    if (mergeTo != null) {
                        cmd.pushBack(c);
                        cmd.unexpectedArgument();
                        continue block33;
                    }
                    mergeTo = c.getStringValue();
                    continue block33;
                }
                case "++obs": 
                case "+o": {
                    Object v = cmd.nextString(new String[0]).getStringValue();
                    runLater.add(arg_0 -> NProjectsSubCmd.lambda$runProjectUpdate$6((String)v, arg_0));
                    continue block33;
                }
            }
            if (a.isNonOption()) {
                String pid = cmd.next().toString();
                NProject nProject = this.findProject(pid, cmd);
                projects.add(nProject);
                continue;
            }
            cmd.unexpectedArgument();
        }
        if (projects.isEmpty()) {
            cmd.throwError(NutsMessage.formatted((String)"project name expected"));
        }
        if (cmd.isExecMode()) {
            NutsTextManager text = this.context.getWorkspace().text();
            for (NProject project : projects) {
                for (Consumer consumer : runLater) {
                    consumer.accept(project);
                }
                this.service.projects().updateProject(project);
                if (!this.context.getSession().isPlainTrace()) continue;
                this.context.getSession().out().printf("project %s (%s) updated.\n", new Object[]{text.forStyled(project.getId(), NutsTextStyle.primary5()), text.forStyled(project.getName(), NutsTextStyle.primary1())});
            }
            if (mergeTo != null) {
                this.service.projects().mergeProjects(mergeTo, (String[])projects.stream().map(x -> x.getId()).toArray(String[]::new));
                if (this.context.getSession().isPlainTrace()) {
                    this.context.getSession().out().printf("projects merged to %s.\n", new Object[]{this.context.getWorkspace().text().forStyled(mergeTo, NutsTextStyle.primary5())});
                }
            }
            if (show) {
                for (NProject t : new LinkedHashSet(projects)) {
                    this.runProjectShow(this.ws.commandLine().create(new String[]{t.getId()}));
                }
            }
            if (list) {
                this.runProjectList(this.ws.commandLine().create(new String[0]));
            }
        }
    }

    private void runProjectList(NutsCommandLine cmd) {
        Predicate<NProject> whereFilter = null;
        block19: while (cmd.hasNext()) {
            NutsArgument a = cmd.peek();
            switch (a.getStringKey()) {
                case "-b": 
                case "-beneficiary": {
                    String s = cmd.nextString(new String[0]).getStringValue();
                    Predicate<String> sp = this.parent.createStringFilter(s);
                    Predicate<NProject> t = x -> sp.test(x.getBeneficiary());
                    whereFilter = this.parent.appendPredicate(whereFilter, t);
                    continue block19;
                }
                case "-c": 
                case "-company": {
                    String s = cmd.nextString(new String[0]).getStringValue();
                    Predicate<String> sp = this.parent.createStringFilter(s);
                    Predicate<NProject> t = x -> sp.test(x.getCompany());
                    whereFilter = this.parent.appendPredicate(whereFilter, t);
                    continue block19;
                }
                case "-n": 
                case "--name": {
                    String s = cmd.nextString(new String[0]).getStringValue();
                    Predicate<String> sp = this.parent.createStringFilter(s);
                    Predicate<NProject> t = x -> sp.test(x.getName());
                    whereFilter = this.parent.appendPredicate(whereFilter, t);
                    continue block19;
                }
                case "--unused": {
                    boolean unused = cmd.nextBoolean(new String[0]).getBooleanValue();
                    Predicate<Object> t = x -> this.service.projects().isUsedProject(x.getId()) != unused;
                    whereFilter = this.parent.appendPredicate(whereFilter, t);
                    continue block19;
                }
                case "-t": 
                case "--startTime": 
                case "--start-time": {
                    String s = cmd.nextString(new String[0]).getStringValue();
                    Predicate<Object> t = new TimeParser().parseInstantFilter(s, false);
                    whereFilter = this.parent.appendPredicate(whereFilter, x -> t.test(x.getStartTime()));
                    continue block19;
                }
            }
            cmd.unexpectedArgument();
        }
        if (cmd.isExecMode()) {
            Stream<NProject> r = this.service.projects().findProjects().filter(whereFilter == null ? x -> true : whereFilter).sorted((x, y) -> {
                Instant s1 = x.getStartTime();
                Instant s2 = y.getStartTime();
                int v = s2.compareTo(s1);
                if (v != 0) {
                    return v;
                }
                return x.getName().compareTo(y.getName());
            });
            if (this.context.getSession().isPlainTrace()) {
                NutsMutableTableModel m = this.ws.formats().table().createModel();
                ArrayList lastResults = new ArrayList();
                int[] index = new int[1];
                r.forEach(x -> {
                    Instant st = x.getStartTime();
                    String sts = "";
                    if (st != null) {
                        LocalDateTime d = LocalDateTime.ofInstant(st, ZoneId.systemDefault());
                        sts = d.getYear() + " " + d.getMonth().toString().toLowerCase().substring(0, 3);
                    }
                    lastResults.add(x);
                    index[0] = index[0] + 1;
                    m.newRow().addCells(new Object[]{this.parent.createHashId(index[0], -1), x.getId(), sts, x.getCompany(), x.getBeneficiary(), this.parent.getFormattedProject(x.getName() == null ? "*" : x.getName())});
                });
                this.context.getSession().setProperty("LastResults", (Object)lastResults.toArray(new NProject[0]));
                this.ws.formats().table().setBorder("spaces").setValue((Object)m).println(this.context.getSession().out());
            } else {
                this.context.getSession().getWorkspace().formats().object(r.collect(Collectors.toList())).print(this.context.getSession().out());
            }
        }
    }

    private void runProjectRemove(NutsCommandLine cmd) {
        NutsTextManager text = this.context.getWorkspace().text();
        while (cmd.hasNext()) {
            NutsArgument a = cmd.next();
            if (!cmd.isExecMode()) continue;
            NProject t = this.findProject(a.toString(), cmd);
            if (this.service.projects().removeProject(t.getId())) {
                if (!this.context.getSession().isPlainTrace()) continue;
                this.context.getSession().out().printf("project %s removed.\n", new Object[]{text.forStyled(a.toString(), NutsTextStyle.primary5())});
                continue;
            }
            this.context.getSession().out().printf("project %s %s.\n", new Object[]{text.forStyled(a.toString(), NutsTextStyle.primary5()), text.forStyled("not found", NutsTextStyle.error())});
        }
    }

    private void runProjectShow(NutsCommandLine cmd) {
        while (cmd.hasNext()) {
            NutsArgument a = cmd.next();
            NProject project = this.findProject(a.toString(), cmd);
            if (project == null) {
                this.context.getSession().out().printf("```kw %s```: ```error not found```.\n", new Object[]{a.toString()});
                continue;
            }
            this.context.getSession().out().printf("```kw %s```:\n", new Object[]{project.getId()});
            String prefix = "\t                    ";
            Object[] objectArray = new Object[1];
            objectArray[0] = JobServiceCmd.formatWithPrefix(project.getName(), prefix);
            this.context.getSession().out().printf("\t```kw2 project name```  : %s\n", objectArray);
            Object[] objectArray2 = new Object[1];
            objectArray2[0] = JobServiceCmd.formatWithPrefix(project.getBeneficiary(), prefix);
            this.context.getSession().out().printf("\t```kw2 beneficiary```   : %s\n", objectArray2);
            Object[] objectArray3 = new Object[1];
            objectArray3[0] = JobServiceCmd.formatWithPrefix(project.getCompany(), prefix);
            this.context.getSession().out().printf("\t```kw2 company```       : %s\n", objectArray3);
            Object[] objectArray4 = new Object[1];
            objectArray4[0] = JobServiceCmd.formatWithPrefix(project.getStartTime(), prefix);
            this.context.getSession().out().printf("\t```kw2 start time```    : %s\n", objectArray4);
            Object[] objectArray5 = new Object[1];
            objectArray5[0] = JobServiceCmd.formatWithPrefix((Object)project.getStartWeekDay(), prefix);
            this.context.getSession().out().printf("\t```kw2 start week day```: %s\n", objectArray5);
            Object[] objectArray6 = new Object[1];
            objectArray6[0] = JobServiceCmd.formatWithPrefix(project.getObservations(), prefix);
            this.context.getSession().out().printf("\t```kw2 observations```  : %s\n", objectArray6);
        }
    }

    private NProject findProject(String pid, NutsCommandLine cmd) {
        NProject t = null;
        if (pid.startsWith("#")) {
            Object lastResults;
            int x = JobServiceCmd.parseIntOrFF(pid.substring(1));
            if (x >= 1 && (lastResults = this.context.getSession().getProperty("LastResults")) instanceof NProject[] && x <= ((NProject[])lastResults).length) {
                t = ((NProject[])lastResults)[x - 1];
            }
        }
        if (t == null) {
            t = this.service.projects().getProject(pid);
        }
        if (t == null) {
            cmd.throwError(NutsMessage.cstyle((String)"project not found: %s", (Object[])new Object[]{pid}));
        }
        return t;
    }

    public boolean runProjectCommands(NutsCommandLine cmd) {
        if (cmd.next(new String[]{"ap", "a p", "pa", "p a", "add project", "projects add"}) != null) {
            this.runProjectAdd(cmd);
            return true;
        }
        if (cmd.next(new String[]{"pu", "up", "p u", "u p", "update project", "projects update"}) != null) {
            this.runProjectUpdate(cmd);
            return true;
        }
        if (cmd.next(new String[]{"lp", "pl", "l p", "p l", "list projects", "projects list"}) != null) {
            this.runProjectList(cmd);
            return true;
        }
        if (cmd.next(new String[]{"rp", "rmp", "pr", "prm", "r p", "rm p", "p r", "p rm", "remove project", "remove projects", "rm project", "rm projects", "projects remove"}) != null) {
            this.runProjectRemove(cmd);
            return true;
        }
        if (cmd.next(new String[]{"ps", "sp", "s p", "p s", "show project", "show projects", "projects show"}) != null) {
            this.runProjectShow(cmd);
            return true;
        }
        if (cmd.next(new String[]{"p", "projects"}) != null) {
            if (cmd.next(new String[]{"--help"}) != null) {
                this.parent.showCustomHelp("njob-projects");
            } else {
                this.runProjectList(cmd);
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void lambda$runProjectUpdate$6(String v, NProject t) {
        String s = t.getObservations();
        if (s == null) {
            s = "";
        }
        if (!(s = s.trim()).isEmpty()) {
            s = s + "\n";
        }
        s = s + v;
        s = s.trim();
        t.setObservations(s);
    }

    private static /* synthetic */ void lambda$runProjectUpdate$5(String v, NProject t) {
        t.setObservations(v);
    }

    private static /* synthetic */ void lambda$runProjectUpdate$4(WeekDay v, NProject t) {
        t.setStartWeekDay(v);
    }

    private static /* synthetic */ void lambda$runProjectUpdate$3(String v, NProject t) {
        t.setCompany(v);
    }

    private static /* synthetic */ void lambda$runProjectUpdate$2(String v, NProject t) {
        t.setBeneficiary(v);
    }

    private static /* synthetic */ void lambda$runProjectUpdate$1(Instant v, NProject t) {
        t.setStartTime(v);
    }

    private static /* synthetic */ void lambda$runProjectUpdate$0(Instant v, NProject t) {
        t.setStartTime(v);
    }
}

