/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.njob;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsMutableTableModel;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyled;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.toolbox.njob.JobService;
import net.thevpc.nuts.toolbox.njob.JobServiceCmd;
import net.thevpc.nuts.toolbox.njob.model.NJob;
import net.thevpc.nuts.toolbox.njob.model.NJobGroup;
import net.thevpc.nuts.toolbox.njob.model.NProject;
import net.thevpc.nuts.toolbox.njob.time.TimeParser;
import net.thevpc.nuts.toolbox.njob.time.TimePeriod;
import net.thevpc.nuts.toolbox.njob.time.TimespanPattern;

public class NJobsSubCmd {
    private JobService service;
    private NutsApplicationContext context;
    private NutsWorkspace ws;
    private JobServiceCmd parent;

    public NJobsSubCmd(JobServiceCmd parent) {
        this.parent = parent;
        this.context = parent.context;
        this.service = parent.service;
        this.ws = parent.ws;
    }

    public void runJobAdd(NutsCommandLine cmd) {
        NJob t = new NJob();
        boolean list = false;
        boolean show = false;
        block27: while (cmd.hasNext()) {
            NutsArgument a = cmd.peek();
            switch (a.getStringKey()) {
                case "--list": 
                case "-l": {
                    list = cmd.nextBoolean(new String[0]).getBooleanValue();
                    continue block27;
                }
                case "--show": 
                case "-s": {
                    show = cmd.nextBoolean(new String[0]).getBooleanValue();
                    continue block27;
                }
                case "--time": 
                case "--on": 
                case "--start": 
                case "-t": {
                    t.setStartTime(new TimeParser().parseInstant(cmd.nextString(new String[0]).getStringValue(), false));
                    continue block27;
                }
                case "--at": {
                    t.setStartTime(new TimeParser().setTimeOnly(true).parseInstant(cmd.nextString(new String[0]).getStringValue(), false));
                    continue block27;
                }
                case "--for": 
                case "--project": 
                case "-p": {
                    t.setProject(cmd.nextString(new String[0]).getStringValue());
                    continue block27;
                }
                case "--obs": 
                case "-o": {
                    t.setObservations(cmd.nextString(new String[0]).getStringValue());
                    continue block27;
                }
                case "--duration": 
                case "-d": {
                    t.setDuration(TimePeriod.parse(cmd.nextString(new String[0]).getStringValue(), false));
                    continue block27;
                }
            }
            if (a.isNonOption()) {
                if (t.getName() == null) {
                    t.setName(cmd.next().toString());
                    continue;
                }
                cmd.unexpectedArgument();
                continue;
            }
            cmd.unexpectedArgument();
        }
        if (cmd.isExecMode()) {
            this.service.jobs().addJob(t);
            if (this.context.getSession().isPlainTrace()) {
                this.context.getSession().out().printf("job %s (%s) added.\n", new Object[]{this.context.getWorkspace().text().forStyled(t.getId(), NutsTextStyle.primary5()), t.getName()});
            }
            if (show) {
                this.runJobShow(this.ws.commandLine().create(new String[]{t.getId()}));
            }
            if (list) {
                this.runJobList(this.ws.commandLine().create(new String[0]));
            }
        }
    }

    public void runJobUpdate(NutsCommandLine cmd) {
        ArrayList<NJob> jobs = new ArrayList<NJob>();
        boolean list = false;
        boolean show = false;
        ArrayList<Consumer<NJob>> runLater = new ArrayList<Consumer<NJob>>();
        block33: while (cmd.hasNext()) {
            NutsArgument a = cmd.peek();
            switch (a.getStringKey()) {
                case "--list": 
                case "-l": {
                    list = cmd.nextBoolean(new String[0]).getBooleanValue();
                    continue block33;
                }
                case "--show": 
                case "-s": {
                    show = cmd.nextBoolean(new String[0]).getBooleanValue();
                    continue block33;
                }
                case "--start": {
                    Instant instant = new TimeParser().parseInstant(cmd.nextString(new String[0]).getStringValue(), false);
                    runLater.add(t -> t.setStartTime(instant));
                    continue block33;
                }
                case "-t": 
                case "--on": {
                    String string = cmd.nextString(new String[0]).getStringValue();
                    runLater.add(t -> t.setStartTime(TimePeriod.parseOpPeriodAsInstant(string, t.getStartTime(), true)));
                    continue block33;
                }
                case "--at": {
                    Instant instant = new TimeParser().setTimeOnly(true).parseInstant(cmd.nextString(new String[0]).getStringValue(), false);
                    runLater.add(t -> t.setStartTime(instant));
                    continue block33;
                }
                case "-d": 
                case "--duration": {
                    TimePeriod timePeriod = TimePeriod.parse(cmd.nextString(new String[0]).getStringValue(), false);
                    runLater.add(t -> t.setDuration(timePeriod));
                    continue block33;
                }
                case "-n": 
                case "--name": {
                    String string = cmd.nextString(new String[0]).getStringValue();
                    runLater.add(t -> t.setName(string));
                    continue block33;
                }
                case "-p": 
                case "--project": {
                    String string = cmd.nextString(new String[0]).getStringValue();
                    runLater.add(t -> t.setProject(string));
                    continue block33;
                }
                case "-o": 
                case "--obs": {
                    String string = cmd.nextString(new String[0]).getStringValue();
                    runLater.add(t -> t.setObservations(string));
                    continue block33;
                }
                case "-o+": 
                case "--obs+": 
                case "+obs": {
                    String string = cmd.nextString(new String[0]).getStringValue();
                    runLater.add(t -> {
                        String s = t.getObservations();
                        if (s == null) {
                            s = "";
                        }
                        if (!(s = s.trim()).isEmpty()) {
                            s = s + "\n";
                        }
                        s = s + string;
                        s = s.trim();
                        t.setObservations(s);
                    });
                    continue block33;
                }
            }
            if (a.isNonOption()) {
                NJob nJob = this.findJob(cmd.next().toString(), cmd);
                jobs.add(nJob);
                continue;
            }
            cmd.unexpectedArgument();
        }
        if (jobs.isEmpty()) {
            cmd.throwError(NutsMessage.formatted((String)"job id expected"));
        }
        if (cmd.isExecMode()) {
            for (NJob job : jobs) {
                for (Consumer consumer : runLater) {
                    consumer.accept(job);
                }
            }
            NutsTextManager text = this.context.getWorkspace().text();
            for (NJob job : new LinkedHashSet(jobs)) {
                this.service.jobs().updateJob(job);
                if (!this.context.getSession().isPlainTrace()) continue;
                this.context.getSession().out().printf("job %s (%s) updated.\n", new Object[]{text.forStyled(job.getId(), NutsTextStyle.primary5()), text.forStyled(job.getName(), NutsTextStyle.primary1())});
            }
            if (show) {
                for (NJob t2 : new LinkedHashSet(jobs)) {
                    this.runJobList(this.ws.commandLine().create(new String[]{t2.getId()}));
                }
            }
            if (list) {
                this.runJobList(this.ws.commandLine().create(new String[0]));
            }
        }
    }

    public boolean runJobCommands(NutsCommandLine cmd) {
        if (cmd.next(new String[]{"aj", "ja", "a j", "j a", "add job", "jobs add"}) != null) {
            this.runJobAdd(cmd);
            return true;
        }
        if (cmd.next(new String[]{"lj", "jl", "l j", "j l", "list jobs", "jobs list"}) != null) {
            this.runJobList(cmd);
            return true;
        }
        if (cmd.next(new String[]{"rj", "jr", "jrm", "rmj", "j rm", "rm j", "j r", "r j", "remove job", "remove jobs", "jobs remove"}) != null) {
            this.runJobRemove(cmd);
            return true;
        }
        if (cmd.next(new String[]{"uj", "ju", "j u", "u j", "update job", "update jobs", "jobs update", "jobs update"}) != null) {
            this.runJobUpdate(cmd);
            return true;
        }
        if (cmd.next(new String[]{"js", "sj", "j s", "s j", "show job", "show jobs", "jobs show"}) != null) {
            this.runJobShow(cmd);
            return true;
        }
        if (cmd.next(new String[]{"j", "jobs"}) != null) {
            if (cmd.next(new String[]{"--help"}) != null) {
                this.parent.showCustomHelp("njob-jobs");
            } else {
                this.runJobList(cmd);
            }
            return true;
        }
        return false;
    }

    private void runJobRemove(NutsCommandLine cmd) {
        NutsTextManager text = this.context.getWorkspace().text();
        while (cmd.hasNext()) {
            NutsArgument a = cmd.next();
            NJob t = this.findJob(a.toString(), cmd);
            if (!cmd.isExecMode()) continue;
            if (this.service.jobs().removeJob(t.getId())) {
                if (!this.context.getSession().isPlainTrace()) continue;
                this.context.getSession().out().printf("job %s removed.\n", new Object[]{text.forStyled(a.toString(), NutsTextStyle.primary5())});
                continue;
            }
            this.context.getSession().out().printf("job %s %s.\n", new Object[]{text.forStyled(a.toString(), NutsTextStyle.primary5()), text.forStyled("not found", NutsTextStyle.error())});
        }
    }

    private void runJobShow(NutsCommandLine cmd) {
        while (cmd.hasNext()) {
            NutsArgument a = cmd.next();
            if (!cmd.isExecMode()) continue;
            NJob job = this.findJob(a.toString(), cmd);
            if (job == null) {
                this.context.getSession().out().printf("```kw %s```: ```error not found```.\n", new Object[]{a.toString()});
                continue;
            }
            this.context.getSession().out().printf("```kw %s```:\n", new Object[]{job.getId()});
            String prefix = "\t                    ";
            Object[] objectArray = new Object[1];
            objectArray[0] = JobServiceCmd.formatWithPrefix(job.getName(), prefix);
            this.context.getSession().out().printf("\t```kw2 job name```      : %s:\n", objectArray);
            String project = job.getProject();
            NProject p = this.service.projects().getProject(project);
            if (project == null || project.length() == 0) {
                this.context.getSession().out().printf("\t```kw2 project```       : %s\n", new Object[]{""});
            } else {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = project;
                objectArray2[1] = JobServiceCmd.formatWithPrefix(p == null ? "?" : p.getName(), prefix);
                this.context.getSession().out().printf("\t```kw2 project```       : %s (%s)\n", objectArray2);
            }
            Object[] objectArray3 = new Object[1];
            objectArray3[0] = JobServiceCmd.formatWithPrefix(job.getDuration(), prefix);
            this.context.getSession().out().printf("\t```kw2 duration```      : %s\n", objectArray3);
            Object[] objectArray4 = new Object[1];
            objectArray4[0] = JobServiceCmd.formatWithPrefix(job.getStartTime(), prefix);
            this.context.getSession().out().printf("\t```kw2 start time```    : %s\n", objectArray4);
            Object[] objectArray5 = new Object[1];
            objectArray5[0] = JobServiceCmd.formatWithPrefix(job.getInternalDuration(), prefix);
            this.context.getSession().out().printf("\t```kw2 duration extra```: %s\n", objectArray5);
            Object[] objectArray6 = new Object[1];
            objectArray6[0] = JobServiceCmd.formatWithPrefix(job.getObservations(), prefix);
            this.context.getSession().out().printf("\t```kw2 observations```  : %s\n", objectArray6);
        }
    }

    private void runJobList(NutsCommandLine cmd) {
        TimespanPattern hoursPerDay = TimespanPattern.WORK;
        int count = 100;
        NJobGroup groupBy = null;
        ChronoUnit countType = null;
        ChronoUnit timeUnit = null;
        Predicate<NJob> whereFilter = null;
        while (cmd.hasNext()) {
            NutsArgument a = cmd.peek();
            block26 : switch (a.getStringKey()) {
                case "-w": 
                case "--weeks": {
                    countType = ChronoUnit.WEEKS;
                    count = cmd.nextString(new String[0]).getIntValue();
                    break;
                }
                case "-m": 
                case "--months": {
                    countType = ChronoUnit.MONTHS;
                    count = cmd.nextString(new String[0]).getIntValue();
                    break;
                }
                case "-l": {
                    countType = null;
                    count = cmd.nextString(new String[0]).getIntValue();
                    break;
                }
                case "-u": 
                case "--unit": {
                    timeUnit = TimePeriod.parseUnit(cmd.nextString(new String[0]).getStringValue(), false);
                    break;
                }
                case "-g": 
                case "--group": 
                case "--groupBy": 
                case "--groupby": 
                case "--group-by": {
                    NutsArgument y = cmd.nextString(new String[0]);
                    switch (y.getStringValue()) {
                        case "p": 
                        case "project": {
                            groupBy = NJobGroup.PROJECT_NAME;
                            break block26;
                        }
                        case "n": 
                        case "name": {
                            groupBy = NJobGroup.NAME;
                            break block26;
                        }
                        case "s": 
                        case "summary": {
                            groupBy = NJobGroup.SUMMARY;
                            break block26;
                        }
                    }
                    cmd.pushBack(y).unexpectedArgument(NutsMessage.cstyle((String)"invalid value", (Object[])new Object[0]));
                    break;
                }
                case "-p": 
                case "--project": {
                    String s = cmd.nextString(new String[0]).getStringValue();
                    Predicate<String> sp = this.parent.createProjectFilter(s);
                    Predicate<NJob> t = x -> sp.test(x.getProject());
                    whereFilter = this.parent.appendPredicate(whereFilter, t);
                    break;
                }
                case "--name": {
                    String s = cmd.nextString(new String[0]).getStringValue();
                    Predicate<String> sp = this.parent.createStringFilter(s);
                    Predicate<NJob> t = x -> sp.test(x.getName());
                    whereFilter = this.parent.appendPredicate(whereFilter, t);
                    break;
                }
                case "-b": 
                case "--beneficiary": {
                    String s = cmd.nextString(new String[0]).getStringValue();
                    Predicate<String> sp = this.parent.createStringFilter(s);
                    Predicate<NJob> t = x -> {
                        NProject project = this.service.projects().getProject(x.getProject());
                        return sp.test(project == null ? "" : project.getBeneficiary());
                    };
                    whereFilter = this.parent.appendPredicate(whereFilter, t);
                    break;
                }
                case "-c": 
                case "--company": {
                    String s = cmd.nextString(new String[0]).getStringValue();
                    Predicate<String> sp = this.parent.createStringFilter(s);
                    Predicate<NJob> t = x -> {
                        NProject project = this.service.projects().getProject(x.getProject());
                        return sp.test(project == null ? "" : project.getCompany());
                    };
                    whereFilter = this.parent.appendPredicate(whereFilter, t);
                    break;
                }
                case "-d": 
                case "--duration": {
                    String s = cmd.nextString(new String[0]).getStringValue();
                    Predicate<TimePeriod> p = TimePeriod.parseFilter(s, false);
                    Predicate<NJob> t = x -> p.test(x.getDuration());
                    whereFilter = this.parent.appendPredicate(whereFilter, t);
                    break;
                }
                case "-t": 
                case "--startTime": 
                case "--start-time": {
                    String s = cmd.nextString(new String[0]).getStringValue();
                    Predicate<Instant> t = new TimeParser().parseInstantFilter(s, false);
                    whereFilter = this.parent.appendPredicate(whereFilter, x -> t.test(x.getStartTime()));
                    break;
                }
                default: {
                    cmd.unexpectedArgument();
                }
            }
        }
        if (cmd.isExecMode()) {
            Stream<NJob> r = this.service.jobs().findLastJobs(null, count, countType, whereFilter, groupBy, timeUnit, hoursPerDay);
            ChronoUnit timeUnit0 = timeUnit;
            if (this.context.getSession().isPlainTrace()) {
                NutsMutableTableModel m = this.ws.formats().table().createModel();
                NJobGroup finalGroupBy = groupBy;
                ArrayList lastResults = new ArrayList();
                int[] index = new int[1];
                r.forEach(x -> {
                    Object[] objectArray;
                    NutsTextStyled durationString = this.ws.text().forStyled(String.valueOf(timeUnit0 == null ? x.getDuration() : x.getDuration().toUnit(timeUnit0, hoursPerDay)), NutsTextStyle.keyword());
                    index[0] = index[0] + 1;
                    lastResults.add(x);
                    NutsMutableTableModel nutsMutableTableModel = m.newRow();
                    if (finalGroupBy != null) {
                        Object[] objectArray2 = new Object[5];
                        objectArray2[0] = this.parent.createHashId(index[0], -1);
                        objectArray2[1] = this.parent.getFormattedDate(x.getStartTime());
                        objectArray2[2] = durationString;
                        objectArray2[3] = this.parent.getFormattedProject(x.getProject() == null ? "*" : x.getProject());
                        objectArray = objectArray2;
                        objectArray2[4] = x.getName();
                    } else {
                        Object[] objectArray3 = new Object[6];
                        objectArray3[0] = this.parent.createHashId(index[0], -1);
                        objectArray3[1] = this.ws.text().forStyled(x.getId(), NutsTextStyle.pale());
                        objectArray3[2] = this.parent.getFormattedDate(x.getStartTime());
                        objectArray3[3] = durationString;
                        objectArray3[4] = this.parent.getFormattedProject(x.getProject() == null ? "*" : x.getProject());
                        objectArray = objectArray3;
                        objectArray3[5] = x.getName();
                    }
                    nutsMutableTableModel.addCells(objectArray);
                });
                this.context.getSession().setProperty("LastResults", (Object)lastResults.toArray(new NJob[0]));
                this.ws.formats().table().setBorder("spaces").setValue((Object)m).println();
            } else {
                this.context.getSession().getWorkspace().formats().object(r.collect(Collectors.toList())).print(this.context.getSession().out());
            }
        }
    }

    private NJob findJob(String pid, NutsCommandLine cmd) {
        NJob t = null;
        if (pid.startsWith("#")) {
            Object lastResults;
            int x = JobServiceCmd.parseIntOrFF(pid.substring(1));
            if (x >= 1 && (lastResults = this.context.getSession().getProperty("LastResults")) instanceof NJob[] && x <= ((NJob[])lastResults).length) {
                t = ((NJob[])lastResults)[x - 1];
            }
        }
        if (t == null) {
            t = this.service.jobs().getJob(pid);
        }
        if (t == null) {
            cmd.throwError(NutsMessage.cstyle((String)"job not found: %s", (Object[])new Object[]{pid}));
        }
        return t;
    }
}

