/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.njob;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.UUID;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsElementFormat;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.toolbox.njob.model.Id;
import net.thevpc.nuts.toolbox.njob.model.NJob;
import net.thevpc.nuts.toolbox.njob.model.NProject;
import net.thevpc.nuts.toolbox.njob.model.NTask;

public class NJobConfigStore {
    private NutsApplicationContext context;
    private NutsElementFormat json;
    private Path dbPath;

    public NJobConfigStore(NutsApplicationContext applicationContext) {
        this.context = applicationContext;
        this.json = applicationContext.getWorkspace().elem().setContentType(NutsContentType.JSON);
        this.json.setCompact(false);
        this.dbPath = Paths.get(applicationContext.getVersionFolderFolder(NutsStoreLocation.CONFIG, "0.8.0.0"), new String[0]).resolve("db");
    }

    private Field getKeyField(Class o) {
        for (Field declaredField : o.getDeclaredFields()) {
            Id a = declaredField.getAnnotation(Id.class);
            if (a == null) continue;
            declaredField.setAccessible(true);
            return declaredField;
        }
        throw new RuntimeException("missing @Id field");
    }

    private Object getKey(Object o) {
        try {
            return this.getKeyField(o.getClass()).get(o);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String getEntityName(Class o) {
        return o.getSimpleName().toLowerCase();
    }

    private Path getObjectFile(Object o) {
        return this.getFile(this.getEntityName(o.getClass()), this.getKey(o));
    }

    private Path getFile(String entityName, Object id) {
        return this.dbPath.resolve(entityName).resolve(id + ".json");
    }

    public <T> Stream<T> search(Class<T> type) {
        Path f = this.getFile(this.getEntityName(type), "any").getParent();
        try {
            if (!Files.isDirectory(f, new LinkOption[0])) {
                return Collections.emptyList().stream();
            }
            return StreamSupport.stream(Files.newDirectoryStream(f, x -> Files.isRegularFile(x, new LinkOption[0]) && x.toString().endsWith(".json")).spliterator(), false).map(x -> {
                try {
                    return this.json.parse(x, type);
                }
                catch (Exception ex) {
                    return null;
                }
            }).filter(x -> x != null);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public <T> T load(Class<T> type, Object id) {
        Path f = this.getFile(this.getEntityName(type), id);
        if (Files.exists(f, new LinkOption[0])) {
            return (T)this.json.parse(f, type);
        }
        return null;
    }

    public void store(Object o) {
        String ii;
        Object j;
        if (o instanceof NJob) {
            j = (NJob)o;
            String ii2 = ((NJob)j).getId();
            if (ii2 == null) {
                ((NJob)j).setId(this.generateId(NJob.class));
            }
        } else if (o instanceof NTask) {
            j = (NTask)o;
            String ii3 = ((NTask)j).getId();
            if (ii3 == null) {
                ((NTask)j).setId(this.generateId(NTask.class));
            }
        } else if (o instanceof NProject && (ii = ((NProject)(j = (NProject)o)).getId()) == null) {
            ((NProject)j).setId(this.generateId(NProject.class));
        }
        Path objectFile = this.getObjectFile(o);
        if (!Files.isDirectory(objectFile.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(objectFile.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new NutsIllegalArgumentException(this.context.getSession(), NutsMessage.cstyle((String)"unable to create parent path", (Object[])new Object[0]));
            }
        }
        this.json.setValue(o).println(objectFile);
    }

    public String generateId(Class clz) {
        String nid;
        Path f;
        do {
            nid = UUID.randomUUID().toString();
        } while (Files.exists(f = this.getFile(this.getEntityName(clz), nid), new LinkOption[0]));
        return nid;
    }

    public boolean delete(Class entityName, Object id) {
        return this.delete(this.getEntityName(entityName), id);
    }

    public boolean delete(String entityName, Object id) {
        Path f = this.getFile(entityName, id);
        if (Files.exists(f, new LinkOption[0])) {
            try {
                Files.delete(f);
                return true;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return false;
    }
}

