/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.docusaurus;

import java.nio.file.Paths;
import net.thevpc.nuts.NutsApplication;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCommandLineProcessor;
import net.thevpc.nuts.NutsConfirmationMode;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.toolbox.docusaurus.DocusaurusCtrl;
import net.thevpc.nuts.toolbox.docusaurus.DocusaurusProject;

public class NDocusaurusMain
implements NutsApplication {
    public static void main(String[] args) {
        NutsApplication.main(NDocusaurusMain.class, (String[])args);
    }

    public void run(final NutsApplicationContext appContext) {
        appContext.processCommandLine(new NutsCommandLineProcessor(){
            boolean start;
            boolean build;
            String workdir = null;
            boolean buildPdf = false;

            public boolean onNextOption(NutsArgument option, NutsCommandLine commandline) {
                switch (option.getStringKey()) {
                    case "-d": 
                    case "--dir": {
                        if (this.workdir != null) break;
                        this.workdir = commandline.nextString(new String[0]).getStringValue();
                        return true;
                    }
                }
                return false;
            }

            public boolean onNextNonOption(NutsArgument nonOption, NutsCommandLine commandline) {
                switch (nonOption.getString()) {
                    case "start": {
                        this.start = commandline.nextBoolean(new String[0]).getBooleanValue();
                        return true;
                    }
                    case "build": {
                        this.build = commandline.nextBoolean(new String[0]).getBooleanValue();
                        return true;
                    }
                    case "pdf": {
                        this.buildPdf = commandline.nextBoolean(new String[0]).getBooleanValue();
                        return true;
                    }
                }
                return false;
            }

            public void onPrepare(NutsCommandLine commandline) {
                if (!(this.start || this.build || this.buildPdf)) {
                    commandline.required(NutsMessage.cstyle((String)"missing command. try ```sh ndocusaurus pdf | start | build```", (Object[])new Object[0]));
                }
            }

            public void onExec() {
                if (this.workdir == null) {
                    this.workdir = ".";
                }
                DocusaurusProject docusaurusProject = new DocusaurusProject(this.workdir, Paths.get(this.workdir, new String[0]).resolve(".dir-template").resolve("src").toString(), appContext.getSession());
                new DocusaurusCtrl(docusaurusProject, appContext).setBuildWebSite(this.build).setStartWebSite(this.start).setBuildPdf(this.buildPdf).setAutoInstallNutsPackages(appContext.getWorkspace().env().getBootOptions().getConfirm() == NutsConfirmationMode.YES).run();
            }
        });
    }
}

