/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.docusaurus;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import net.thevpc.nuts.NutsArrayElement;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.lib.md.MdBody;
import net.thevpc.nuts.lib.md.MdElement;
import net.thevpc.nuts.lib.md.MdElementPath;
import net.thevpc.nuts.lib.md.MdElementTransformBase;
import net.thevpc.nuts.lib.md.MdFactory;
import net.thevpc.nuts.lib.md.MdHr;
import net.thevpc.nuts.lib.md.MdImage;
import net.thevpc.nuts.lib.md.MdNumberedItem;
import net.thevpc.nuts.lib.md.MdNumberedList;
import net.thevpc.nuts.lib.md.MdPhrase;
import net.thevpc.nuts.lib.md.MdText;
import net.thevpc.nuts.lib.md.MdTitle;
import net.thevpc.nuts.lib.md.MdUnNumberedItem;
import net.thevpc.nuts.lib.md.MdUnNumberedList;
import net.thevpc.nuts.lib.md.MdXml;
import net.thevpc.nuts.lib.md.docusaurus.DocusaurusUtils;
import net.thevpc.nuts.lib.md.util.MdUtils;

public class DocusaurusTreeTransform
extends MdElementTransformBase {
    private NutsSession session;
    private int minDepth;
    private String fromPath;
    private String toPath;

    public DocusaurusTreeTransform(NutsSession session, int minDepth, String fromPath, String toPath) {
        this.session = session;
        this.minDepth = minDepth;
        this.fromPath = fromPath;
        this.toPath = toPath;
    }

    protected MdElement transformTitle(MdElementPath<MdTitle> path) {
        MdTitle e = (MdTitle)path.getElement();
        int newDepth = e.type().depth() + this.minDepth - 1;
        if (newDepth > 6) {
            newDepth = 6;
        }
        return new MdTitle(e.getCode(), this.transformElement(path.append(e.getValue())), newDepth, this.transformArray(e.getChildren(), path));
    }

    protected MdElement transformBody(MdElementPath<MdBody> path) {
        MdBody e = (MdBody)path.getElement();
        return new MdBody(this.transformArray(e.getChildren(), path));
    }

    protected MdElement transformPhrase(MdElementPath<MdPhrase> path) {
        MdPhrase e = (MdPhrase)path.getElement();
        return new MdPhrase(this.transformArray(e.getChildren(), path));
    }

    protected MdElement transformUnNumberedList(MdElementPath<MdUnNumberedList> path) {
        MdUnNumberedList e = (MdUnNumberedList)path.getElement();
        return new MdUnNumberedList(e.type().depth(), Arrays.asList(this.transformArray((MdElement[])e.getChildren(), path)).toArray(new MdUnNumberedItem[0]));
    }

    protected MdElement transformNumberedList(MdElementPath<MdNumberedList> path) {
        MdNumberedList e = (MdNumberedList)path.getElement();
        return new MdNumberedList(e.type().depth(), Arrays.asList(this.transformArray((MdElement[])e.getChildren(), path)).toArray(new MdNumberedItem[0]));
    }

    protected MdElement transformUnNumberedItem(MdElementPath<MdUnNumberedItem> path) {
        MdUnNumberedItem e = (MdUnNumberedItem)path.getElement();
        return new MdUnNumberedItem(e.getType(), e.type().depth(), this.transformElement(path.append(e.getValue())), this.transformArray(e.getChildren(), path));
    }

    protected MdElement transformNumberedItem(MdElementPath<MdNumberedItem> path) {
        MdNumberedItem e = (MdNumberedItem)path.getElement();
        return new MdNumberedItem(e.getNumber(), e.type().depth(), e.getSep(), this.transformElement(path.append(e.getValue())), this.transformArray(e.getChildren(), path));
    }

    public MdElement transformDocument(MdElement e) {
        MdBody s;
        MdElement[] content;
        if (e instanceof MdBody && (content = (s = (MdBody)e).getChildren()).length > 0 && content[0] instanceof MdHr) {
            MdElement mdElement;
            int x = 0;
            for (int i = 1; i < content.length; ++i) {
                if (!(content[i] instanceof MdHr)) continue;
                x = i + 1;
                break;
            }
            ArrayList<MdElement> a = new ArrayList<MdElement>();
            for (int i = x; i < content.length; ++i) {
                a.add(content[i]);
            }
            Iterator it = a.iterator();
            while (it.hasNext() && (mdElement = (MdElement)it.next()) instanceof MdText) {
                String t = ((MdText)mdElement).getText();
                if (t.length() == 0) {
                    it.remove();
                    continue;
                }
                if (!t.trim().startsWith("import ")) break;
                it.remove();
            }
            return super.transformDocument(MdFactory.seq(a));
        }
        return super.transformDocument(e);
    }

    protected MdElement transformXml(MdElementPath<MdXml> path) {
        MdXml e = (MdXml)path.getElement();
        switch (e.getTag()) {
            case "Tabs": {
                String props = DocusaurusUtils.skipJsonJSXBrackets((String)((String)e.getProperties().get("values")));
                NutsArrayElement rows = this.session.getWorkspace().elem().parse(props).asSafeArray();
                HashMap<String, MdElement> sub = new HashMap<String, MdElement>();
                for (MdElement item : MdFactory.asBody((MdElement)e.getContent()).getChildren()) {
                    if (item.isXml()) {
                        MdXml tabItem = item.asXml();
                        String t = tabItem.getTag();
                        if (!t.equals("TabItem")) continue;
                        String tt = "Unknown";
                        NutsElement v = this.session.getWorkspace().elem().parse((String)tabItem.getProperties().get("value"));
                        if (v != null) {
                            tt = v.asString();
                        }
                        MdElement u = this.transformXml((MdElementPath<MdXml>)path.append((MdElement)tabItem));
                        sub.put(tt, u);
                        continue;
                    }
                    if (item.isText()) {
                        if (item.asText().getText().trim().length() <= 0) continue;
                        throw new IllegalArgumentException("unexpected xml content: " + item.type() + ":" + item.asText().getText());
                    }
                    throw new IllegalArgumentException("unexpected xml content: " + item.type() + ":");
                }
                ArrayList<MdElement> res = new ArrayList<MdElement>();
                for (NutsElement row : rows) {
                    MdElement r = (MdElement)sub.get(row.asSafeObject().getSafeString("value"));
                    if (r == null) continue;
                    res.add(r);
                }
                return MdFactory.seq((MdElement[])res.toArray(new MdElement[0]));
            }
            case "TabItem": {
                String tt = "Unknown";
                NutsElement v = this.session.getWorkspace().elem().parse((String)e.getProperties().get("value"));
                if (v != null) {
                    tt = v.asString();
                }
                String props = DocusaurusUtils.skipJsonJSXBrackets((String)((String)path.getParentPath().getElement().asXml().getProperties().get("values")));
                for (NutsElement a : this.session.getWorkspace().elem().parse(props).asSafeArray()) {
                    if (!tt.equals(a.asSafeObject().getSafeString("value"))) continue;
                    tt = a.asSafeObject().getSafeString("label");
                    break;
                }
                if (tt.equals("C#")) {
                    tt = "C Sharp";
                }
                return new MdBody(new MdElement[]{new MdTitle("#####", (MdElement)MdText.phrase((String)tt), 5, new MdElement[0]), this.transformElement(path.append(e.getContent()))});
            }
        }
        return e;
    }

    protected MdElement transformImage(MdElementPath<MdImage> path) {
        String url;
        MdImage element = (MdImage)path.getElement();
        if (element.getImageFormat() == MdImage.ImageFormat.PATH && (url = element.getImageUrl()).length() > 0 && MdUtils.isRelativePath((String)url)) {
            return new MdImage(element.getType(), element.getImageFormat(), element.getImageTitle(), MdUtils.toRelativePath((String)Paths.get(this.fromPath, new String[0]).resolve(url).toString(), (String)this.toPath));
        }
        return element;
    }
}

