/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.docusaurus;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementEntry;
import net.thevpc.nuts.NutsObjectElement;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.lib.md.MdElement;
import net.thevpc.nuts.toolbox.docusaurus.DocusaurusFile;
import net.thevpc.nuts.toolbox.docusaurus.DocusaurusFileOrFolder;
import net.thevpc.nuts.toolbox.docusaurus.DocusaurusFolder;
import net.thevpc.nuts.toolbox.docusaurus.DocusaurusPathFile;
import net.thevpc.nuts.toolbox.docusaurus.NameResolver;

public class DocusaurusProject {
    public static final String DOCUSAURUS_FOLDER_CONFIG = ".docusaurus-folder-config.json";
    public static final String DOCUSAURUS_FOLDER_CONFIG_MIMETYPE = "text/x-json-docusaurus-folder-config";
    NameResolver nameResolver = new NameResolver(){

        @Override
        public boolean accept(DocusaurusFileOrFolder item, String name) {
            if (item.isFolder() && item.getTitle().equals(name)) {
                return true;
            }
            return item.getShortId().equals(name);
        }
    };
    private String docusaurusConfigBaseFolder;
    private String docusaurusBaseFolder;
    private NutsSession session;

    public DocusaurusProject(String docusaurusBaseFolder, String docusaurusConfigBaseFolder, NutsSession session) {
        this.docusaurusBaseFolder = Paths.get(docusaurusBaseFolder, new String[0]).toAbsolutePath().toString();
        this.docusaurusConfigBaseFolder = docusaurusConfigBaseFolder == null ? docusaurusBaseFolder : docusaurusConfigBaseFolder;
        this.session = session;
        if (!Files.exists(Paths.get(this.resolvePath("docusaurus.config.js"), new String[0]), new LinkOption[0])) {
            throw new IllegalArgumentException("Invalid docusaurus v2 folder : " + this.toCanonicalPath(this.docusaurusBaseFolder));
        }
    }

    public NutsSession getSession() {
        return this.session;
    }

    private static String extractPartialPathParentString(Path p, Path rootPath) {
        Path pp = DocusaurusProject.extractPartialPath(p, rootPath).getParent();
        return pp == null ? null : pp.toString();
    }

    private static Path extractPartialPath(Path p, Path rootPath) {
        if (p.startsWith(rootPath)) {
            return p.subpath(rootPath.getNameCount(), p.getNameCount());
        }
        throw new IllegalArgumentException("Invalid partial path");
    }

    public String getDocusaurusBaseFolder() {
        return this.docusaurusBaseFolder;
    }

    public NutsObjectElement getSidebars() {
        return this.loadModuleExportsFile("sidebars.js").asSafeObject();
    }

    public String getTitle() {
        return this.getConfig().get("title").asString();
    }

    public String getProjectName() {
        return this.getConfig().get("projectName").asString();
    }

    public NutsObjectElement getConfig() {
        return this.loadModuleExportsFile("docusaurus.config.js").asSafeObject();
    }

    private String resolvePath(String path) {
        String p = this.docusaurusBaseFolder;
        if (!p.endsWith("/") && !path.startsWith("/")) {
            p = p + "/";
        }
        return p + path;
    }

    public NutsElement loadModuleExportsFile(String path) {
        String a = null;
        try {
            a = new String(Files.readAllBytes(Paths.get(this.resolvePath(path), new String[0])));
        }
        catch (IOException ex) {
            return this.session.getWorkspace().elem().forNull();
        }
        Pattern p = Pattern.compile("(?s)module.exports[ ]*=[ ]*(?<json>.*[^;])[;]?");
        Matcher matcher = p.matcher(a.trim());
        String json = null;
        if (matcher.find()) {
            json = matcher.group("json");
        }
        if (json == null) {
            return this.session.getWorkspace().elem().forObject().build();
        }
        return (NutsElement)this.session.getWorkspace().elem().setContentType(NutsContentType.JSON).parse(json, NutsElement.class);
    }

    private String toCanonicalPath(String path) {
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException ex) {
            return new File(path).getAbsolutePath();
        }
    }

    public DocusaurusFileOrFolder[] LJSON_to_DocusaurusFileOrFolder_list(NutsElement a, DocusaurusFolder root) {
        if (a.isString()) {
            return new DocusaurusFileOrFolder[]{root.getPage(a.asString(), true, null)};
        }
        if (a.isArray()) {
            ArrayList<DocusaurusFileOrFolder> aa = new ArrayList<DocusaurusFileOrFolder>();
            for (NutsElement ljson : a.asArray()) {
                aa.addAll(Arrays.asList(this.LJSON_to_DocusaurusFileOrFolder_list(ljson, root)));
            }
            return aa.toArray(new DocusaurusFileOrFolder[0]);
        }
        if (a.isObject()) {
            ArrayList<DocusaurusFolder> aa = new ArrayList<DocusaurusFolder>();
            int order = 0;
            for (NutsElementEntry member : a.asObject()) {
                DocusaurusFileOrFolder[] cc = this.LJSON_to_DocusaurusFileOrFolder_list(member.getValue(), root);
                String rootPath = root.getPath();
                Path parentPath = null;
                parentPath = rootPath != null ? Paths.get(rootPath, new String[0]) : this.detectFileParent(cc);
                aa.add(new DocusaurusFolder(member.getKey().asString(), member.getKey().asString(), ++order, this.session.getWorkspace().elem().forObject().build(), cc, this.resolveFolderContent(parentPath), parentPath == null ? null : parentPath.toString()));
            }
            return aa.toArray(new DocusaurusFileOrFolder[0]);
        }
        throw new IllegalArgumentException("invalid");
    }

    public Path detectFileParent(DocusaurusFileOrFolder[] f) {
        LinkedHashSet<Path> valid = new LinkedHashSet<Path>();
        for (DocusaurusFileOrFolder child : f) {
            Path path = this.detectFile(child);
            if (path == null) continue;
            valid.add(path.getParent());
        }
        if (valid.size() > 0) {
            return valid.stream().findFirst().orElse(null);
        }
        return null;
    }

    public Path detectFile(DocusaurusFileOrFolder f) {
        if (f instanceof DocusaurusFolder) {
            return this.detectFileParent(((DocusaurusFolder)f).getChildren());
        }
        if (f instanceof DocusaurusPathFile) {
            return ((DocusaurusPathFile)f).getPath();
        }
        return null;
    }

    public DocusaurusFolder getSidebarsDocsFolder() {
        DocusaurusFileOrFolder[] someSidebars = this.LJSON_to_DocusaurusFileOrFolder_list(this.getSidebars().getSafe("someSidebar"), this.getPhysicalDocsFolder());
        return new DocusaurusFolder("/", "/", 0, this.session.getWorkspace().elem().forObject().build(), someSidebars, this.resolveFolderContent(this.getPhysicalDocsFolderBasePath()), this.getPhysicalDocsFolder().getPath());
    }

    public MdElement resolveFolderContent(Path path) {
        if (path == null) {
            return null;
        }
        Path in = path.resolve("folder-info.md");
        if (Files.isRegularFile(in, new LinkOption[0])) {
            DocusaurusFile baseContent = (DocusaurusFile)DocusaurusFolder.ofFileOrFolder(this.session, in, this.getPhysicalDocsFolderBasePath(), this.getPhysicalDocsFolderConfigPath(), -1);
            return baseContent == null ? null : baseContent.getContent(this.session);
        }
        return null;
    }

    public Path getPhysicalDocsFolderBasePath() {
        return Paths.get(this.docusaurusBaseFolder, new String[0]).resolve("docs").toAbsolutePath();
    }

    public Path getPhysicalDocsFolderConfigPath() {
        return Paths.get(this.docusaurusBaseFolder, new String[0]).resolve("docs").toAbsolutePath();
    }

    public DocusaurusFolder getPhysicalDocsFolder() {
        Path docs = this.getPhysicalDocsFolderBasePath();
        DocusaurusFolder root = (DocusaurusFolder)DocusaurusFolder.ofFileOrFolder(this.session, docs, docs, this.getPhysicalDocsFolderConfigPath());
        return root;
    }
}

