/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.docusaurus;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.lib.md.MdElement;
import net.thevpc.nuts.toolbox.docusaurus.DocusaurusContentFile;
import net.thevpc.nuts.toolbox.docusaurus.DocusaurusFile;

public class DocusaurusPathFile
extends DocusaurusFile {
    private final Path path;

    public DocusaurusPathFile(String shortId, String longId, String title, Path path, int order, NutsElement config) {
        super(shortId, longId, title, order, config);
        this.path = path;
    }

    public static DocusaurusFile ofFile(String id, String longId, String title, Path path, int menuOrder, NutsElement config) {
        return new DocusaurusPathFile(id, longId, title, path, menuOrder, config);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DocusaurusFile ofFile(Path path, Path root, NutsSession session) {
        int to;
        int from = root.getNameCount();
        String partialPath = from == (to = path.getNameCount() - 1) ? "" : path.subpath(from, to).toString();
        try (BufferedReader br = Files.newBufferedReader(path);){
            DocusaurusFile df = DocusaurusContentFile.ofTreeFile(br, partialPath, path.toString(), session, false);
            if (df != null && df.getShortId() != null) {
                DocusaurusFile docusaurusFile2 = DocusaurusPathFile.ofFile(df.getShortId(), df.getLongId(), df.getTitle(), path, df.getOrder(), df.getConfig());
                return docusaurusFile2;
            }
            DocusaurusFile docusaurusFile = null;
            return docusaurusFile;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Path getPath() {
        return this.path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MdElement getContent(NutsSession session) {
        try (BufferedReader reader = Files.newBufferedReader(this.getPath());){
            DocusaurusFile tree = DocusaurusContentFile.ofTreeFile(reader, this.getLongId(), this.getLongId(), session, true);
            MdElement mdElement = tree != null ? tree.getContent(session) : null;
            return mdElement;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

